/*
 * FILE : OpenSSL_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 745)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* $Header: /cvsroot/SWIG1.1/swig_lib/perl5/headers.swg,v 1.1.1.1 1999/02/28 02:00:54 beazley Exp $ */
/* Implementation : PERL 5 */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny
   games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#include <string.h>
#ifdef __cplusplus
}
#endif
/* Definitions for compiling Perl extensions on a variety of machines */

#if defined(WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
#define MAGIC_CAST   (int (CPerlObj::*)(SV *, MAGIC *))
#define SWIGCLASS_STATIC 
#else
#define MAGIC_PPERL
#define MAGIC_CAST
#define SWIGCLASS_STATIC static
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#ifndef PL_sv_yes
#define PL_sv_yes sv_yes
#endif
#ifndef PL_sv_undef
#define PL_sv_undef sv_undef
#endif
#ifndef PL_na
#define PL_na na
#endif
#endif


/*****************************************************************************
 * $Header: /cvsroot/SWIG1.1/swig_lib/perl5/perl5ptr.swg,v 1.3 1999/04/08 22:58:47 beazley Exp $
 *
 * perl5ptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is only used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer.
 *
 * char * SWIG_GetPtr(SV *obj, void **ptr, char *type)
 *
 *      Gets a pointer value from a Perl5 scalar value.  If there is a 
 *      type-mismatch, returns a character string to the received type.  
 *      On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */
static int SwigStart[256];             /* Table containing starting positions    */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

#ifndef PERL_OBJECT
SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {
#else
SWIGSTATIC
#define SWIG_RegisterMapping(a,b,c) _SWIG_RegisterMapping(pPerl, a,b,c)
void _SWIG_RegisterMapping(CPerlObj *pPerl, char *origtype, char *newtype, void *(*cast)(void *)) {
#endif

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

#ifndef PERL_OBJECT
SWIGSTATIC 
char *SWIG_GetPtr(SV *sv, void **ptr, char *_t)
#else
SWIGSTATIC
#define SWIG_GetPtr(a,b,c) _SWIG_GetPtr(pPerl,a,b,c)
char *_SWIG_GetPtr(CPerlObj *pPerl, SV *sv, void **ptr, char *_t)
#endif
{
  char temp_type[256];
  char *name,*_c;
  int  len,i,start,end;
  IV   tmp;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;

  /* If magical, apply more magic */

  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
	mg = mg_find(tsv,'P');
	if (mg) {
	  SV *rsv = mg->mg_obj;
	  if (sv_isobject(rsv)) {
	    tmp = SvIV((SV*)SvRV(rsv));
	  }
	}
      } else {
	return "Not a valid pointer value";
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    if (!_t) {
      *(ptr) = (void *) tmp;
      return (char *) 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return (char *) 0;
  } else if (SvTYPE(sv) == SVt_RV) {       /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv)) 
      return (char *) 0;
    else
      return "Not a valid pointer value";
  } else {                                 /* Don't know what it is */
      *(ptr) = (void *) 0;
      return "Not a valid pointer value";
  }
  if (_t) {
    /* Now see if the types match */      

    if (!sv_isa(sv,_t)) {
      _c = HvNAME(SvSTASH(SvRV(sv)));
      if (!SwigPtrSort) {
	qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort);  
	for (i = 0; i < 256; i++) {
	  SwigStart[i] = SwigPtrN;
	}
	for (i = SwigPtrN-1; i >= 0; i--) {
	  SwigStart[SwigPtrTable[i].name[0]] = i;
	}
	for (i = 255; i >= 1; i--) {
	  if (SwigStart[i-1] > SwigStart[i])
	    SwigStart[i-1] = SwigStart[i];
	}
	SwigPtrSort = 1;
	for (i = 0; i < SWIG_CACHESIZE; i++)  
	  SwigCache[i].stat = 0;
      }
      /* First check cache for matches.  Uses last cache value as starting point */
      cache = &SwigCache[SwigLastCache];
      for (i = 0; i < SWIG_CACHESIZE; i++) {
	if (cache->stat) {
	  if (strcmp(_t,cache->name) == 0) {
	    if (strcmp(_c,cache->mapped) == 0) {
	      cache->stat++;
	      *ptr = (void *) tmp;
	      if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
	      return (char *) 0;
	    }
	  }
	}
	SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	if (!SwigLastCache) cache = SwigCache;
	else cache++;
      }

      start = SwigStart[_t[0]];
      end = SwigStart[_t[0]+1];
      sp = &SwigPtrTable[start];
      while (start < end) {
	if (swigcmp(_t,sp) == 0) break;
	sp++;
	start++;
      }
      if (start > end) sp = 0;
      while (start <= end) {
	if (swigcmp(_t,sp) == 0) {
	  name = sp->name;
	  len = sp->len;
	  tp = sp->next;
	  while(tp) {
	    if (tp->len >= 255) {
	      return _c;
	    }
	    strcpy(temp_type,tp->name);
	    strncat(temp_type,_t+len,255-tp->len);
	    if (sv_isa(sv,temp_type)) {
	      /* Get pointer value */
	      *ptr = (void *) tmp;
	      if (tp->cast) *ptr = (*(tp->cast))(*ptr);

	      strcpy(SwigCache[SwigCacheIndex].mapped,_c);
	      strcpy(SwigCache[SwigCacheIndex].name,_t);
	      SwigCache[SwigCacheIndex].stat = 1;
	      SwigCache[SwigCacheIndex].tp = tp;
	      SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
	      return (char *) 0;
	    }
	    tp = tp->next;
	  } 
	}
	sp++;
	start++;
      }
      /* Didn't find any sort of match for this data.  
	 Get the pointer value and return the received type */
      *ptr = (void *) tmp;
      return _c;
    } else {
      /* Found a match on the first try.  Return pointer value */
      *ptr = (void *) tmp;
      return (char *) 0;
    }
  } 
  *ptr = (void *) tmp;
  return (char *) 0;
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr
/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
#else
#define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = get;
  mg->mg_virtual->svt_set = set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}

#define SWIG_init    boot_OpenSSL

#define SWIG_name   "OpenSSL::boot_OpenSSL"
#define SWIG_varinit "OpenSSL::var_OpenSSL_init();"
#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
SWIGEXPORT(void,boot_OpenSSL)(CV* cv);
#else
SWIGEXPORT(void,boot_OpenSSL)(CV *cv, CPerlObj *);
#endif


  /*
    OpenSSL interface wrapper file (aspa@hip.fi).
  */

#include <errno.h>
#include <ssl.h>

// SSIZE_MAX
#define OSSL_BUF_SIZE 32768
#define OSSL_STR_SIZE 256


/* make swig handle the function pointers. */
typedef int (*callback_ptr_t)();


/* language (perl, tcl, python) specific stuff */
#ifdef SWIGPERL5
   ; 
#elif SWIGTCL8
   ;
#elif SWIGPYTHON
   ;
#else
   ; 
#endif



  /* SSL_CTX_set_options_W() and SSL_set_options_W() are defined as
     functions because SWIG can't handle function macros. */

  // ssl/ssl.h
  void SSL_CTX_set_options_W(SSL_CTX *ctx, unsigned long int op) {
    ctx->options |= op;
  }
  
  // ssl/ssl.h
  void SSL_set_options_W(SSL *ssl, unsigned long int op) {
    ssl->options |= op;
  }

  /* the X509_NAME_oneline_W() and SSL_read_W() functions need
     wrappers for buffer management. */

  // crypto/x509/x509_obj.c.
  char *X509_NAME_oneline_W(X509_NAME *a) {
    static char str_buf[OSSL_STR_SIZE];
    
    return X509_NAME_oneline(a, str_buf, OSSL_STR_SIZE);
  }

  // ssl/bio_ssl.c: ssl_read.
  int SSL_read_W(char **SSL_read_buf_p, SSL *ssl, int max_bytes) {
    static char buffer[OSSL_BUF_SIZE];
    int n;
    
    n = SSL_read(ssl, buffer, max_bytes);
    *SSL_read_buf_p = buffer;

    return n;
  }


#ifndef PERL_OBJECT
#define swig_setiv(a,b) _swig_setiv(a,b)
static void _swig_setiv(char *name, long value) { 
#else
#define swig_setiv(a,b) _swig_setiv(pPerl,a,b)
static void _swig_setiv(CPerlObj *pPerl, char *name, long value) { 
#endif
     SV *sv; 
     sv = perl_get_sv(name,TRUE | 0x2);
     sv_setiv(sv, (IV) value);
     SvREADONLY_on(sv);
}

#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_OpenSSL_var::
class _wrap_OpenSSL_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}


#ifdef PERL_OBJECT
};
#endif

XS(_wrap_SSL_CTX_set_options_W) {

    SSL_CTX * _arg0;
    unsigned long  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_CTX_set_options_W(ctx,op);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_set_options_W. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    _arg1 = (unsigned long )SvIV(ST(1));
    SSL_CTX_set_options_W(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_SSL_set_options_W) {

    SSL * _arg0;
    unsigned long  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_set_options_W(ssl,op);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_set_options_W. Expected SSLPtr.");
        XSRETURN(1);
    }
    _arg1 = (unsigned long )SvIV(ST(1));
    SSL_set_options_W(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_X509_NAME_oneline_W) {

    char * _result;
    X509_NAME * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: X509_NAME_oneline_W(a);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509_NAMEPtr")) {
        croak("Type error in argument 1 of X509_NAME_oneline_W. Expected X509_NAMEPtr.");
        XSRETURN(1);
    }
    _result = (char *)X509_NAME_oneline_W(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_read_W) {

    int  _result;
    char ** _arg0;
    char * bufp;
    SSL * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
{
  bufp = NULL;
  _arg0 = &bufp;
}
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_read_W(ssl,max_bytes);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg1,"SSLPtr")) {
        croak("Type error in argument 2 of SSL_read_W. Expected SSLPtr.");
        XSRETURN(1);
    }
    _arg2 = (int )SvIV(ST(1));
    _result = (int )SSL_read_W(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
{
  ST(argvi) = sv_newmortal();
  if( _result >= 0)
    sv_setpvn((SV *) ST(argvi), *_arg0, _result);
  argvi++;
}
    XSRETURN(argvi);
}

XS(_wrap_ERR_get_error) {

    unsigned long  _result;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: ERR_get_error();");
    _result = (unsigned long )ERR_get_error();
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_ERR_error_string) {

    char * _result;
    unsigned long  _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: ERR_error_string(e,buf);");
    _arg0 = (unsigned long )SvIV(ST(0));
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _result = (char *)ERR_error_string(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_X509_NAME_free) {

    X509_NAME * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: X509_NAME_free(a);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509_NAMEPtr")) {
        croak("Type error in argument 1 of X509_NAME_free. Expected X509_NAMEPtr.");
        XSRETURN(1);
    }
    X509_NAME_free(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_X509_free) {

    X509 * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: X509_free(a);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509Ptr")) {
        croak("Type error in argument 1 of X509_free. Expected X509Ptr.");
        XSRETURN(1);
    }
    X509_free(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_X509_NAME_oneline) {

    char * _result;
    X509_NAME * _arg0;
    char * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: X509_NAME_oneline(a,buf,size);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509_NAMEPtr")) {
        croak("Type error in argument 1 of X509_NAME_oneline. Expected X509_NAMEPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (int )SvIV(ST(2));
    _result = (char *)X509_NAME_oneline(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_X509_get_issuer_name) {

    X509_NAME * _result;
    X509 * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: X509_get_issuer_name(a);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509Ptr")) {
        croak("Type error in argument 1 of X509_get_issuer_name. Expected X509Ptr.");
        XSRETURN(1);
    }
    _result = (X509_NAME *)X509_get_issuer_name(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"X509_NAMEPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_X509_get_subject_name) {

    X509_NAME * _result;
    X509 * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: X509_get_subject_name(a);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"X509Ptr")) {
        croak("Type error in argument 1 of X509_get_subject_name. Expected X509Ptr.");
        XSRETURN(1);
    }
    _result = (X509_NAME *)X509_get_subject_name(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"X509_NAMEPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_new) {

    SSL_CTX * _result;
    SSL_METHOD * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_CTX_new(meth);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_METHODPtr")) {
        croak("Type error in argument 1 of SSL_CTX_new. Expected SSL_METHODPtr.");
        XSRETURN(1);
    }
    _result = (SSL_CTX *)SSL_CTX_new(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_CTXPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_free) {

    SSL_CTX * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_CTX_free(SSL_CTX *);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_free. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    SSL_CTX_free(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_SSL_get_current_cipher) {

    SSL_CIPHER * _result;
    SSL * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_get_current_cipher(s);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_get_current_cipher. Expected SSLPtr.");
        XSRETURN(1);
    }
    _result = (SSL_CIPHER *)SSL_get_current_cipher(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_CIPHERPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CIPHER_get_name) {

    char * _result;
    SSL_CIPHER * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_CIPHER_get_name(c);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CIPHERPtr")) {
        croak("Type error in argument 1 of SSL_CIPHER_get_name. Expected SSL_CIPHERPtr.");
        XSRETURN(1);
    }
    _result = (char *)SSL_CIPHER_get_name(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_set_fd) {

    int  _result;
    SSL * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_set_fd(s,fd);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_set_fd. Expected SSLPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )SSL_set_fd(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_set_cipher_list) {

    int  _result;
    SSL * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_set_cipher_list(s,str);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_set_cipher_list. Expected SSLPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _result = (int )SSL_set_cipher_list(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_use_RSAPrivateKey_file) {

    int  _result;
    SSL_CTX * _arg0;
    char * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_CTX_use_RSAPrivateKey_file(ctx,file,type);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_use_RSAPrivateKey_file. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (int )SvIV(ST(2));
    _result = (int )SSL_CTX_use_RSAPrivateKey_file(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_use_certificate_file) {

    int  _result;
    SSL_CTX * _arg0;
    char * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_CTX_use_certificate_file(ctx,file,type);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_use_certificate_file. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (int )SvIV(ST(2));
    _result = (int )SSL_CTX_use_certificate_file(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_load_error_strings) {

    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: SSL_load_error_strings();");
    SSL_load_error_strings();
    XSRETURN(argvi);
}

XS(_wrap_SSL_get_peer_certificate) {

    X509 * _result;
    SSL * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_get_peer_certificate(s);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_get_peer_certificate. Expected SSLPtr.");
        XSRETURN(1);
    }
    _result = (X509 *)SSL_get_peer_certificate(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"X509Ptr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_get_verify_mode) {

    int  _result;
    SSL_CTX * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_CTX_get_verify_mode(ctx);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_get_verify_mode. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    _result = (int )SSL_CTX_get_verify_mode(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_set_verify) {

    SSL_CTX * _arg0;
    int  _arg1;
    callback_ptr_t  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_CTX_set_verify(ctx,mode,cp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_set_verify. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (SWIG_GetPtr(ST(2),(void **) &_arg2,"callback_ptr_t")) {
        croak("Type error in argument 3 of SSL_CTX_set_verify. Expected callback_ptr_t.");
        XSRETURN(1);
    }
    SSL_CTX_set_verify(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_SSL_set_verify) {

    SSL * _arg0;
    int  _arg1;
    callback_ptr_t  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_set_verify(s,mode,cp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_set_verify. Expected SSLPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (SWIG_GetPtr(ST(2),(void **) &_arg2,"callback_ptr_t")) {
        croak("Type error in argument 3 of SSL_set_verify. Expected callback_ptr_t.");
        XSRETURN(1);
    }
    SSL_set_verify(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_SSL_new) {

    SSL * _result;
    SSL_CTX * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_new(ctx);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_new. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    _result = (SSL *)SSL_new(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSLPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_free) {

    SSL * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_free(ssl);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_free. Expected SSLPtr.");
        XSRETURN(1);
    }
    SSL_free(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_SSL_accept) {

    int  _result;
    SSL * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_accept(ssl);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_accept. Expected SSLPtr.");
        XSRETURN(1);
    }
    _result = (int )SSL_accept(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_connect) {

    int  _result;
    SSL * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: SSL_connect(ssl);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_connect. Expected SSLPtr.");
        XSRETURN(1);
    }
    _result = (int )SSL_connect(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_read) {

    int  _result;
    SSL * _arg0;
    char * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_read(ssl,buf,num);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_read. Expected SSLPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (int )SvIV(ST(2));
    _result = (int )SSL_read(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_write) {

    int  _result;
    SSL * _arg0;
    char * _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_write(ssl,buf,num);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_write. Expected SSLPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (int )SvIV(ST(2));
    _result = (int )SSL_write(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSL_get_error) {

    int  _result;
    SSL * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: SSL_get_error(s,ret_code);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSLPtr")) {
        croak("Type error in argument 1 of SSL_get_error. Expected SSLPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )SSL_get_error(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSLv2_method) {

    SSL_METHOD * _result;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: SSLv2_method();");
    _result = (SSL_METHOD *)SSLv2_method();
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_METHODPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSLv3_method) {

    SSL_METHOD * _result;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: SSLv3_method();");
    _result = (SSL_METHOD *)SSLv3_method();
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_METHODPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSLv23_method) {

    SSL_METHOD * _result;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: SSLv23_method();");
    _result = (SSL_METHOD *)SSLv23_method();
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_METHODPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_TLSv1_method) {

    SSL_METHOD * _result;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: TLSv1_method();");
    _result = (SSL_METHOD *)TLSv1_method();
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"SSL_METHODPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_SSLeay_add_ssl_algorithms) {

    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 0) || (items > 0)) 
        croak("Usage: SSLeay_add_ssl_algorithms();");
    SSLeay_add_ssl_algorithms();
    XSRETURN(argvi);
}

XS(_wrap_SSL_CTX_load_verify_locations) {

    int  _result;
    SSL_CTX * _arg0;
    char * _arg1;
    char * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: SSL_CTX_load_verify_locations(ctx,CAfile,CApath);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"SSL_CTXPtr")) {
        croak("Type error in argument 1 of SSL_CTX_load_verify_locations. Expected SSL_CTXPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    _result = (int )SSL_CTX_load_verify_locations(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_perl5_OpenSSL_var_init) {
    dXSARGS;
    SV *sv;
    cv = cv; items = items;
    swig_setiv("OpenSSL::X509_FILETYPE_PEM", (long) 1);
    swig_setiv("OpenSSL::X509_FILETYPE_ASN1", (long) 2);
    swig_setiv("OpenSSL::X509_FILETYPE_DEFAULT", (long) 3);
    swig_setiv("OpenSSL::SSL_FILETYPE_ASN1", (long) (2));
    swig_setiv("OpenSSL::SSL_FILETYPE_PEM", (long) (1));
    swig_setiv("OpenSSL::SSL_OP_ALL", (long) 0x000FFFFFL);
    swig_setiv("OpenSSL::SSL_VERIFY_NONE", (long) 0x00);
    swig_setiv("OpenSSL::SSL_VERIFY_PEER", (long) 0x01);
    swig_setiv("OpenSSL::SSL_VERIFY_FAIL_IF_NO_PEER_CERT", (long) 0x02);
    swig_setiv("OpenSSL::SSL_VERIFY_CLIENT_ONCE", (long) 0x04);
    XSRETURN(1);
}
#ifdef __cplusplus
extern "C"
#endif
XS(boot_OpenSSL) {
	 dXSARGS;
	 char *file = __FILE__;
	 cv = cv; items = items;
	 newXS("OpenSSL::var_OpenSSL_init", _wrap_perl5_OpenSSL_var_init, file);
	 newXS("OpenSSL::SSL_CTX_set_options_W", _wrap_SSL_CTX_set_options_W, file);
	 newXS("OpenSSL::SSL_set_options_W", _wrap_SSL_set_options_W, file);
	 newXS("OpenSSL::X509_NAME_oneline_W", _wrap_X509_NAME_oneline_W, file);
	 newXS("OpenSSL::SSL_read_W", _wrap_SSL_read_W, file);
	 newXS("OpenSSL::ERR_get_error", _wrap_ERR_get_error, file);
	 newXS("OpenSSL::ERR_error_string", _wrap_ERR_error_string, file);
	 newXS("OpenSSL::X509_NAME_free", _wrap_X509_NAME_free, file);
	 newXS("OpenSSL::X509_free", _wrap_X509_free, file);
	 newXS("OpenSSL::X509_NAME_oneline", _wrap_X509_NAME_oneline, file);
	 newXS("OpenSSL::X509_get_issuer_name", _wrap_X509_get_issuer_name, file);
	 newXS("OpenSSL::X509_get_subject_name", _wrap_X509_get_subject_name, file);
	 newXS("OpenSSL::SSL_CTX_new", _wrap_SSL_CTX_new, file);
	 newXS("OpenSSL::SSL_CTX_free", _wrap_SSL_CTX_free, file);
	 newXS("OpenSSL::SSL_get_current_cipher", _wrap_SSL_get_current_cipher, file);
	 newXS("OpenSSL::SSL_CIPHER_get_name", _wrap_SSL_CIPHER_get_name, file);
	 newXS("OpenSSL::SSL_set_fd", _wrap_SSL_set_fd, file);
	 newXS("OpenSSL::SSL_set_cipher_list", _wrap_SSL_set_cipher_list, file);
	 newXS("OpenSSL::SSL_CTX_use_RSAPrivateKey_file", _wrap_SSL_CTX_use_RSAPrivateKey_file, file);
	 newXS("OpenSSL::SSL_CTX_use_certificate_file", _wrap_SSL_CTX_use_certificate_file, file);
	 newXS("OpenSSL::SSL_load_error_strings", _wrap_SSL_load_error_strings, file);
	 newXS("OpenSSL::SSL_get_peer_certificate", _wrap_SSL_get_peer_certificate, file);
	 newXS("OpenSSL::SSL_CTX_get_verify_mode", _wrap_SSL_CTX_get_verify_mode, file);
	 newXS("OpenSSL::SSL_CTX_set_verify", _wrap_SSL_CTX_set_verify, file);
	 newXS("OpenSSL::SSL_set_verify", _wrap_SSL_set_verify, file);
	 newXS("OpenSSL::SSL_new", _wrap_SSL_new, file);
	 newXS("OpenSSL::SSL_free", _wrap_SSL_free, file);
	 newXS("OpenSSL::SSL_accept", _wrap_SSL_accept, file);
	 newXS("OpenSSL::SSL_connect", _wrap_SSL_connect, file);
	 newXS("OpenSSL::SSL_read", _wrap_SSL_read, file);
	 newXS("OpenSSL::SSL_write", _wrap_SSL_write, file);
	 newXS("OpenSSL::SSL_get_error", _wrap_SSL_get_error, file);
	 newXS("OpenSSL::SSLv2_method", _wrap_SSLv2_method, file);
	 newXS("OpenSSL::SSLv3_method", _wrap_SSLv3_method, file);
	 newXS("OpenSSL::SSLv23_method", _wrap_SSLv23_method, file);
	 newXS("OpenSSL::TLSv1_method", _wrap_TLSv1_method, file);
	 newXS("OpenSSL::SSLeay_add_ssl_algorithms", _wrap_SSLeay_add_ssl_algorithms, file);
	 newXS("OpenSSL::SSL_CTX_load_verify_locations", _wrap_SSL_CTX_load_verify_locations, file);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("unsigned short","short",0);
	 SWIG_RegisterMapping("long","unsigned long",0);
	 SWIG_RegisterMapping("long","signed long",0);
	 SWIG_RegisterMapping("signed short","short",0);
	 SWIG_RegisterMapping("signed int","int",0);
	 SWIG_RegisterMapping("short","unsigned short",0);
	 SWIG_RegisterMapping("short","signed short",0);
	 SWIG_RegisterMapping("unsigned long","long",0);
	 SWIG_RegisterMapping("int","unsigned int",0);
	 SWIG_RegisterMapping("int","signed int",0);
	 SWIG_RegisterMapping("unsigned int","int",0);
	 SWIG_RegisterMapping("signed long","long",0);
	 ST(0) = &PL_sv_yes;
	 XSRETURN(1);
}
