#!perl
#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2004 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: Makefile.PL,v 1.22 2004/12/29 01:16:10 fredo Exp $
#
#=======================================================================

require 5.008;

use ExtUtils::MakeMaker;
use Getopt::Long;
use POSIX;

my $versionfile = "lib/PDF/API2/Version.pm";

require "$versionfile";

sub write_version ($) {
    my $hex=shift @_;
    my $tim=POSIX::strftime('%Y-%m-%d %H:%M:%S',localtime());
    my $dat=POSIX::strftime('%Y-%m-%d',localtime());
    my $name='PDF::API2';
    # hexversion = VVRRRTLL
    my $lev=sprintf('%02i',$hex & 0xff);
    my $typ=($hex>>8) & 0xf;
    my $rev=sprintf('%02i',($hex>>12) & 0xfff);
    my $ver=($hex>>24) & 0xff;
    my $ptyp=$typ;
    my $bld=$hex & 0xfff;
    my $tbld='';
    if($typ==0) {
        $ptyp='_'; $tbld="alpha-$bld"; $typ='a'; 
    } elsif($typ<5) {
        $ptyp='_'; $tbld="beta-$bld"; $typ='b'; 
    } elsif($typ<13) {
        $ptyp='_'; $tbld="gamma-$bld"; $typ='c'; 
    } elsif($typ==15) {
        $ptyp='.'; $tbld="fix-$bld"; $typ='.'; 
    } else {
        $ptyp='.'; $tbld="stable-$bld"; $typ='.'; 
    }
    my $triple="$ver.$rev$typ$lev";
    my $ptriple="$ver.$rev$ptyp$lev";
    my %hash=(
        'vHex'     => sprintf('0x%08X',$hex),
        'vShort'   => "$triple",
        'vLong'    => "$triple ($tim)",
        'vTeX'     => "This is $name, Version $triple ($tim)",
        'vGNU'     => "$name $triple ($tim)",
        'vWin'     => "$ver.$rev build $bld",
        'vPerl'    => "$ptriple",
        'vSquid'   => "$ver.$rev-$tbld",
        'vFredo'   => "$name $ptriple ($tbld / $dat)",
        'vWeb'     => "$name/$triple",
    );
    my $fh;
    open($fh,">$versionfile");
    print $fh <<'EOT';
#=======================================================================
#         _   _    :    ____  ____  _____      _    ____ ___   ____
#     _  |_|_|_|   :   |  _ \|  _ \|  ___|    / \  |  _ \_ _| |___ \
#    |_| _|_||_|   :   | |_) | | | | |_      / _ \ | |_) | |    __) |
#    _  |_||_|_|   :   |  __/| |_| |  _|    / ___ \|  __/| |   / __/
#   |_|  |_|_|_|   :   |_|   |____/|_|     /_/   \_\_|  |___| |_____|
#                  : 
#=======================================================================
package PDF::API2::Version;
BEGIN {
    use vars qw( $VERSION %CVersion );
EOT
    print $fh "    \$VERSION = '$hash{vPerl}';\n";
    print $fh "    \%CVersion = (\n";
    foreach my $k (sort keys %hash) {
    print $fh "        '$k' => '$hash{$k}',\n";
    $PDF::API2::Version::CVersion{$k}=$hash{$k};
    }
    print $fh "    );\n";
    print $fh <<'EOT';
}
1;
EOT
    print $fh "\n__END__\n# autogenerated file -- do not edit.\n\n=pod\n\n=head1 NAME\n\nPDF::API2::Version\n\n=head1 VERSION\n\n";
    foreach my $k (sort keys %hash) {
        printf $fh " %7s: $hash{$k} \n",$k;
    }
    print $fh "\n=cut\n\n";
    close($fh);
}

my %makehash=(
    NAME         =>  "PDF::API2",
    AUTHOR       =>  "areibens\@cpan.org",
    ABSTRACT     =>  "TheNextGen PDF Create/Modify API",
    dist         =>  {
        ZIP         =>  "zip ",
        ZIPFLAGS    =>  " -v -o -r -9 ",
        COMPRESS    =>  "gzip -9 -f ",
    },
    MAN1PODS     =>  {},
    MAN3PODS     =>  {},
    PREREQ_PM    =>  {
                    'Compress::Zlib'    => 1.0,
                },
    VERSION_FROM => $versionfile,
);

my $overide=undef;
my $version=undef;
my $build=undef;
my $release=undef;
my $alpha=undef;
my $beta=undef;
my $gamma=undef;
my $stable=undef;
my $fix=undef;
my $remake=undef;
my $usage=undef;

GetOptions(
    "override=s" => \$overide,
    "version|v" => \$version,
    "build|q" => \$build,
    "release|r" => \$release,
    "alpha|a" => \$alpha,
    "beta|b" => \$beta,
    "gamma|g" => \$gamma,
    "stable|s" => \$stable,
    "fix|f" => \$fix,
    "remake|m" => \$remake,
    "help|usage|h" => \$usage,
);

if($usage) {
    print <<EOT;
help for makefile.pl

    --override .version.    specify version
    --version/-v            increment version part
    --release/-r            increment release part
    --build/-q              increment build part
    --alpha/-a              increment to next alpha
    --beta/-b               increment to next beta
    --gamma/-g              increment to next gamma
    --stable/-s             increment to next stable
    --fix/-f                increment to next fix
    --remake/-m             remake version file
    --help/--usage/-h       print this
    
EOT
    exit(0);
}

if($overide) {
    write_version(hex($overide));
} elsif($build) {
    write_version(hex($PDF::API2::Version::CVersion{vHex})+1);
} elsif($release) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xffffff00)+(1<<12));
} elsif($version) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xff000f00)+(1<<24));
} elsif($alpha) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xfffff000)+(1<<12));
} elsif($beta) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) == 0) {
        write_version(($hex & 0xfffff0ff)+(1<<8)+1);
    } elsif((($hex>>8)&0xf) < 5) {
        write_version($hex+1);
    } else {
        write_version(($hex & 0xfffff000)+(1<<12)+(1<<8));
    }
} elsif($gamma) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 5) {
        write_version(($hex & 0xfffff0ff)+(5<<8)+1);
    } elsif((($hex>>8)&0xf) < 13) {
        write_version($hex+1);
    } else {
        write_version(($hex & 0xfffff000)+(1<<12)+(5<<8));
    }
} elsif($stable) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 13) {
        write_version(($hex & 0xfffff0ff)+(13<<8)+1);
    } else {
        write_version($hex+1);
    }
} elsif($fix) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 15) {
        write_version(($hex & 0xfffff0ff)+(15<<8)+1);
    } else {
        write_version($hex+1);
    }
} elsif($remake) {
    write_version(hex($PDF::API2::Version::CVersion{vHex}));
}
if($build | $release | $version | $overide | $alpha | $beta | $gamma | $stable | $remake) {
    system('perl ../cvs2cl.pl >NIL 2>NIL2');
}

$makehash{BINARY_LOCATION}=q|PDF-API2-|.$PDF::API2::Version::CVersion{vPerl}.q|.ppm.tar.gz|;

WriteMakefile( %makehash );

print STDERR $PDF::API2::Version::CVersion{vTeX}."\n";

exit;

sub MY::postamble{
    my $y=qq|ppmdist: pm_to_blib ppd dist\n|;
    $y.=qq|\t\$(TAR) \$(TARFLAGS) \$(DISTNAME)-\$(VERSION).ppm.tar blib\n|;
    $y.=qq|\t\$(COMPRESS) \$(DISTNAME)-\$(VERSION).ppm.tar\n|;
    $y.=qq|\t\$(ZIP) \$(ZIPFLAGS) \$(DISTNAME)-\$(VERSION).\$(OSNAME)-\$(OSVERS).ppm.zip \$(DISTNAME)-\$(VERSION).ppm.tar.gz \$(DISTNAME).ppd\n|;
    $y.=qq|\t\$(RM_F) \$(DISTNAME)-\$(VERSION).ppm.tar.gz\n|;
    $y.=qq|\n|;
    return($y);
}
__END__


