#!/usr/bin/perl

package Ym;

use warnings;
use strict;

use Ym;

# List of configs that will be generated by Ym.
# In ordinary usage there is no need to change it.
our @NAGIOS_CONFIGS = qw/
  nagios.cfg commands.cfg
  contact-templates.cfg contactgroups.cfg contacts.cfg
  host-templates.cfg hostgroups.cfg
  services.cfg service-templates.cfg
  timeperiods.cfg
  service-dependencies.cfg host-dependencies.cfg
  /;  

# Describes structure where Ym stores parsed configs.
# Key - is a main value. If you 'use Ym;' in your programms
# you can access Ym config tree using these keys. See ymcmd.pl.
# First array element is an object name which is used when
# generating object definitions like 'define <object> {'
# Second array element tells where to place object definition.
# This memo is for information only.
# Do not change this data structure uless you have a good reason for that.
our %BRANCHES = (
  'commands'             => ['command',           'commands.cfg'],
  'contact_templates'    => ['contact',           'contact-templates.cfg'],
  'contactgroups'        => ['contactgroup',      'contactgroups.cfg'],
  'contacts'             => ['contact',           'contacts.cfg'],
  'host_templates'       => ['host',              'host-templates.cfg'],
  'hostgroups'           => ['hostgroup',         'hostgroups.cfg'],
  'hosts'                => ['host',              'services.cfg'],
  'service_templates'    => ['service',           'service-templates.cfg'],
  'timeperiods'          => ['timeperiod',        'timeperiods.cfg'],
  'service_dependencies' => ['servicedependency', 'service-dependencies.cfg'],
  'host_dependencies'    => ['hostdependency',    'host-dependencies.cfg'],
  'services'             => ['service',],
);


