use Config;

open F, ">puuencode";
print F <<END;
$Config{startperl}
END
print F <<'END';
use Convert::UU 'uuencode';
my($file,$as_file) = @ARGV;
$as_file ||= $file;
my $stat = (stat $file)[2] or die "Couln't stat $file: $!";
my($mode) = sprintf "%04o", $stat & 07777;
open F, $file or die "Couldn't open $file: $!";
print uuencode(\*F,$as_file,$mode);
close F;
__END__

=head1 NAME

 puuencode - perl replacement for uuencode

=head1 SYNOPSIS

 puuencode inputfile as_outputfile

=head1 DESCRIPTION

Puuencode reads the inputfile and writes a printable version of it to
STDOUT in uuencoded style. Nothing fancy, just a simple uuencode
replacement.

=head1 BUGS

This implementation is much slower than most uuencode programs written
in C. Its primary intention is to allow quick testing of the
underlying Convert::UU module.

=head1 SEE ALSO

puudecode(1), Convert::UU(3)

=head1 AUTHOR

Andreas Koenig E<lt>andreas.koenig@mind.deE<gt>

=cut
END
