#!/usr/bin/perl -w

# Unit testing for Perl::BestPractise, generated by Test::Inline

use strict;
use lib ();
use UNIVERSAL 'isa';
use File::Spec::Functions ':ALL';
BEGIN {
	$| = 1;
	unless ( $ENV{HARNESS_ACTIVE} ) {
		require FindBin;
		$FindBin::Bin = $FindBin::Bin; # Avoid a warning
		chdir catdir( $FindBin::Bin, updir() );
		lib->import('blib', 'lib');
	}
}

# Load the API to test
use Perl::BestPractice ();

# Execute the tests
use Test::More tests => 47;

# =begin testing SETUP 5
use Perl::BestPractice 'PBP';

is( PBP, 'Perl::BestPractice' );
can_ok( PBP, 'name'        );
can_ok( PBP, 'description' );
can_ok( PBP, 'wanted'      );
can_ok( PBP, 'find'        );

sub new_ok {
	my $class = shift;
	my $self  = $class->new(@_);
	isa_ok( $self, $class );
	$self;
}

sub practise_ok {
	my $name = shift;
	ok( PBP->name($name),        "Practice '$name' exists in %NAME"        );
	ok( PBP->description($name), "Practice '$name' exists in %DESCRIPTION" );
	ok( PBP->wanted($name),      "Practice '$name' exists in %WANTED"      );
	ok( PBP->find($name),        "Practice returns true for ->find"        );
}



# =begin testing subroutines_and_variables 4
{
practise_ok('subroutines_and_variables');
}



# =begin testing empty_string 8
{
practise_ok('empty_string');

my $code = <<'END_PERL';
1;
sub foo {
	my $bar = '';     # yes
	$baz = q();       # no
	baz( foo => "" ); # yes
}
END_PERL
my $Document = new_ok( 'PPI::Document', \$code );
my $found    = $Document->find( PBP->wanted('empty_string') );
is( scalar(@$found), 2,
	'empty_string: Found 2 list transformations' );
is( $Document->schild(1)->schild(2)->schild(0)->schild(3), $found->[0],
	'empty_string: Wanted function returned the expected element (1)' );
is( $Document->schild(1)->schild(2)->schild(2)->schild(1)->schild(0)->schild(2), $found->[1],
	'empty_string: Wanted function returned the expected element (2)' );
}



# =begin testing leading_zero 8
{
practise_ok('leading_zero');

my $code = <<'END_PERL';
1;
sub foo {
	my $bar = 010;       # no
	my $foo = oct(10);   # yes
	baz( foo => 00300 ); # yes
}
END_PERL
my $Document = new_ok( 'PPI::Document', \$code );
my $found     = $Document->find( PBP->wanted('leading_zero') );
is( scalar(@$found), 2,
	'leading_zero: Found 2 list transformations' );
is( $Document->schild(1)->schild(2)->schild(0)->schild(3), $found->[0],
	'leading_zero: Wanted function returned the expected element (1)' );
is( $Document->schild(1)->schild(2)->schild(2)->schild(1)->schild(0)->schild(2), $found->[1],
	'leading_zero: Wanted function returned the expected element (2)' );
}



# =begin testing non_lexical_loop_iterator 8
{
practise_ok('non_lexical_loop_iterator');

my $code = <<'END_PERL';
1;
sub foo {
	for $foo ( @list ) {
		$foo++; # This is bad
	}
	foreach my $bar ( @list ) {
		# This is good
	}
	foreach $bar ( @list ) {
		# This is bad
	}
}
END_PERL
my $Document = new_ok( 'PPI::Document', \$code );
my $found     = $Document->find( PBP->wanted('non_lexical_loop_iterator') );
is( scalar(@$found), 2,
	'non_lexical_loop_iterator: Found 1 list transformation' );
is( $Document->schild(1)->schild(2)->schild(0), $found->[0],
	'non_lexical_loop_iterator: Wanted function returned the expected element (1)' );
is( $Document->schild(1)->schild(2)->schild(2), $found->[1],
	'non_lexical_loop_iterator: Wanted function returned the expected element (2)' );
}



# =begin testing list_transformation 7
{
practise_ok('list_transformation');

my $code = <<'END_PERL';
1;
sub foo {
	my @foo = map { $_++ } @bar;
	@baz = map { $_++ } @bar;
	@baz = map { $_++ } @baz;
	return @baz;
}
END_PERL
my $Document = new_ok( 'PPI::Document', \$code );
my $found     = $Document->find( PBP->wanted('list_transformation') );
is( scalar(@$found), 1,
	'list_transformation: Found 1 list transformation' );
is( $Document->schild(1)->schild(2)->schild(2), $found->[0],
	"list_transformation: Wanted function returned the expected element" );
}



# =begin testing do_while_loop 7
{
practise_ok('do_while_loop');

my $code = <<'END_PERL';
1;
sub foo {
	1;
	do { print "Hello World!\n" } while 1;
}
END_PERL
my $Document = new_ok( 'PPI::Document', \$code );
my $found  = $Document->find( PBP->wanted('do_while_loop') );
is( scalar(@$found), 1,
	'do_while_loop: Found 1 do-while loop' );
is( $Document->schild(1)->schild(2)->schild(1), $found->[0],
	"do_while_loop: Wanted function returned the expected element" );
}


1;
