#!/usr/bin/perl -w

# Formal testing for Class::Autouse.
# While this isn't a particularly exhaustive unit test like script, 
# it does test every known bug and corner case discovered. As new bugs
# are found, tests are added to this test script.
# So if everything works for all the nasty corner cases, it should all work
# as advertised... we hope ;)

use strict;
use lib ();
use UNIVERSAL 'isa';
use File::Spec::Functions ':ALL';
BEGIN {
	$| = 1;
	unless ( $ENV{HARNESS_ACTIVE} ) {
		require FindBin;
		chdir ($FindBin::Bin = $FindBin::Bin); # Avoid a warning
		lib->import( catdir( updir(), updir(), 'modules') );
	}
	lib->import( catdir( curdir(), 'modules' ) );
}

use Test::More tests => 5;
use prefork ();
use Class::Autouse 'C';

ok( ! $Class::Autouse::DEVEL, '$Class::Autouse::DEVEL is false' );
is( $INC{"C.pm"}, 'Class::Autouse', 'C.pm is autoused' );

ok( prefork::enable(), 'prefork::enable returns true' );
is( $Class::Autouse::DEVEL, 1, '$Class::Autouse::DEVEL is true' );
isnt( $INC{"C.pm"}, 'Class::Autouse', 'C.pm has been loaded' );

1;
