package main;
use Evo::Base -strict;
use Promises6 ':all';
use Test::More;

my ($p1, $p2, $res, $F, $R);

# resolve all
$res = undef;
$p1  = promise {};
$p2  = promise {};
all($p1, $p2)->then(sub { $res = shift });

$p2->deferred->resolve(2);
$p1->deferred->resolve(1);
is_deeply $res, [1, 2], 'right order';

# reject second, should reject promise
$p1  = resolved(2);
$p2  = rejected('foo');
$res = undef;
all($p1, $p2)->then(sub {fail}, sub { $res = shift });
is $res, 'foo', 'right reason';

# not promises
$res = undef;
all(1, 2, resolved(3))->then(sub { $res = shift });
is_deeply $res, [1, 2, 3], 'right order';

# thenable should work too
($F, $R) = ();
$res = undef;
all(1, Thenable->new, 3)->then(sub { $res = shift });
$F->('th2');
is_deeply $res, [1, 'th2', 3], 'right order';

# thenable rejected all
($F, $R) = ();
$res = undef;
all(1, Thenable->new, 3)->then(sub {fail}, sub { $res = shift });
$R->('thE');
is $res, 'thE', 'rejected by thenable';


done_testing;
{

  package Thenable;
  use Evo::Base -base;
  sub then($self, $f, $r) { $F = $f; $R = $r }
}

