/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class GetCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) {
        BinaryGetCommand cmd = (BinaryGetCommand)command;
        DataStore datastore = server.getDatastore();
        Item item = datastore.get(server, cmd.getVBucketId(), cmd.getKey());
        CommandCode cc = cmd.getComCode();
        if (item == null) {
            if (cc != CommandCode.GETKQ && cc != CommandCode.GETQ && cc != CommandCode.GATQ) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.KEY_ENOENT));
            }
        } else {
            if (cc == CommandCode.TOUCH || cc == CommandCode.GAT || cc == CommandCode.GATQ) {
                item.setExptime(cmd.getExpiration());
            }
            if (cc == CommandCode.TOUCH) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.SUCCESS));
            } else {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, item));
            }
        }
    }
}

