/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.harakiri;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Observable;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.control.MockCommandDispatcher;

public class HarakiriMonitor
extends Observable
implements Runnable {
    private final boolean terminate;
    private BufferedReader input;
    private OutputStream output;
    private Thread thread;
    private final MockCommandDispatcher dispatcher;

    public HarakiriMonitor(String host, int port, boolean terminate, MockCommandDispatcher dispatcher) throws IOException {
        this.dispatcher = dispatcher;
        this.terminate = terminate;
        Socket sock = new Socket(host, port);
        this.input = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        this.output = sock.getOutputStream();
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "HarakiriMonitor");
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    @Override
    public void run() {
        boolean closed = false;
        CouchbaseMock mock = this.dispatcher.getMock();
        try {
            mock.waitForStartup();
            String http = "" + mock.getHttpPort() + '\u0000';
            this.output.write(http.getBytes());
            this.output.flush();
        }
        catch (InterruptedException ex) {
            closed = true;
        }
        catch (IOException ex) {
            closed = true;
        }
        while (!closed) {
            try {
                String packet = this.input.readLine();
                if (packet == null) {
                    closed = true;
                    continue;
                }
                String response = this.dispatcher.processInput(packet);
                this.setChanged();
                this.notifyObservers();
                if (response == null) continue;
                this.output.write((response + "\n").getBytes());
                this.output.flush();
            }
            catch (IOException e) {
                closed = true;
            }
        }
        if (this.terminate) {
            System.exit(1);
        }
    }
}

