# Generated by default/object.tt
package Paws::ES::AutoTuneOptionsStatus;
  use Moose;
  has Options => (is => 'ro', isa => 'Paws::ES::AutoTuneOptions');
  has Status => (is => 'ro', isa => 'Paws::ES::AutoTuneStatus');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::AutoTuneOptionsStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::AutoTuneOptionsStatus object:

  $service_obj->Method(Att1 => { Options => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::AutoTuneOptionsStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->Options

=head1 DESCRIPTION

Specifies the status of Auto-Tune options for the specified
Elasticsearch domain.

=head1 ATTRIBUTES


=head2 Options => L<Paws::ES::AutoTuneOptions>

Specifies Auto-Tune options for the specified Elasticsearch domain.


=head2 Status => L<Paws::ES::AutoTuneStatus>

Specifies Status of the Auto-Tune options for the specified
Elasticsearch domain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

