#!/usr/bin/perl -w
# based on fl13.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok(!$frame->has_crc, "frame doesn't have crc");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 32, "bitrate");
	is($frame->sample, 32000, "sample rate");
	ok($frame->mono, "frame is mono");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
h ϥΧwm c浰c[EZvlbt873mrֶN34>E~Vu,[i.V%`WFbɐsMێ(ծޓvo~1<e~֜  $I3~x~8ߍ4ԕeCYMۣt2$7\
0M#[96Ge7XMy\Od֗Nx$GvM豭4v{Z
  H"7}~ӓHӾd[mmSX+Q5MiC
&d)*pcRQkeqriiPҵ|ƕ"67KvG^؀־kZ>7oZkZtɕ>d
jgs_- I3~:}獕SU>AS R#Euc5i8PՃ)v&p!K-P1sT҉$zK$GܻYvs#cFpgⵌaaf
n״g+^:si5t  57~8~ jD %ܭJˇ@	_$$G|Sĵ86re(؝D(
VnKjvZ\CkMk4kZmz䇗$ִI"3]ߞ7z+FikIh:{olr|٭WܷT3gI-k]Te vrd-~G4#T&Ff9Ѥ^7Cq!iaLvSZU  I 5v~8,xUmjnk`:ajڭu*Wń_4$N%oV*-é,N*ն.mbh,S)XiXw;N(Ui[pi$ml5Mb@   I3}}ے'%u(Ǽl6@o26ͥff͍_aƝ`#ZҌr[vئ"`|`\ʾ.t5uCc΢?
hTtӃf65SudF孺Y#j6Ş   I3}wwj4KZ6$^9	̛u6ڋ+D5cak0ݭZV-LUWqh}j%]ᣍelL9l=TX[aX"5GZR|w۫bp#T   ㎰.
Mg!pZRұ׀;:jD*/A00|6΃uhMuˀSr&!r5%hDHSJԜ.Չl`A`޽:@d5`p-TG  $I3~7]:qfG`І8Uh0y#V5NmE4I]U"u,4vU!ik[6ucR-UhGN6lרRm7ڽ%&ۆLgص  I"3n8~7},k\3QȤ9eT1y[rwB36{):C(X3TF۶$#ZF
	8<+2䵜>Ѷ
qMjT^wv& I3}
3M24LC+M[m6`㹮i8fRaشg	Z־G!`5h4RFͭ"y@x,˵<pѤA-Ypqca"dCf'"[g$3mߍߝGy<:C%nQtڍ7&U
lA\xo2grfmx[@BED|Sg%Ӻ;٢pD)W%jEt}X=gJs+MM`¹jN4k6f]4$H3~6TFVrbe\h7ѤޛX%x65lA	
6E)/,5Ь4M#+~M+T5l֒ #REp$kojh
n?3*MԕP  H"nyiB٦Ky+ev;+<ufօ1S',ke5bwPyʱ1N~"-l\\5+ij5P)NAkZ&Fc"M6f$30-hƶ3aCP	oW(  I3mߎ9l#!:9	W.mӸHsMj6iE|Z`fK+ #dz4е6t4]#M.2!wńkyɞ $x""
t2֬H"n3~ߍ߭ȪZŝbgkkYȷNj<Qv*Bȁk4 冚37gi# +>&J,!F<r3TPIhmja 5hR5
-飘P  ͸~8|xh^0[ |#X]y?s7vè|JY&5I앓LWSlkhRm/QIԃȥMzӿ<UC!\GQ鍢i5l3-0hIbYzmxǯ  I"3~9~7sY,mSMNkI9jaNk I 2
mHc16F6wp2[vulEză@Z$*+qAxykZAIkjM[<UP 3y<}l?QsIm8ME <LcIF"d?&E,G"tnL6SZˌs=/}qԀ6;><kHv<
ĭ*9i*wCA
H"3}n7߮,Em ʂMlWJk5M#ƞm*4He9%uUSrZEB^T0RpI;ksI
dDmlVCrhYQ}YzI3ߎ7‑~:tu6%V,#B`Tl;F>9k@8iH1U3~/[(2RY
F]2ncz9Ş_krm[Tͧ|@ $I߭~7㊟mb6k1ZP{HU$*RAt3-3Zܐ'VDԄ	skX,R
!Vl,SJE܍൛Rs')
U34T浣~59lV
   "3n㈝vf4 UN1D,Uk'15LkFlrK+ZB:|%sd8ꮼ0T]	ES>3jvtqtobv9:f@\b]]Ia`  Q3}ߎߍL^7a:GܡDkKOWf#n6nNzm\ز$x[ys
*N\eT*NffO}S	kDIIQ"|T%aGI"ߍߎ8܄
)yF :Yk,Ģedqk[PV
lcQݚӷ ξ
fI

Hwcf'&ki0
yxI>-XHv;@I"m~wrd71MڧD!,<m[XRsI3]<ыm%qZv
B +AnFޘ50KHaojT[.YuZ-jۧx[[h\dn3~:~7'ddY\&(%MHZ0ח8yԭU[K+!Q)4#	
M.]17tZ|˫)x3.)kWL`R@P\2|J$}m $3nwu2lzW戮9F"O
wI/ͭLx\/[̱d44@R$Q0<~Jyƴԏزo A],tF
T  $3m}߈wjxE4ɴq_8m-,F}P9hݪ.>|>u6	
e8n)-s-ZsU
h³\&Զ427Q(jƨ޺͋4Dgk[A኏僚Ui8   J7~8۝;𷙅`OMPг))a9]LEEK/H	xلRc@&U{mcWMdImE#tɵh$JkH	*o,0{v  I3۝ێ7I-%Na)v$a.Ў
 YS .kW$QlJuIIVOj䥗51RpF;SXt<F6C   I"j3}ߎ8r'F횖^+
٬ht.en[dٖiH1ɖX̩TUVNUjkZR|cMpʭ̚	k"46h'9QQ5JM} 3w㍷bgxBr5>ikw."on-K#HMlJIbN=#)* 2󋻃g*^T{"{Âēe1-S[MracOL9$hKòz "i3n7~/K75С.7HR=KZFQ,JGm{+#v4$uRZL۾k-=8˧M<M,"s)Q&Fr>e4_{w( [WfI.387>0NeiMsS)"6HYN+Dʈy/2W37!M:q*H76T!Dm`2
֕-U5<J"AnyQ^v<ژ5`!υj  $H3~8䃃6%~5k73j 97}jV*$j%evFdF+m7ҺcBl
ݽBeR6Cls"ֵw$q{Ͷ~9ߎRiZe-u;c5ji"[bv%.df3v8؇qWx`8R#Vf]__@o{m-MkG)W6gQ*IhM.dD|   Iwn8BݴY֬EsVV	W
J>SF3b73mgcMlg'%z\'q[C!C&)
a%OأqlBK9쐄.n<ѽm!@  3}ߍםلe6ʝ9M%cf}IèK$[-hK8AZ
\VăS©њ%fp5i]-a>"<GVBA;fִlҴ$Q39ۊg釘Zne F&B1'i?b7,YO.6v|R)6_(n6reڐ[~5relᵮdCĎ2ZG5:mw	٤yw $H3~9ێ30>kHǪcbTuiIZX䪲E[M6#'YJrۏ0/hӒ[xx}lƜ[H|7%iělkH4glSB#)d&8 I3ߎw9~7I0n~nFs<":
R)f=@詩Cpۂ*VB%NynsQiK%L-5aե
$s0gf 5jbMIHX<]rP   "3}ߎ~xn	5"\Yjΐ?lV#\ՑNBZ6b{!6rN6X\%I,o8$9[[ll jȒ--BkǅDkxTRG4I3 J*QRs#FNSy#!¹kZj

=*k:`D$5hMxm\8|Wƨo^Կ'fM4[S*9䪻l;la7w!k1]x1@>ō I~88oBl.`˚VU׏4c,Kmp#[X+y.x4

!e$4vYhAf)jw0h1٬f0ś{Sg;qbMk/ՑSf: םlWyMLxhPTԚKX>CWH2Y0Ajs5hR8k&$j$"ID۱W6i䗌'M,ҽL6(=IݑiI^#6Me
   I37^9w[o )*ms,Gm}l2L*[P.0aN
MUvԍ/5B<fV瑰ᖡnP>g=͙*^B 3'${~vy2]&Rܐ 
