package Locale::CLDR::Transformations::Gutgarts::Ethi::Cyrl;
# This file auto generated from Data\common\transforms\und-Ethi-t-und-cyrl-m0-gutgarts.xml
#	on Thu 29 Feb  5:43:51 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G\p{Ethiopic})/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ሐ),
					result  => q(х̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሑ),
					result  => q(х̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሒ),
					result  => q(х̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሓ),
					result  => q(х̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሔ),
					result  => q(х̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሕ),
					result  => q(х̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሕ),
					result  => q(х̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሖ),
					result  => q(х̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሗ),
					result  => q(х̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ለ),
					result  => q(лэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሉ),
					result  => q(лу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሊ),
					result  => q(ли),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ላ),
					result  => q(ла),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሌ),
					result  => q(ле),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ል),
					result  => q(л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ል),
					result  => q(лы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሎ),
					result  => q(ло),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሏ),
					result  => q(лўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(መ),
					result  => q(мэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሙ),
					result  => q(му),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሚ),
					result  => q(ми),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ማ),
					result  => q(ма),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሜ),
					result  => q(ме),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ም),
					result  => q(м),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ም),
					result  => q(мы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሞ),
					result  => q(мо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎀ),
					result  => q(мўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎃ),
					result  => q(мўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎁ),
					result  => q(мўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሟ),
					result  => q(мўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎂ),
					result  => q(мўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፙ),
					result  => q(мйа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሠ),
					result  => q(ćэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሡ),
					result  => q(ćу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሢ),
					result  => q(ćи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሣ),
					result  => q(ćа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሤ),
					result  => q(ćе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሥ),
					result  => q(ć),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሥ),
					result  => q(ćы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሦ),
					result  => q(ćо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሧ),
					result  => q(ćўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ረ),
					result  => q(рэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሩ),
					result  => q(ру),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሪ),
					result  => q(ри),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ራ),
					result  => q(ра),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሬ),
					result  => q(ре),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ር),
					result  => q(р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ር),
					result  => q(ры),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሮ),
					result  => q(ро),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሯ),
					result  => q(рўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፘ),
					result  => q(рйа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሰ),
					result  => q(сэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሱ),
					result  => q(су),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሲ),
					result  => q(си),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሳ),
					result  => q(са),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሴ),
					result  => q(се),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ስ),
					result  => q(с),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ስ),
					result  => q(сы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሶ),
					result  => q(со),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሷ),
					result  => q(сўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሸ),
					result  => q(шэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሹ),
					result  => q(шу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሺ),
					result  => q(ши),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሻ),
					result  => q(ша),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሼ),
					result  => q(ше),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሽ),
					result  => q(ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሽ),
					result  => q(шы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሾ),
					result  => q(шо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሿ),
					result  => q(шўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቐ),
					result  => q(к̣̄э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቑ),
					result  => q(к̣̄у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቒ),
					result  => q(к̣̄и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቓ),
					result  => q(к̣̄а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቔ),
					result  => q(к̣̄е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቕ),
					result  => q(к̣̄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቕ),
					result  => q(к̣̄ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቖ),
					result  => q(к̣̄о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቘ),
					result  => q(к̣̄ўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቚ),
					result  => q(к̣̄ўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቝ),
					result  => q(к̣̄ўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቛ),
					result  => q(к̣̄ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቜ),
					result  => q(к̣̄ўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቀ),
					result  => q(к̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቁ),
					result  => q(к̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቂ),
					result  => q(к̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቃ),
					result  => q(к̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቄ),
					result  => q(к̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቅ),
					result  => q(к̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቅ),
					result  => q(к̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቆ),
					result  => q(к̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቈ),
					result  => q(к̣ўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቍ),
					result  => q(к̣ўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቊ),
					result  => q(к̣ўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቋ),
					result  => q(к̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቌ),
					result  => q(к̣ўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(በ),
					result  => q(бэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቡ),
					result  => q(бу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቢ),
					result  => q(би),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ባ),
					result  => q(ба),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቤ),
					result  => q(бе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ብ),
					result  => q(б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ብ),
					result  => q(бы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቦ),
					result  => q(бо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎄ),
					result  => q(бўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎇ),
					result  => q(бўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎅ),
					result  => q(бўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቧ),
					result  => q(бўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎆ),
					result  => q(бўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቨ),
					result  => q(вэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቩ),
					result  => q(ву),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቪ),
					result  => q(ви),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቫ),
					result  => q(ва),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቬ),
					result  => q(ве),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቭ),
					result  => q(в),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቭ),
					result  => q(вы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቮ),
					result  => q(во),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቯ),
					result  => q(вўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኀ),
					result  => q(х̮э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኁ),
					result  => q(х̮у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኂ),
					result  => q(х̮и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኃ),
					result  => q(х̮а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኄ),
					result  => q(х̮е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኅ),
					result  => q(х̮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኅ),
					result  => q(х̮ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኆ),
					result  => q(х̮о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኈ),
					result  => q(х̮ўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኍ),
					result  => q(х̮ўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኊ),
					result  => q(х̮ўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኋ),
					result  => q(х̮ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኌ),
					result  => q(х̮ўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሀ),
					result  => q(хэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሁ),
					result  => q(ху),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሂ),
					result  => q(хи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሃ),
					result  => q(ха),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሄ),
					result  => q(хе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ህ),
					result  => q(х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ህ),
					result  => q(хы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሆ),
					result  => q(хо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኘ),
					result  => q(ньэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኙ),
					result  => q(ньу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኚ),
					result  => q(ньи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኛ),
					result  => q(ньа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኜ),
					result  => q(нье),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኝ),
					result  => q(нь),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኝ),
					result  => q(ньы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኞ),
					result  => q(ньо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኟ),
					result  => q(ньўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጘ),
					result  => q(нгэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጙ),
					result  => q(нгу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጚ),
					result  => q(нги),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጛ),
					result  => q(нга),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጜ),
					result  => q(нге),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጝ),
					result  => q(нг),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጝ),
					result  => q(нгы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጞ),
					result  => q(нго),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶓ),
					result  => q(нгўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶖ),
					result  => q(нгўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶔ),
					result  => q(нгўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጟ),
					result  => q(нгўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶕ),
					result  => q(нгўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ነ),
					result  => q(нэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኑ),
					result  => q(ну),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኒ),
					result  => q(ни),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ና),
					result  => q(на),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኔ),
					result  => q(не),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ን),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ን),
					result  => q(ны),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኖ),
					result  => q(но),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኗ),
					result  => q(нўа),
					revisit => 0,
				},
				{
					before  => q([^:Letter:]),
					after   => q(),
					replace => q(ኣ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^:Letter:]),
					after   => q(),
					replace => q(አ),
					result  => q(э),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኡ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኤ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኢ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(እ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኦ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኣ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(አ),
					result  => q(͵э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኡ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኤ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኢ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(እ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኦ),
					result  => q(͵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኸ),
					result  => q(к̱э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኹ),
					result  => q(к̱у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኺ),
					result  => q(к̱и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኻ),
					result  => q(к̱а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኼ),
					result  => q(к̱е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኽ),
					result  => q(к̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኽ),
					result  => q(к̱ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኾ),
					result  => q(к̱о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዀ),
					result  => q(к̱ўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዅ),
					result  => q(к̱ўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዂ),
					result  => q(к̱ўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዃ),
					result  => q(к̱ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዄ),
					result  => q(к̱ўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ከ),
					result  => q(кэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኩ),
					result  => q(ку),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኪ),
					result  => q(ки),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ካ),
					result  => q(ка),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኬ),
					result  => q(ке),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ክ),
					result  => q(к),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ክ),
					result  => q(кы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኮ),
					result  => q(ко),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኰ),
					result  => q(кўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኵ),
					result  => q(кўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኲ),
					result  => q(кўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኳ),
					result  => q(кўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኴ),
					result  => q(кўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ወ),
					result  => q(ўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዉ),
					result  => q(ўу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዊ),
					result  => q(ўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዋ),
					result  => q(ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዌ),
					result  => q(ўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ው),
					result  => q(ў),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ው),
					result  => q(ўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዎ),
					result  => q(ўо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዐ),
					result  => q(ʹэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዑ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዓ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዔ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዒ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዖ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዕ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዘ),
					result  => q(зэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዙ),
					result  => q(зу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዚ),
					result  => q(зи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዛ),
					result  => q(за),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዜ),
					result  => q(зе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዝ),
					result  => q(з),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዝ),
					result  => q(зы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዞ),
					result  => q(зо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዟ),
					result  => q(зўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዠ),
					result  => q(жэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዡ),
					result  => q(жу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዢ),
					result  => q(жи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዣ),
					result  => q(жа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዤ),
					result  => q(же),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዥ),
					result  => q(ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዥ),
					result  => q(жы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዦ),
					result  => q(жо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዧ),
					result  => q(жўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(የ),
					result  => q(е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዩ),
					result  => q(ю),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዬ),
					result  => q(йиэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዪ),
					result  => q(йи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ያ),
					result  => q(я),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዮ),
					result  => q(ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ይ),
					result  => q(йы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ደ),
					result  => q(дэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዱ),
					result  => q(ду),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዲ),
					result  => q(ди),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዳ),
					result  => q(да),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዴ),
					result  => q(де),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ድ),
					result  => q(д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ድ),
					result  => q(ды),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዶ),
					result  => q(до),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዷ),
					result  => q(дўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጀ),
					result  => q(джэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጁ),
					result  => q(джу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጂ),
					result  => q(джи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጃ),
					result  => q(джа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጄ),
					result  => q(дже),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጅ),
					result  => q(дж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጅ),
					result  => q(джы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጆ),
					result  => q(джо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጇ),
					result  => q(джўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ገ),
					result  => q(гэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጉ),
					result  => q(гу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጊ),
					result  => q(ги),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጋ),
					result  => q(га),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጌ),
					result  => q(ге),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ግ),
					result  => q(г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ግ),
					result  => q(гы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጎ),
					result  => q(го),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጐ),
					result  => q(гўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጕ),
					result  => q(гўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጒ),
					result  => q(гўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጓ),
					result  => q(гўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጔ),
					result  => q(гўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጠ),
					result  => q(т̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጡ),
					result  => q(т̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጢ),
					result  => q(т̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጣ),
					result  => q(т̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጤ),
					result  => q(т̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጥ),
					result  => q(т̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጥ),
					result  => q(т̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጦ),
					result  => q(т̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጧ),
					result  => q(т̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ተ),
					result  => q(тэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቱ),
					result  => q(ту),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቲ),
					result  => q(ти),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ታ),
					result  => q(та),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቴ),
					result  => q(те),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ት),
					result  => q(т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ት),
					result  => q(ты),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቶ),
					result  => q(то),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቷ),
					result  => q(тўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጨ),
					result  => q(ч̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጩ),
					result  => q(ч̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጪ),
					result  => q(ч̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጫ),
					result  => q(ч̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጬ),
					result  => q(ч̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጭ),
					result  => q(ч̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጭ),
					result  => q(ч̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጮ),
					result  => q(ч̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጯ),
					result  => q(ч̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቸ),
					result  => q(чэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቹ),
					result  => q(чу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቺ),
					result  => q(чи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቻ),
					result  => q(ча),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቼ),
					result  => q(че),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ች),
					result  => q(ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ች),
					result  => q(чы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቾ),
					result  => q(чо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቿ),
					result  => q(чўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጰ),
					result  => q(п̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጱ),
					result  => q(п̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጲ),
					result  => q(п̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጳ),
					result  => q(п̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጴ),
					result  => q(п̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጵ),
					result  => q(п̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጵ),
					result  => q(п̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጶ),
					result  => q(п̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጷ),
					result  => q(п̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፀ),
					result  => q(\` ц̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፁ),
					result  => q(\` ц̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፂ),
					result  => q(\` ц̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፃ),
					result  => q(\` ц̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፄ),
					result  => q(\` ц̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፅ),
					result  => q(\` ц̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፅ),
					result  => q(\` ц̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፆ),
					result  => q(\` ц̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጸ),
					result  => q(ц̣э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጹ),
					result  => q(ц̣у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጺ),
					result  => q(ц̣и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጻ),
					result  => q(ц̣а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጼ),
					result  => q(ц̣е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጽ),
					result  => q(ц̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጽ),
					result  => q(ц̣ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጾ),
					result  => q(ц̣о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጿ),
					result  => q(ц̣ўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፈ),
					result  => q(фэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፉ),
					result  => q(фу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፊ),
					result  => q(фи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፋ),
					result  => q(фа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፌ),
					result  => q(фе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፍ),
					result  => q(ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፍ),
					result  => q(фы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፎ),
					result  => q(фо),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎈ),
					result  => q(фўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎋ),
					result  => q(фўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎉ),
					result  => q(фўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፏ),
					result  => q(фўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎊ),
					result  => q(фўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፚ),
					result  => q(фйа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፐ),
					result  => q(пэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፑ),
					result  => q(пу),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፒ),
					result  => q(пи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፓ),
					result  => q(па),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፔ),
					result  => q(пе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፕ),
					result  => q(п),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፕ),
					result  => q(пы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፖ),
					result  => q(по),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎌ),
					result  => q(пўэ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎏ),
					result  => q(пўы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎍ),
					result  => q(пўи),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፗ),
					result  => q(пўа),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᎎ),
					result  => q(пўе),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፼),
					result  => q(\`10000),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲፻),
					result  => q(\`1000),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፻),
					result  => q(\`100),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲),
					result  => q(\`10),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፳),
					result  => q(\`20),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፴),
					result  => q(\`30),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፵),
					result  => q(\`40),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፶),
					result  => q(\`50),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፷),
					result  => q(\`60),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፸),
					result  => q(\`70),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፹),
					result  => q(\`80),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፺),
					result  => q(\`90),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፩),
					result  => q(\`1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፪),
					result  => q(\`2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፫),
					result  => q(\`3),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፬),
					result  => q(\`4),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፭),
					result  => q(\`5),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፮),
					result  => q(\`6),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፯),
					result  => q(\`7),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፰),
					result  => q(\`8),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፱),
					result  => q(\`9),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(።),
					result  => q(\:\:),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፣),
					result  => q(\,),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፤),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፥),
					result  => q(\-\:),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፦),
					result  => q(\:\-),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፨),
					result  => q(\:\|\:),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፠),
					result  => q(\:\+),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፡),
					result  => q(\:),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፟),
					result  => q(\_),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
