/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.postag;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import opennlp.common.preprocess.POSTagger;
import opennlp.common.util.FilterFcn;
import opennlp.common.util.Pair;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.preprocess.postag.POSContextGenerator;
import opennlp.grok.preprocess.postag.POSEventCollector;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.Evalable;
import opennlp.maxent.EventCollector;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.TrainEval;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import org.jdom.Element;

public class POSTaggerME
implements Evalable,
POSTagger {
    protected MaxentModel _posModel;
    protected ContextGenerator _contextGen = new POSContextGenerator();
    protected FilterFcn _closedClassTagsFilter;
    protected boolean _useClosedClassTagsFilter = false;
    static /* synthetic */ Class class$opennlp$common$preprocess$Tokenizer;

    protected POSTaggerME() {
    }

    public POSTaggerME(MaxentModel mod) {
        this(mod, new POSContextGenerator());
    }

    public POSTaggerME(MaxentModel mod, ContextGenerator cg) {
        this._posModel = mod;
        this._contextGen = cg;
    }

    public String getNegativeOutcome() {
        return "";
    }

    public EventCollector getEventCollector(Reader r) {
        return new POSEventCollector(r, this._contextGen);
    }

    public void process(NLPDocument doc) {
        Iterator sentIt = doc.sentenceIterator();
        while (sentIt.hasNext()) {
            Element sentEl = (Element)sentIt.next();
            List wordEls = doc.getWordElements(sentEl);
            ArrayList<String> words = new ArrayList<String>(wordEls.size());
            Iterator wordIt = wordEls.iterator();
            while (wordIt.hasNext()) {
                words.add(((Element)wordIt.next()).getText());
            }
            List tags = this.bestSequence(words);
            int index = 0;
            Iterator wordIt2 = wordEls.iterator();
            while (wordIt2.hasNext()) {
                ((Element)wordIt2.next()).setAttribute("pos", (String)tags.get(index++));
            }
        }
    }

    public List tag(List sentence) {
        return this.bestSequence(sentence);
    }

    public String[] tag(String[] sentence) {
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < sentence.length) {
            l.add(sentence[i]);
            ++i;
        }
        List t = this.tag(l);
        String[] tags = new String[t.size()];
        int c = 0;
        Iterator i2 = t.iterator();
        while (i2.hasNext()) {
            tags[c] = (String)i2.next();
            ++c;
        }
        return tags;
    }

    public String tag(String sentence) {
        ArrayList<String> toks = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sentence);
        while (st.hasMoreTokens()) {
            toks.add(st.nextToken());
        }
        List tags = this.tag(toks);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tags.size()) {
            sb.append(toks.get(i) + "/" + tags.get(i) + " ");
            ++i;
        }
        return sb.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    public void localEval(MaxentModel posModel, Reader r, Evalable e, boolean verbose) {
        this._posModel = posModel;
        float total = 0.0f;
        float correct = 0.0f;
        float sentences = 0.0f;
        float sentsCorrect = 0.0f;
        float independent = 0.0f;
        BufferedReader br = new BufferedReader(r);
        ArrayList contexts = new ArrayList();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                void var11_12;
                sentences += 1.0f;
                Pair p = POSEventCollector.convertAnnotatedString((String)var11_12);
                List words = (List)p.a;
                List outcomes = (List)p.b;
                List tags = this.bestSequence(words);
                int c = 0;
                boolean sentOk = true;
                Iterator t = tags.iterator();
                while (t.hasNext()) {
                    total += 1.0f;
                    String tag = (String)t.next();
                    if (tag.equals(outcomes.get(c))) {
                        correct += 1.0f;
                    } else {
                        sentOk = false;
                    }
                    ++c;
                }
                if (!sentOk) continue;
                sentsCorrect += 1.0f;
            }
        }
        catch (IOException E) {
            E.printStackTrace();
        }
        System.out.println("Accuracy         : " + correct / total);
        System.out.println("Sentence Accuracy: " + sentsCorrect / sentences);
    }

    public List bestSequence(List words) {
        int n = words.size();
        int N = 3;
        Sequence s = new Sequence();
        SortedSet[] h = new SortedSet[n + 1];
        int i = 0;
        while (i < h.length) {
            h[i] = new TreeSet();
            ++i;
        }
        h[0].add(new Sequence());
        int i2 = 0;
        while (i2 < n) {
            int sz = Math.min(N, h[i2].size());
            int j = 1;
            while (j <= sz) {
                Sequence top = (Sequence)h[i2].first();
                h[i2].remove(top);
                Object[] params = new Object[]{words, top, new Integer(i2)};
                double[] scores = this._posModel.eval(this._contextGen.getContext((Object)params));
                int p = 0;
                while (p < scores.length) {
                    if (!this._useClosedClassTagsFilter || this._closedClassTagsFilter.filter((String)words.get(i2), this._posModel.getOutcome(p))) {
                        Sequence newS = top.copy();
                        newS.add(this._posModel.getOutcome(p), scores[p]);
                        h[i2 + 1].add(newS);
                    }
                    ++p;
                }
                ++j;
            }
            ++i2;
        }
        return (List)h[n].first();
    }

    public Set requires() {
        HashSet<Class> set = new HashSet<Class>();
        set.add(class$opennlp$common$preprocess$Tokenizer == null ? (class$opennlp$common$preprocess$Tokenizer = POSTaggerME.class$("opennlp.common.preprocess.Tokenizer")) : class$opennlp$common$preprocess$Tokenizer);
        return set;
    }

    public static void main(String[] args) throws IOException {
        if (args[0].equals("-test")) {
            System.out.println(new POSTaggerME((MaxentModel)new SuffixSensitiveGISModelReader(new File(args[1])).getModel()).tag(args[3]));
            return;
        }
        TrainEval.run((String[])args, (Evalable)new POSTaggerME());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Sequence
    extends ArrayList
    implements Comparable {
        double score = 1.0;

        Sequence() {
        }

        Sequence(double s) {
            this.score = s;
        }

        public int compareTo(Object o) {
            Sequence s = (Sequence)o;
            if (this.score < s.score) {
                return 1;
            }
            if (this.score == s.score) {
                return 0;
            }
            return -1;
        }

        public Sequence copy() {
            Sequence s = new Sequence(this.score);
            s.addAll(this);
            return s;
        }

        public void add(String t, double d) {
            super.add(t);
            this.score *= d;
        }

        public String toString() {
            return super.toString() + " " + this.score;
        }
    }
}

