/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.map;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.FeatureMapFunction;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.MultipleFeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.feature.InputColumnFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixFeature
implements FeatureMapFunction {
    protected FeatureFunction parentFeature;
    protected MultipleFeatureValue multipleFeatureValue;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected int suffixLength;

    public SuffixFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
        this.multipleFeatureValue = new MultipleFeatureValue(this);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 2) {
            throw new FeatureException("Could not initialize SuffixFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof FeatureFunction)) {
            throw new FeatureException("Could not initialize SuffixFeature: the first argument is not a feature. ");
        }
        if (!(arguments[1] instanceof Integer)) {
            throw new FeatureException("Could not initialize SuffixFeature: the second argument is not a string. ");
        }
        this.setParentFeature((FeatureFunction)arguments[0]);
        this.setSuffixLength((Integer)arguments[1]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("SUFFIX_" + this.suffixLength + "_" + this.parentFeature.getSymbolTable().getName(), this.parentFeature.getSymbolTable()));
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{InputColumnFeature.class, Integer.class};
        return paramTypes;
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.multipleFeatureValue;
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public void update() throws MaltChainedException {
        this.parentFeature.update();
        FeatureValue value = this.parentFeature.getFeatureValue();
        if (value instanceof SingleFeatureValue) {
            String symbol = ((SingleFeatureValue)value).getSymbol();
            if (value.isNullValue()) {
                this.multipleFeatureValue.addFeatureValue(this.parentFeature.getSymbolTable().getSymbolStringToCode(symbol), symbol, true);
                this.multipleFeatureValue.setNullValue(true);
            } else {
                String suffixStr = symbol.length() - this.suffixLength > 0 ? symbol.substring(symbol.length() - this.suffixLength) : symbol;
                int code = this.table.addSymbol(suffixStr);
                this.multipleFeatureValue.addFeatureValue(code, suffixStr, this.table.getKnown(suffixStr));
                this.multipleFeatureValue.setNullValue(false);
            }
        } else if (value instanceof MultipleFeatureValue) {
            this.multipleFeatureValue.reset();
            if (((MultipleFeatureValue)value).isNullValue()) {
                this.multipleFeatureValue.addFeatureValue(this.parentFeature.getSymbolTable().getSymbolStringToCode(((MultipleFeatureValue)value).getFirstSymbol()), ((MultipleFeatureValue)value).getFirstSymbol(), true);
                this.multipleFeatureValue.setNullValue(true);
            } else {
                for (String symbol : ((MultipleFeatureValue)value).getSymbols()) {
                    String suffixStr = symbol.length() - this.suffixLength > 0 ? symbol.substring(symbol.length() - this.suffixLength) : symbol;
                    int code = this.table.addSymbol(suffixStr);
                    this.multipleFeatureValue.addFeatureValue(code, suffixStr, this.table.getKnown(suffixStr));
                    this.multipleFeatureValue.setNullValue(true);
                }
            }
        }
    }

    @Override
    public void updateCardinality() throws MaltChainedException {
        this.parentFeature.updateCardinality();
        this.multipleFeatureValue.setCardinality(this.table.getValueCounter());
    }

    public FeatureFunction getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(FeatureFunction feature) {
        this.parentFeature = feature;
    }

    public int getSuffixLength() {
        return this.suffixLength;
    }

    public void setSuffixLength(int suffixLength) {
        this.suffixLength = suffixLength;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Suffix(");
        sb.append(this.parentFeature.toString());
        sb.append(", ");
        sb.append(this.suffixLength);
        sb.append(')');
        return sb.toString();
    }
}

