# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V3::Enums::AdTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                    => "UNSPECIFIED",
  UNKNOWN                        => "UNKNOWN",
  TEXT_AD                        => "TEXT_AD",
  EXPANDED_TEXT_AD               => "EXPANDED_TEXT_AD",
  CALL_ONLY_AD                   => "CALL_ONLY_AD",
  EXPANDED_DYNAMIC_SEARCH_AD     => "EXPANDED_DYNAMIC_SEARCH_AD",
  HOTEL_AD                       => "HOTEL_AD",
  SHOPPING_SMART_AD              => "SHOPPING_SMART_AD",
  SHOPPING_PRODUCT_AD            => "SHOPPING_PRODUCT_AD",
  VIDEO_AD                       => "VIDEO_AD",
  GMAIL_AD                       => "GMAIL_AD",
  IMAGE_AD                       => "IMAGE_AD",
  RESPONSIVE_SEARCH_AD           => "RESPONSIVE_SEARCH_AD",
  LEGACY_RESPONSIVE_DISPLAY_AD   => "LEGACY_RESPONSIVE_DISPLAY_AD",
  APP_AD                         => "APP_AD",
  LEGACY_APP_INSTALL_AD          => "LEGACY_APP_INSTALL_AD",
  RESPONSIVE_DISPLAY_AD          => "RESPONSIVE_DISPLAY_AD",
  HTML5_UPLOAD_AD                => "HTML5_UPLOAD_AD",
  DYNAMIC_HTML5_AD               => "DYNAMIC_HTML5_AD",
  APP_ENGAGEMENT_AD              => "APP_ENGAGEMENT_AD",
  SHOPPING_COMPARISON_LISTING_AD => "SHOPPING_COMPARISON_LISTING_AD",
  VIDEO_RESPONSIVE_AD            => "VIDEO_RESPONSIVE_AD"
];

1;
