#!/usr/bin/perl

use strict;
use Test::More;
plan tests => 1;

use File::Temp qw(tempdir);
use File::Spec;
my $tmp_dir = tempdir(CLEANUP => 1);
my $tmp_file = File::Spec->catfile($tmp_dir, 'sploit');

my $file = __FILE__;
$file =~ s/\.t$/.inc/;
my $inc = $ENV{PERL_CORE} ? "-Ilib -I../../lib" : "-I".join(" -I", @INC);
system qq($^X $inc -w "$file" 2>$tmp_file);
open(my $fh, "<", $tmp_file) or die "$tmp_file $!";
{
  local $/;
  my $err = <$fh>;
  like($err, qr/SECURITY: Movable-Type CVE-2015-1592 Storable metasploit attack/,
       'Detect CVE-2015-1592');
}
