######################################################################
#
# JEF_by_CP932.pl
#
# Copyright (c) 2018, 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# Linkexpress operation manual J2X1-5930-03Z2(00) FUJITSU LIMITED
# http://software.fujitsu.com/jp/manual/manualfiles/M080093/J2X15930/03Z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0416.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0420.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0421.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/b5691-g-00-00.html

use strict;

my %JEF_by_CP932 = ();

my @JEF_by_CP932_a = map { @_=split(/ /); ((@_==6) && ($_[2] ne $_[5])) ? die : @_[1,2] } split(/\n/,<<'END');
 92CB 47C9 
 FA9C C4CD 
V 8D56 50FC 
 FAD0 B9B7 
@ 8740 77C9 @ 8740 77C9
A 8741 77CA A 8741 77CA
B 8742 77CB B 8742 77CB
C 8743 77CC C 8743 77CC
D 8744 77CD D 8744 77CD
E 8745 77CE E 8745 77CE
F 8746 77CF F 8746 77CF
G 8747 77D0 G 8747 77D0
H 8748 77D1 H 8748 77D1
I 8749 77D2 I 8749 77D2
J 874A 77D3 J 874A 77D3
K 874B 77D4 K 874B 77D4
L 874C 77D5 L 874C 77D5
M 874D 77D6 M 874D 77D6
N 874E 77D7 N 874E 77D7
O 874F 77D8 O 874F 77D8
P 8750 77D9 P 8750 77D9
Q 8751 77DA Q 8751 77DA
R 8752 77DB R 8752 77DB
S 8753 77DC S 8753 77DC
T 8754 77DE T 8754 77DE
U 8755 77DF U 8755 77DF
V 8756 77E0 V 8756 77E0
W 8757 77E1 W 8757 77E1
X 8758 77E2 X 8758 77E2
Y 8759 77E3 Y 8759 77E3
Z 875A 77E4 Z 875A 77E4
[ 875B 77E5 [ 875B 77E5
\ 875C 77E6 \ 875C 77E6
] 875D 77E7 ] 875D 77E7
_ 875F 76DA _ 875F 76DA
` 8760 76DC ` 8760 76DC
a 8761 76DB a 8761 76DB
b 8762 76D9 b 8762 76D9
c 8763 76DE c 8763 76DE
d 8764 76E0 d 8764 76E0
e 8765 76E1 e 8765 76E1
f 8766 76E2 f 8766 76E2
h 8768 76E7 h 8768 76E7
i 8769 76E6 i 8769 76E6
j 876A 76E3 j 876A 76E3
k 876B 76E4 k 876B 76E4
l 876C 76E5 l 876C 76E5
m 876D 76E9 m 876D 76E9
n 876E 76EB n 876E 76EB
o 876F 76BC o 876F 76BC
p 8770 76BD p 8770 76BD
q 8771 76BE q 8771 76BE
r 8772 76C4 r 8772 76C4
s 8773 76C5 s 8773 76C5
t 8774 76C6 t 8774 76C6
u 8775 76C0 u 8775 76C0
 8782 76FA  8782 76FA
 8783 76F4  8783 76F4
 8784 76F6  8784 76F6
 878A 78D5  878A 78D5
 878B 78CF  878B 78CF
 878C 78CB  878C 78CB
 879A 76A8  879A 76A8
 8790 76A9  8790 76A9
 8791 76AA  8791 76AA
 8792 7FE8 
 8795 7FE5 
 8796 7FDF 
 8797 7FDE 
 879B 7FD7 
 879C 7FD6 
@ FA40 77EB @ EEEF 77EB
A FA41 77EC A EEF0 77EC
B FA42 77ED B EEF1 77ED
C FA43 77EE C EEF2 77EE
D FA44 77EF D EEF3 77EF
E FA45 77F0 E EEF4 77F0
F FA46 77F1 F EEF5 77F1
G FA47 77F2 G EEF6 77F2
H FA48 77F3 H EEF7 77F3
I FA49 77F4 I EEF8 77F4
T FA54 76A7  EEF9 76A7
U FA55 76A1 U EEFA 76A1
V FA56 76A2 V EEFB 76A2
W FA57 76A3 W EEFC 76A3
\ FA5C 5FDC 
] FA5D 64B5 
^ FA5E 6AD9 
_ FA5F 69FE 
` FA60 62C4 
a FA61 42C7 
b FA62 70E1 
c FA63 51A3 
d FA64 70CD 
e FA65 6AC9 
f FA66 51FC 
g FA67 4CF6 
h FA68 41AC 
i FA69 41E8 
j FA6A 43CF 
k FA6B 41EF 
l FA6C 41F0 
m FA6D 41FB 
n FA6E 42A8 
o FA6F 42B5 
p FA70 42B3 
q FA71 42B9 
r FA72 42B7 
s FA73 42CA 
t FA74 42E7 
u FA75 42DF 
v FA76 43D0 
w FA77 42DE 
x FA78 42E9 
y FA79 42F5 
z FA7A 42E8 
{ FA7B 42FC 
| FA7C 43B9 
} FA7D 43B2 
~ FA7E 43D3 
 FA80 43D9 
 FA81 43F2 
 FA82 43F7 
 FA83 44AC 
 FA84 44B4 
 FA85 44F7 
 FA86 44D2 
 FA87 44FA 
 FA88 44ED 
 FA89 45A3 
 FA8A 45A8 
 FA8B 45B3 
 FA8C 45D2 
 FA8D 45DB 
 FA8E 45E2 
 FA8F 45F3 
 FA90 45F2 
 FA91 46C4 
 FA92 46C1 
 FA93 46C9 
 FA94 45FA 
 FA95 45F6 
 FA96 48C9 
 FA97 48CA 
 FA98 48CB 
 FA99 47F7 
 FA9A 47F6 
 FA9B 48CC 
 FA9D 48BB 
 FA9E 48CD 
 FA9F 48D0 
 FAA0 48E3 
 FAA1 48E4 
 FAA2 48E5 
 FAA3 48EB 
 FAA4 49A3 
 FAA5 49F0 
 FAA6 49F2 
 FAA7 4AC9 
 FAA8 4ABD 
 FAA9 4AC0 
 FAAA 4AC6 
 FAAB 4AD4 
 FAAC 4AF1 
 FAAD 4AF3 
 FAAE 4BE4 
 FAAF 4AFB 
 FAB0 4BA3 
 FAB1 4BD0 
 FAB2 4BA2 
 FAB3 4BD3 
 FAB4 4BDF 
 FAB5 4BE0 
 FAB6 4BE5 
 FAB7 4CEB 
 FAB8 4CEE 
 FAB9 4DA2 
 FABA 4DC0 
 FABB 4DC7 
 FABC 4DCC 
 FABD 4EA8 
 FABE 4DD0 
 FABF 4EC1 
 FAC0 4EBD 
 FAC1 4EED 
 FAC2 4EC2 
 FAC3 4EEE 
 FAC4 4ED0 
 FAC5 4ECE 
 FAC6 4EDB 
 FAC7 4EF7 
 FAC8 4FB5 
 FAC9 4FED 
 FACA 4FFA 
 FACB 50A2 
 FACC 4FA7 
 FACD 50C9 
 FACE 51BD 
 FACF 51C4 
 FAD1 51C0 
 FAD2 51A1 
 FAD3 51C7 
 FAD4 51CA 
 FAD5 51D9 
 FAD6 52A1 
 FAD7 51D4 
 FAD8 51DE 
 FAD9 51B3 
 FADA 51E5 
 FADB 51AB 
 FADC 51EB 
 FADD 51F1 
 FADE 52A2 
 FADF 52BC 
 FAE0 52AD 
 FAE1 70CE 
 FAE2 53B2 
 FAE3 52EE 
 FAE4 53B4 
 FAE5 53C0 
 FAE6 53C7 
 FAE7 70CF 
 FAE8 70D0 
 FAE9 53ED 
 FAEA 70D1 
 FAEB 52F4 
 FAEC 70D2 
 FAED 70D3 
 FAEE 54AD 
 FAEF 52E8 
 FAF0 54AF 
 FAF1 54B0 
 FAF2 54BC 
 FAF3 54BD 
 FAF4 54F8 
 FAF5 55B5 
 FAF6 55BD 
 FAF7 55C3 
 FAF8 55BF 
 FAF9 55D3 
 FAFA 55DE 
 FAFB 56A3 
 FAFC 70DE 
@ FB40 56A7 
A FB41 56AD 
B FB42 56B2 
C FB43 56B8 
D FB44 70DF 
E FB45 55B1 
F FB46 56C2 
G FB47 56CF 
H FB48 56BE 
I FB49 56C3 
J FB4A 56DF 
K FB4B 56FE 
L FB4C 57AE 
M FB4D 57B8 
N FB4E 57B9 
O FB4F 57BA 
P FB50 57BC 
Q FB51 57D1 
R FB52 57DE 
S FB53 58A6 
T FB54 58A5 
U FB55 57F1 
V FB56 57EB 
W FB57 57EC 
X FB58 70E3 By Linkexpress Operation Guide: "https://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0420.html", but maybe 70E2 is better
Y FB59 57F6 
Z FB5A 58A9 
[ FB5B 58FA 
\ FB5C 58D6 
] FB5D 58ED 
^ FB5E 58EF 
_ FB5F 58F6 
` FB60 59BA 
a FB61 59BC 
b FB62 59C0 
c FB63 59C3 
d FB64 5AAC 
e FB65 59D0 
f FB66 59C7 
g FB67 59D7 
h FB68 59DA 
i FB69 59D9 
j FB6A 59DD 
k FB6B 5AAD 
l FB6C 59F4 
m FB6D 59FB 
n FB6E 5AB8 
o FB6F 5AD0 
p FB70 5AFE 
q FB71 5BA4 
r FB72 5BA5 
s FB73 5AFD 
t FB74 5BA9 
u FB75 5BB7 
v FB76 5BCC 
w FB77 44DC 
x FB78 5BFC 
y FB79 5CA7 
z FB7A 5CAE 
{ FB7B 5CB2 
| FB7C 5CCE 
} FB7D 70E5 
~ FB7E 5CDA 
 FB80 5CDC 
 FB81 5CE6 
 FB82 5CE4 
 FB83 5CE8 
 FB84 5DDD 
 FB85 5DE1 
 FB86 5DE5 
 FB87 5DE4 
 FB88 5EA3 
 FB89 5ED3 
 FB8A 5EFD 
 FB8B 5EE0 
 FB8C 5FE4 
 FB8D 5FB6 
 FB8E 5FBE 
 FB8F 5FD6 
 FB90 5FE8 
 FB91 5FF7 
 FB92 60A1 
 FB93 61D9 
 FB94 70E7 
 FB95 61F0 
 FB96 61FE 
 FB97 62AA 
 FB98 70E8 
 FB99 70E9 
 FB9A 62D1 
 FB9B 62D4 
 FB9C 62D9 
 FB9D 62E4 
 FB9E 62E5 
 FB9F 70EA 
 FBA0 63DF 
 FBA1 63E0 
 FBA2 63F9 
 FBA3 64E4 
 FBA4 64EC 
 FBA5 64DA 
 FBA6 65A7 
 FBA7 6BEA 
 FBA8 65B3 
 FBA9 65B7 
 FBAA 65B6 
 FBAB 65C7 
 FBAC 65D1 
 FBAD 66AB 
 FBAE 65F9 
 FBAF 65F8 
 FBB0 66B9 
 FBB1 66C3 
 FBB2 66ED 
 FBB3 70F9 
 FBB4 70FB 
 FBB5 70FA 
 FBB6 68A6 
 FBB7 68A8 
 FBB8 68DF 
 FBB9 68B0 
 FBBA 69BE 
 FBBB 69BC 
 FBBC 69BF 
 FBBD 69C5 
 FBBE 69C6 
 FBBF 69C0 
 FBC0 69C1 
 FBC1 69CD 
 FBC2 69D1 
 FBC3 69D0 
 FBC4 69E1 
 FBC5 69E4 
 FBC6 69E2 
 FBC7 69E8 
 FBC8 69EE 
 FBC9 69EA 
 FBCA 69E0 
 FBCB 6BD2 
 FBCC 6AA7 
 FBCD 69F7 
 FBCE 69F8 
 FBCF 6AC4 
 FBD0 6ABC 
 FBD1 6ABE 
 FBD2 6AB8 
 FBD3 6BD3 
 FBD4 6ABB 
 FBD5 6AC2 
 FBD6 6ABA 
 FBD7 6AD5 
 FBD8 6AD3 
 FBD9 69B3 
 FBDA 6BD4 
 FBDB 6AD1 
 FBDC 6ACA 
 FBDD 6AD0 
 FBDE 6ACC 
 FBDF 6AE4 
 FBE0 6ADE 
 FBE1 6AF2 
 FBE2 6AF9 
 FBE3 6BA3 
 FBE4 6BAE 
 FBE5 6BBD 
 FBE6 6BC5 
 FBE7 6BC6 
 FBE8 6BE1 
 FBE9 68CC 
 FBEA 68E0 
 FBEB 68D4 
 FBEC 68DB 
 FBED 6CAC 
 FBEE 6CAD 
 FBEF 6CB0 
 FBF0 6CB1 
 FBF1 6CAE 
 FBF2 6CB3 
 FBF3 6CB5 
 FBF4 6CF3 
 FBF5 6CF7 
 FBF6 6DB3 
 FBF7 6DB4 
 FBF8 6DBD 
 FBF9 6DBE 
 FBFA 5CF3 
 FBFB 6DF6 
 FBFC 6EA4 
@ FC40 6EA7 
A FC41 6ED0 
B FC42 6EEE 
C FC43 6ED8 
D FC44 6EDB 
E FC45 6EEF 
F FC46 6EE3 
G FC47 6FA3 
H FC48 6FA1 
I FC49 6FB2 
J FC4A 6FAE 
K FC4B 6FD6 
END

my @JEF_by_CP932_b = map { @_=split(/ /); ((@_==6) && ($_[2] ne $_[5])) ? die : @_[1,2] } split(/\n/,<<'END');
 92CB 47C9 
 FA9C C4CD 
V 8D56 50FC 
 FAD0 B9B7 
@ 8740 77C9 @ 8740 77C9
A 8741 77CA A 8741 77CA
B 8742 77CB B 8742 77CB
C 8743 77CC C 8743 77CC
D 8744 77CD D 8744 77CD
E 8745 77CE E 8745 77CE
F 8746 77CF F 8746 77CF
G 8747 77D0 G 8747 77D0
H 8748 77D1 H 8748 77D1
I 8749 77D2 I 8749 77D2
J 874A 77D3 J 874A 77D3
K 874B 77D4 K 874B 77D4
L 874C 77D5 L 874C 77D5
M 874D 77D6 M 874D 77D6
N 874E 77D7 N 874E 77D7
O 874F 77D8 O 874F 77D8
P 8750 77D9 P 8750 77D9
Q 8751 77DA Q 8751 77DA
R 8752 77DB R 8752 77DB
S 8753 77DC S 8753 77DC
T 8754 77DE T 8754 77DE
U 8755 77DF U 8755 77DF
V 8756 77E0 V 8756 77E0
W 8757 77E1 W 8757 77E1
X 8758 77E2 X 8758 77E2
Y 8759 77E3 Y 8759 77E3
Z 875A 77E4 Z 875A 77E4
[ 875B 77E5 [ 875B 77E5
\ 875C 77E6 \ 875C 77E6
] 875D 77E7 ] 875D 77E7
_ 875F 76DA _ 875F 76DA
` 8760 76DC ` 8760 76DC
a 8761 76DB a 8761 76DB
b 8762 76D9 b 8762 76D9
c 8763 76DE c 8763 76DE
d 8764 76E0 d 8764 76E0
e 8765 76E1 e 8765 76E1
f 8766 76E2 f 8766 76E2
h 8768 76E7 h 8768 76E7
i 8769 76E6 i 8769 76E6
j 876A 76E3 j 876A 76E3
k 876B 76E4 k 876B 76E4
l 876C 76E5 l 876C 76E5
m 876D 76E9 m 876D 76E9
n 876E 76EB n 876E 76EB
o 876F 76BC o 876F 76BC
p 8770 76BD p 8770 76BD
q 8771 76BE q 8771 76BE
r 8772 76C4 r 8772 76C4
s 8773 76C5 s 8773 76C5
t 8774 76C6 t 8774 76C6
u 8775 76C0 u 8775 76C0
 8782 76FA  8782 76FA
 8783 76F4  8783 76F4
 8784 76F6  8784 76F6
 878A 78D5  878A 78D5
 878B 78CF  878B 78CF
 878C 78CB  878C 78CB
 879A 76A8  879A 76A8
 8790 76A9  8790 76A9
 8791 76AA  8791 76AA
 8792 7FE8 
 8795 7FE5 
 8796 7FDF 
 8797 7FDE 
 879B 7FD7 
 879C 7FD6 
@ FA40 77EB @ EEEF 77EB
A FA41 77EC A EEF0 77EC
B FA42 77ED B EEF1 77ED
C FA43 77EE C EEF2 77EE
D FA44 77EF D EEF3 77EF
E FA45 77F0 E EEF4 77F0
F FA46 77F1 F EEF5 77F1
G FA47 77F2 G EEF6 77F2
H FA48 77F3 H EEF7 77F3
I FA49 77F4 I EEF8 77F4
T FA54 76A7  EEF9 76A7
U FA55 76A1 U EEFA 76A1
V FA56 76A2 V EEFB 76A2
W FA57 76A3 W EEFC 76A3
\ FA5C 5FDC 
] FA5D 64B5 
^ FA5E 6AD9 
_ FA5F 69FE 
` FA60 62C4 
a FA61 42C7 
b FA62 70E1 
c FA63 51A3 
d FA64 70CD 
e FA65 6AC9 
f FA66 51FC 
g FA67 4CF6 
h FA68 41AC 
i FA69 41E8 
j FA6A 43CF 
k FA6B 41EF 
l FA6C 41F0 
m FA6D 41FB 
n FA6E 42A8 
o FA6F 42B5 
p FA70 42B3 
q FA71 42B9 
r FA72 42B7 
s FA73 42CA 
t FA74 42E7 
u FA75 42DF 
v FA76 43D0 
w FA77 42DE 
x FA78 42E9 
y FA79 42F5 
z FA7A 42E8 
{ FA7B 42FC 
| FA7C 43B9 
} FA7D 43B2 
~ FA7E 43D3 
 FA80 43D9 
 FA81 43F2 
 FA82 43F7 
 FA83 44AC 
 FA84 44B4 
 FA85 44F7 
 FA86 44D2 
 FA87 44FA 
 FA88 44ED 
 FA89 45A3 
 FA8A 45A8 
 FA8B 45B3 
 FA8C 45D2 
 FA8D 45DB 
 FA8E 45E2 
 FA8F 45F3 
 FA90 45F2 
 FA91 46C4 
 FA92 46C1 
 FA93 46C9 
 FA94 45FA 
 FA95 45F6 
 FA96 48C9 
 FA97 48CA 
 FA98 48CB 
 FA99 47F7 
 FA9A 47F6 
 FA9B 48CC 
 FA9D 48BB 
 FA9E 48CD 
 FA9F 48D0 
 FAA0 48E3 
 FAA1 48E4 
 FAA2 48E5 
 FAA3 48EB 
 FAA4 49A3 
 FAA5 49F0 
 FAA6 49F2 
 FAA7 4AC9 
 FAA8 4ABD 
 FAA9 4AC0 
 FAAA 4AC6 
 FAAB 4AD4 
 FAAC 4AF1 
 FAAD 4AF3 
 FAAE 4BE4 
 FAAF 4AFB 
 FAB0 4BA3 
 FAB1 4BD0 
 FAB2 4BA2 
 FAB3 4BD3 
 FAB4 4BDF 
 FAB5 4BE0 
 FAB6 4BE5 
 FAB7 4CEB 
 FAB8 4CEE 
 FAB9 4DA2 
 FABA 4DC0 
 FABB 4DC7 
 FABC 4DCC 
 FABD 4EA8 
 FABE 4DD0 
 FABF 4EC1 
 FAC0 4EBD 
 FAC1 4EED 
 FAC2 4EC2 
 FAC3 4EEE 
 FAC4 4ED0 
 FAC5 4ECE 
 FAC6 4EDB 
 FAC7 4EF7 
 FAC8 4FB5 
 FAC9 4FED 
 FACA 4FFA 
 FACB 50A2 
 FACC 4FA7 
 FACD 50C9 
 FACE 51BD 
 FACF 51C4 
 FAD1 51C0 
 FAD2 51A1 
 FAD3 51C7 
 FAD4 51CA 
 FAD5 51D9 
 FAD6 52A1 
 FAD7 51D4 
 FAD8 51DE 
 FAD9 51B3 
 FADA 51E5 
 FADB 51AB 
 FADC 51EB 
 FADD 51F1 
 FADE 52A2 
 FADF 52BC 
 FAE0 52AD 
 FAE1 70CE 
 FAE2 53B2 
 FAE3 52EE 
 FAE4 53B4 
 FAE5 53C0 
 FAE6 53C7 
 FAE7 70CF 
 FAE8 70D0 
 FAE9 53ED 
 FAEA 70D1 
 FAEB 52F4 
 FAEC 70D2 
 FAED 70D3 
 FAEE 54AD 
 FAEF 52E8 
 FAF0 54AF 
 FAF1 54B0 
 FAF2 54BC 
 FAF3 54BD 
 FAF4 54F8 
 FAF5 55B5 
 FAF6 55BD 
 FAF7 55C3 
 FAF8 55BF 
 FAF9 55D3 
 FAFA 55DE 
 FAFB 56A3 
 FAFC 70DE 
@ FB40 56A7 
A FB41 56AD 
B FB42 56B2 
C FB43 56B8 
D FB44 70DF 
E FB45 55B1 
F FB46 56C2 
G FB47 56CF 
H FB48 56BE 
I FB49 56C3 
J FB4A 56DF 
K FB4B 56FE 
L FB4C 57AE 
M FB4D 57B8 
N FB4E 57B9 
O FB4F 57BA 
P FB50 57BC 
Q FB51 57D1 
R FB52 57DE 
S FB53 58A6 
T FB54 58A5 
U FB55 57F1 
V FB56 57EB 
W FB57 57EC 
X FB58 70E3 By Linkexpress Operation Guide: "https://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0420.html", but maybe 70E2 is better
Y FB59 57F6 
Z FB5A 58A9 
[ FB5B 58FA 
\ FB5C 58D6 
] FB5D 58ED 
^ FB5E 58EF 
_ FB5F 58F6 
` FB60 59BA 
a FB61 59BC 
b FB62 59C0 
c FB63 59C3 
d FB64 5AAC 
e FB65 59D0 
f FB66 59C7 
g FB67 59D7 
h FB68 59DA 
i FB69 59D9 
j FB6A 59DD 
k FB6B 5AAD 
l FB6C 59F4 
m FB6D 59FB 
n FB6E 5AB8 
o FB6F 5AD0 
p FB70 5AFE 
q FB71 5BA4 
r FB72 5BA5 
s FB73 5AFD 
t FB74 5BA9 
u FB75 5BB7 
v FB76 5BCC 
w FB77 44DC 
x FB78 5BFC 
y FB79 5CA7 
z FB7A 5CAE 
{ FB7B 5CB2 
| FB7C 5CCE 
} FB7D 70E5 
~ FB7E 5CDA 
 FB80 5CDC 
 FB81 5CE6 
 FB82 5CE4 
 FB83 5CE8 
 FB84 5DDD 
 FB85 5DE1 
 FB86 5DE5 
 FB87 5DE4 
 FB88 5EA3 
 FB89 5ED3 
 FB8A 5EFD 
 FB8B 5EE0 
 FB8C 5FE4 
 FB8D 5FB6 
 FB8E 5FBE 
 FB8F 5FD6 
 FB90 5FE8 
 FB91 5FF7 
 FB92 60A1 
 FB93 61D9 
 FB94 70E7 
 FB95 61F0 
 FB96 61FE 
 FB97 62AA 
 FB98 70E8 
 FB99 70E9 
 FB9A 62D1 
 FB9B 62D4 
 FB9C 62D9 
 FB9D 62E4 
 FB9E 62E5 
 FB9F 70EA 
 FBA0 63DF 
 FBA1 63E0 
 FBA2 63F9 
 FBA3 64E4 
 FBA4 64EC 
 FBA5 64DA 
 FBA6 65A7 
 FBA7 6BEA 
 FBA8 65B3 
 FBA9 65B7 
 FBAA 65B6 
 FBAB 65C7 
 FBAC 65D1 
 FBAD 66AB 
 FBAE 65F9 
 FBAF 65F8 
 FBB0 66B9 
 FBB1 66C3 
 FBB2 66ED 
 FBB3 70F9 
 FBB4 70FB 
 FBB5 70FA 
 FBB6 68A6 
 FBB7 68A8 
 FBB8 68DF 
 FBB9 68B0 
 FBBA 69BE 
 FBBB 69BC 
 FBBC 69BF 
 FBBD 69C5 
 FBBE 69C6 
 FBBF 69C0 
 FBC0 69C1 
 FBC1 69CD 
 FBC2 69D1 
 FBC3 69D0 
 FBC4 69E1 
 FBC5 69E4 
 FBC6 69E2 
 FBC7 69E8 
 FBC8 69EE 
 FBC9 69EA 
 FBCA 69E0 
 FBCB 6BD2 
 FBCC 6AA7 
 FBCD 69F7 
 FBCE 69F8 
 FBCF 6AC4 
 FBD0 6ABC 
 FBD1 6ABE 
 FBD2 6AB8 
 FBD3 6BD3 
 FBD4 6ABB 
 FBD5 6AC2 
 FBD6 6ABA 
 FBD7 6AD5 
 FBD8 6AD3 
 FBD9 69B3 
 FBDA 6BD4 
 FBDB 6AD1 
 FBDC 6ACA 
 FBDD 6AD0 
 FBDE 6ACC 
 FBDF 6AE4 
 FBE0 6ADE 
 FBE1 6AF2 
 FBE2 6AF9 
 FBE3 6BA3 
 FBE4 6BAE 
 FBE5 6BBD 
 FBE6 6BC5 
 FBE7 6BC6 
 FBE8 6BE1 
 FBE9 68CC 
 FBEA 68E0 
 FBEB 68D4 
 FBEC 68DB 
 FBED 6CAC 
 FBEE 6CAD 
 FBEF 6CB0 
 FBF0 6CB1 
 FBF1 6CAE 
 FBF2 6CB3 
 FBF3 6CB5 
 FBF4 6CF3 
 FBF5 6CF7 
 FBF6 6DB3 
 FBF7 6DB4 
 FBF8 6DBD 
 FBF9 6DBE 
 FBFA 5CF3 
 FBFB 6DF6 
 FBFC 6EA4 
@ FC40 6EA7 
A FC41 6ED0 
B FC42 6EEE 
C FC43 6ED8 
D FC44 6EDB 
E FC45 6EEF 
F FC46 6EE3 
G FC47 6FA3 
H FC48 6FA1 
I FC49 6FB2 
J FC4A 6FAE 
K FC4B 6FD6 
END

for (@JEF_by_CP932_a) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %JEF_by_CP932_a = @JEF_by_CP932_a;
if (scalar(keys %JEF_by_CP932_a) != scalar(@JEF_by_CP932_a)/2) {
    die;
}

my %reverse_JEF_by_CP932_a = reverse @JEF_by_CP932_a;
if (scalar(keys %reverse_JEF_by_CP932_a) != scalar(@JEF_by_CP932_a)/2) {
    die;
}

for (@JEF_by_CP932_b) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %JEF_by_CP932_b = @JEF_by_CP932_b;
if (scalar(keys %JEF_by_CP932_b) != scalar(@JEF_by_CP932_b)/2) {
    die;
}

my %reverse_JEF_by_CP932_b = reverse @JEF_by_CP932_b;
if (scalar(keys %reverse_JEF_by_CP932_b) != scalar(@JEF_by_CP932_b)/2) {
    die;
}

if ("@JEF_by_CP932_a" ne "@JEF_by_CP932_b") {
    while (@JEF_by_CP932_a or @JEF_by_CP932_b) {
        my $a = shift @JEF_by_CP932_a;
        my $b = shift @JEF_by_CP932_b;
        if ($a ne $b) {
            print STDERR "A=$a\n";
            print STDERR "B=$b\n";
            print STDERR "\n";
        }
    }
    die;
}

%JEF_by_CP932 = @JEF_by_CP932_a;

sub JEF_by_CP932 {
    my($cp932) = @_;
    return $JEF_by_CP932{$cp932};
}

sub keys_of_JEF_by_CP932 {
    return keys %JEF_by_CP932;
}

sub values_of_JEF_by_CP932 {
    return values %JEF_by_CP932;
}

1;

__END__
