;; SKK English tutorial text (version 1.2)
;; Copyright (C) 1992 Masahiko Sato (masahiko@sato.riec.tohoku.ac.jp)
;;
;; This is the tutorial text for SKK Version 6.19 and and later versions.
;;
;; Permission is granted to make and distribute verbatim copies of
;; this tutorial text provided the copyright notice and this permission notice
;; are preserved on all copies.
;;
;; Permission is granted to copy and distribute modified versions of this
;; tutorial text under the conditions for verbatim copying, provided that 
;; the entire resulting derived work is distributed under the terms of a 
;; permission notice identical to this one.
;;
;; Permission is granted to copy and distribute translations of this tutorial
;; text into another language, under the above conditions for modified
;; versions, except that this permission notice may be stated in a
;; translation approved by Masahiko Sato.
;;
;; version 1.2 released 1992.9.19
;; version 1.1 released 1992.6.26
----
;; (skk-test-name)
== How to use the SKK tutorial ==

SKK is a software system that provides a very fast and efficient Japanese
input environment for Nemacs.  As it is implemented based on a very simple
principle, you can master the usage of SKK quickly. This tutorial explains
SKK assuming that you know enough about Nemacs.

You will learn the usage of SKK by solving problems.  The bottom line of
each Problem Window will begin with $@!Z(J>>$@![(J.  You have to make a line which
has the same content as that line in the Solution Window. When you are
done, type $@!X(JC-x n$@!Y(J(Next).  ($@!X(JC-x$@!Y(J means <control-x>, that is, typing
$@!X(Jx$@!Y(J key holding the control key.)  If your solution is correct, the
window will be updated and you will proceed to the next problem.

Type $@!X(JC-x q$@!Y(J(Quit) if you wish to quit the tutorial.  Type $@!X(JC-x s$@!Y(J
(Skip) if you wish to skip the problem.

>> 
----
== Invoking SKK, $@$+$J(J mode ==

In the following, if you encounter lines beginning with $@!Z(J!!$@![(J, follow the
instructions there.

You can invoke SKK by typig$@!X(JC-x C-j$@!Y(J.  Let's try that.

!! Type $@!X(JC-x C-j$@!Y(J.

Note that the left end of the mode line of the Solution Window is now
$@!Z$+$J![(J.  This mode is called $@$+$J(J mode.  In this mode, lower case latin
letters are interpreted as Romaji ($@%m!<%^;z(J) and will be converted to the
corresponding hirakanas.  For instance, if you type  $@!X(Jaiueo$@!Y(J, you will
get $@!Z$"$$$&$($*![(J.  (In $@$+$J(J mode, don't use upper case latin characters
until we explain about them.)

>> $@$+$-$/$1$3(J
----
== From $@$+$J(J mode to ASCII mode ==

You can move from $@$+$J(J mode to ASCII mode by typing $@!X(Jl$@!Y(J(for latin).

!! Type $@!X(Jl$@!Y(J now.

Note also how the mode line changed.

In ASCII mode, keys will be interpreted as ordinary Emacs commands. It is
almost identical with the state you were in just befor you invoked SKK,
and we will explain the tiny difference soon.  In ASCII mode, you will see
$@!Z(JSKK:$@![(J in the mode line, and this is to indicate that SKK has been
invoked in this buffer.

>> Now we are in ASCII mode.
----
== From ASCII mode to $@$+$J(J mode. ==

You can move from ASCII mode to $@$+$J(J mode by typing $@!X(JC-j$@!Y(J.  In summary:

	 l  : $@$+$J(J --> ASCII
	C-j : ASCII --> $@$+$J(J

>> ASCII $@$+$i(J $@$+$J(J
----
== $@%+%J(J mode ==

Input of katakana ($@%+%?%+%J(J) is done in $@%+%J(J mode.  You can move
between $@$+$J(J mode and $@%+%J(J mode by typing $@!X(Jq$@!Y(J(for qana = $@$+$J(J/$@%+%J(J
(^_^)).

	q : $@$+$J(J --> $@%+%J(J
	q : $@%+%J(J --> $@$+$J(J

>> $@$R$i$+$J(J $@$+$i(J $@%+%?%+%J(J $@$=$7$F$^$?(J $@$R$i$+$J(J
----
== How to input $@!Z$s![(J ==

$@!Z$s![(J can be input by $@!X(Jnn$@!Y(J or $@!X(Jn'$@!Y(J.  If it will be followed by a
consonant other than $@!X(Jn$@!Y(J or $@!X(Jy$@!Y(J, you may simply type $@!X(Jn$@!Y(J.

>> $@$+$J$+$s$8$X$s$+$s(J
----
== How to imput small $@$R$i$+$J(J characters==

You can enter each small hirakana character by prefixing $@!X(Jx$@!Y(J to its
romaji representation, e.g.:

	$@!X(Jxa$@!Y(J==>$@!Z$!![!"!X(Jxya$@!Y(J==>$@!Z$c![(J

However, in most cases, you can enter them like this:

	$@!X(Jchotto$@!Y(J==>$@!Z$A$g$C$H![!"!X(Jtyotto$@!Y(J==>$@!Z$A$g$C$H![(J

>> $@$"$C(J $@$=$&$@$C$?$N$+(J
----
== Input of long vowel ==

A long vowel may be entered by using:

	$@!X(J-$@!Y(J==>$@!Z!<![(J

>> $@$(!<$H(J
----
== $@A41Q(J (zenei) mode ==

Zenkaku ($@A43Q(J, square shaped) character strings like $@!Z#S#K#K![(J may be
entered in $@A41Q(J (zenei) mode.  In $@A41Q(J mode, latin characters $@!X(Ja$@!Y(J-$@!X(Jz$@!Y(J 
and $@!X(JA$@!Y(J-$@!X(JZ$@!Y(J are input as square shaped alphabets (normally occupying
double horizontal space compared to ASCII characters).  From either $@$+$J(J 
mode or $@%+%J(J mode, you can move to $@A41Q(J mode by typing $@!X(JL$@!Y(J(for Large
sized Latin).  From $@A41Q(J mode, you can return to $@$+$J(J/$@%+%J(J mode by $@!X(JC-j$@!Y(J.

	 L  : $@$+$J(J/$@%+%J(J -->   $@A41Q(J
	C-j :   $@A41Q(J    --> $@$+$J(J/$@%+%J(J

>> $@#S#K#K$,$D$+$($k$N$O#N#e#m#a#c#s$@$1$G$9(J
----
== Summary up to this point ==

You can invoke SKK by $@!X(JC-x C-j$@!Y(J.  SKK has four modes:

	ASCII mode, $@$+$J(J mode, $@%+%J(J mode, $@A41Q(J mode

You can change modes as follows:

	ASCII  == C-j ==>  $@$+$J(J/$@%+%J(J  == l ==> ASCII

	$@$+$J(J <== q ==> $@%+%J(J

	$@A41Q(J   == C-j ==>  $@$+$J(J/$@%+%J(J  == L ==> $@A41Q(J

>> $@#S#K#K$K$O(J ASCII$@%b!<%I(J $@$H(J $@$+$J%b!<%I(J $@$H(J $@%+%J%b!<%I(J $@$H(J $@$<$s$($$%b!<%I(J $@$,$"$k(J
----
;; (skk-test-today)
== $@$+$J(J mode ==

In $@$+$J(J mode, the following keys have special meanings.  Other keys such
as $@!X(JC-a$@!Y(J, $@!X(J%$@!Y(J are interpreted as ordinary Emacs keys.  This is also
the case for $@%+%J(J mode.  The problem here is a bit tricky, but you should
be able to solve it by reading the following carefully.

	l$@!"(Jq$@!"(Jx$@!"(JL		Already explained.
	Other small alphabets.	Interpreted as romaji, and entered as $@$+$J(J.
	Big alphabets.		Enter kana-to-kanji conversion mode.
	/			Enter ASCII conversion mode. (To be explained.)
	,			Input as $@!Z!"![(J.
	.			Input as $@!Z!#![(J.
	@			Input today's date.
	[ and ]			Input as$@!Z!V![(J and $@!Z!W![(J.

>> 
----
;; (skk-enable)
== Kana-to-kanji conversion ==

Kana-to-kanji conversion is done in $@$+$J(J mode.

!! If you are not in $@$+$J(J mode now, change mode to $@$+$J(J mode, and type
!! $@!X(JKanji$@!Y(J.  (Note that the first character is an uppercase character.)

The window should become $@!Z"&$+$s$8![(J.  You are in $@"&(J mode now.

!! Now hit <space> key.

You have: $@!Z"'4A;z![(J.  You are in $@"'(J mode now.

!! Type $@!X(JC-j$@!Y(J.

You have solved the following problem!

>> $@4A;z(J
----
;; (skk-use-jisyo "$@$+$s$8(J /$@4A;z(J/$@44;v(J/$@4F;v(J/\n")
Let's try another one.

!! If you are not in $@$+$J(J mode now, change mode to $@$+$J(J mode, type
!! $@!X(JKanji$@!Y(J, and then hit <space> key twice.

The window should change as follows:

	$@!Z"&$+$s$8![(J ==> $@!Z"'4A;z![(J ==> $@!Z"'44;v![(J

!! Type $@!X(JC-j$@!Y(J.

You got the solution!

>> $@44;v(J
----
;; (skk-use-jisyo "$@$+$s$8(J /$@44;v(J/$@4A;z(J/$@4F;v(J/\n$@$K$e$&$j$g$/(J /$@F~NO(J/\n$@$h$&$$(J /$@MF0W(J/$@MQ0U(J/\n")
This one is slightly more complicated, so type carefully.  $@!X""!Y(J will
denote a <space> key.  If you see $@!X""""!Y(J, for instance, type <space> key
twice.

!! Change mode to $@$+$J(J mode if necessary and type
!! $@!X(JKanji$@""""(JnoNyuuryoku$@""(JhaYoui$@""(Jdesu.$@!Y(J.

>> $@4A;z$NF~NO$OMF0W$G$9!#(J
----
;; (skk-use-jisyo "$@$+$s$8(J /$@4A;z(J/$@44;v(J/$@4F;v(J/\n")
!! In $@$+$J(J mode, type $@!X(Jkanji$@!Y(J.

You get $@!Z$+$s$8![(J.  Suppose, however, that you should have typed $@!X(JKanji$@!Y(J.
You can delete 3 characters backwards and type $@!X(JKanji$@!Y(J in such a case.
But, there is also the following alternative way to achieve the same effect.

!! Type $@!X(JC-b$@!Y(J(backward-char) 3 times.

Cursor is now on $@!Z$+![(J.

!! Type $@!X(JQ$@!Y(J.

$@!Z"&![(J is inserted before $@!Z$+![(J, and you are in $@"&(J mode.

!! Type $@!X(JC-e$@!Y(J(end-of-line), $@!X""!Y(J(<space>), and $@!X(JC-j$@!Y(J.

>> $@4A;z(J
----
== Sub modes of $@$+$J(J mode ==

$@$+$J(J mode is divided into two submodes: hirakana no-conversion mode and
conversion to Kanji mode.  Hirakana no-conversion mode will be referred to
as $@"#(J mode.  Conversion to kanji mode is further divided into two modes: 
$@"&(J mode and $@"'(J mode.  Namely, $@$+$J(J mode is divided into three submodes:

	$@"#(J mode, $@"&(J mode, $@"'(J mode

In $@"#(J mode, lower case romaji characters you type are converted to
hirakanas and are inserted into the buffer.  These hirakanas are not
converted to Kanji anymore.  $@"#(J mode is the basic mode of SKK and you
should remember this point.

>> $@$R$i$+$J$+$/$F$$$K$e$&$j$g$/$O!"$J$s$I$b!"$l$s$7$e$&$7$F$-$^$7$?!#(J
----
;; (skk-use-jisyo "$@$;$s$?$/(J /$@A*Br(J/$@@vBu(J/\n")
== $@"&(J mode and $@"'(J mode ==

Kana-to-kanji conversion in SKK is done as follows.
	1 Determine the string which is the source of conversion. ($@"&(J mode)
	2 Show candidates of conversion for the source. ($@"'(J mode)
	3 Select the candidate you want and finish the conversion. ($@"'(J mode)
As we have already seen, in the case of entering $@!Z4A;z![(J, the source
string of the conversion is $@!Z$+$s$8![(J.  If you type $@!X(JKanji$@!Y(J, $@!Z$+$s$8![(J 
will be entered in $@"&(J mode.  If you hit <space> in $@"&(J mode, the string
between $@!Z"&![(J and the cursor becomes the source of the conversion.  At
the same time, the mode becomes $@"'(J mode and the first candidate will be
shown.  In $@"'(J mode, <space> displays the next candidate.  If you type 
$@!X(JC-j$@!Y(J in $@"'(J mode, the current candidate becomes the final result of the
conversion, and the mode becomes $@"#(J mode.

Hint: $@@vBu(J($@$;$s$?$/(J), $@A*Br(J($@$;$s$?$/(J)

>> $@!V@vBu!W$rA*Br$9$k!#(J
----
;; (skk-use-jisyo "$@$3$&$Y(J /$@?@8M(J/\n$@$*$*$5$+(J /$@Bg:e(J/\n$@$-$g$&$H(J /$@5~ET(J/\n")
Modes related to SKK usually change as follows.

	$@"#(J == Upper case char. ==> $@"&(J == <space> ==> $@"'(J == $@!X(JC-j$@!Y(J ==> $@"#(J

	$@"&(J == $@!X(JC-j$@!Y(J ==> $@"#(J

is used to go back to $@"#(J mode when you enter $@"&(J mode by mistake.

	$@"'(J == <return> and all the pritable keys  ==> $@"#(J

means that these keys automatically select the current candidate as the
final result of converersion.  This action is called kakutei ($@3NDj(J). Let
us try this.

!! Type $@!X(JKyouto$@""(J,Oosaka$@""(J,Koube$@""(J.$@!Y(J in $@"#(J mode.  Recall that
!! $@!X""!Y(J denotes a <space> key.

>> $@5~ET!"Bg:e!"?@8M!#(J
----
;; (skk-use-jisyo "$@$X$s$+$s(J /$@JQ49(J/\n$@$+$s$8(J /$@44;v(J/$@4A;z(J/\n$@$+$J(J /$@2>L>(J/\n")
We have learned that, in $@"'(J mode, <return> and all the printable keys
cause kakutei as side effects.

Moreover, if you type any upper case character other than $@!X(JL$@!Y(J, the
current candidate becomes the final result and enter $@"&(J mode.

	$@"'(J == upper case char. other than $@!X(JL$@!Y(J ==> $@"&(J

!! Type $@!X(JKana$@""(JKanji$@""""(JHenkan$@""(J.$@!Y(J in $@"#(J mode.

>> $@2>L>4A;zJQ49!#(J
----
;; (skk-use-jisyo "$@$X$s$+$s(J /$@JQ49(J/\n$@$+$s$8(J /$@4A;z(J/$@44;v(J/\n$@$+$J(J /$@2>L>(J/\n")
!! Type $@!X(JKanakanjihenkan$@""!Y(J in $@"#(J mode.

Your window becomes $@!Z"'$+$J$+$s$8$X$s$+$s![(J and you should see the prompt:
	$@$+$J$+$s$8$X$s$+$s(J
in the echo area.  In $@"'(J mode, the source string to be converted is
already fixed.  In our case, SKK tried to convert the string $@!Z$+$J$+$s$8(J
$@$X$s$+$s![(J, but could not found it in the Jisho ($@<-=q(J, dictionary) buffer.
In such a case, SKK automatically enters register-a-word-to-dictionary
mode (this mode will be referred to as $@<-=qEPO?(J mode).
  In $@<-=qEPO?(J mode, the string for which the conversion failed becomes the
key word ($@8+=P$78l(J, midashigo) for the new entry to be registered to $@<-=q(J
buffer.

!! Verify that the cursor is in the echo area, and type
!! $@!X(JKana$@""(JKanji$@""(JHenkan$@""!Y(J followed by <return> key.

>> $@2>L>4A;zJQ49(J
----
;; (skk-use-jisyo "$@$+$J$+$s$8$X$s$+$s(J /$@2>L>4A;zJQ49(J/\n$@$X$s$+$s(J /$@JQ49(J/\n$@$+$s$8(J /$@4A;z(J/$@44;v(J/\n$@$+$J(J /$@2>L>(J/\n")
We have just added the line

	$@$+$J$+$s$8$X$s$+$s(J /$@2>L>4A;zJQ49(J/

to the $@<-=q(J buffer.  We can verify this as follows.

!! Type $@!X(JKanakanjihenkan$@""!Y(J in $@"#(J mode, and
!! $@3NDj(J (kakutei, finalize) it by $@!X(JC-j$@!Y(J.

>> $@2>L>4A;zJQ49(J
----
;; (skk-use-jisyo "$@$+$J$+$s$8$X$s$+$s(J /$@2>L>4A;zJQ49(J/\n$@$X$s$+$s(J /$@JQ49(J/\n$@$+$s$8(J /$@4A;z(J/$@44;v(J/\n$@$+$J(J /$@2>L>(J/\n")
== empty $@EPO?(J (registration) ==

If you enter $@<-=qEPO?(J mode by mistake, you can abort it by hitting $@!X(JC-g$@!Y(J 
or by registering an empty string.

!! Type $@!X(JKanakanjihenken$@""!Y(J in $@"#(J mode.

$@<-=q(J does not contain $@!Z$+$J$+$s$8$X$s$1$s![(J, so you get $@!Z$+$J$+$s$8$X$s(J
$@$1$s![(J in the echo area.

!! Veriry that the cursor is in the echo area, and hit <return>.

The $@!Z(J*$@Ez(J*$@![(J window now becomes $@!Z"&$+$J$+$s$8$X$s$1$s![(J.

!! Verify that the cursor is in the $@!Z(J*$@Ez(J*$@![(J window.  Hit <delete> key
!! twice, and then type $@!X(Jkan$@""(J.$@!Y(J.

>> $@2>L>4A;zJQ49!#(J
----
;; (skk-use-jisyo "$@$4(J /$@8^(J/$@8_(J/$@8`(J/$@8a(J/$@8b(J/$@8c(J/$@8d(J/$@8e(J/$@8f(J/$@8g(J/$@8h(J/$@8i(J/$@8j(J/$@8k(J/$@8l(J/$@8m(J/$@8n(J/$@8o(J/\n")
We assume that $@<-=q(J contains the line:

	$@$4(J /$@8^(J/$@8_(J/$@8`(J/$@8a(J/$@8b(J/$@8c(J/$@8d(J/$@8e(J/$@8f(J/$@8g(J/$@8h(J/$@8i(J/$@8j(J/$@8k(J/$@8l(J/$@8m(J/$@8n(J/$@8o(J/

You can enter $@!Z8k![(J as follows.

!! Type $@!X(JGo$@""""""""""""!Y(J in $@"#(J mode. (You have to hit <space> 6 times.)

You now see the line:

	A:$@8i(J  S:$@8j(J  D:$@8k(J  F:$@8l(J  J:$@8m(J  K:$@8n(J  L:$@8o(J  [$@;D$j(J 0]

in the echo area.  As we have just seen, after the fifth candidate, 7 of
them are displayed together in the echo area.  To select $@!Z8k![(J, type
small $@!X(Jd$@!Y(J.

>> $@8k(J
----
;; (skk-use-jisyo "$@$4(J /$@8k(J/$@8^(J/$@8_(J/$@8`(J/$@8a(J/$@8b(J/$@8c(J/$@8d(J/$@8e(J/$@8f(J/$@8g(J/$@8h(J/$@8i(J/$@8j(J/$@8l(J/$@8m(J/$@8n(J/$@8o(J/\n")
!! Type $@!Z(JGo$@""![(J in $@"#(J mode.

This time $@!Z8k![(J is displayed as the first candidate.  This is because we
have kekutei-ed by that character.  But we want $@!Z8a![(J this time.

!! Type $@!X""""""""""""!Y(J. (6 <space>'s.)

We entered $@<-=qEPO?(J mode as we ran out of kouhos.  Actually $@!Z8a![(J was
among the candidated but we had overrun.

!! Hit <return> key and type $@!X(Jx$@!Y(J.

<return> key registers an empty string (which actually does no real
registration) and we return to the state just before $@<-=qEPO?(J. In $@"'(J mode,
we can return to previous candiate(s) by the $@!X(Jx$@!Y(J key.  You should now be
able to select $@!Z8a![(J from the candidates in the minibuffer.

>> $@8a(J
----
;; (skk-use-jisyo "$@$4(J /$@8a(J/$@8k(J/$@8^(J/$@8_(J/$@8`(J/$@8b(J/$@8c(J/$@8d(J/$@8e(J/$@8f(J/$@8g(J/$@8h(J/$@8i(J/$@8j(J/$@8l(J/$@8m(J/$@8n(J/$@8o(J/\n")
We try $@!Z8a8e![(J this time.

!! Type $@!X(JGogo$@""!Y(Jin $@"#(J mode.

As there is no $@!Z$4$4![(J in the $@<-=q(J buffer, we enter $@<-=qEPO?(J mode.

!! Verify that the minbuffer prompt is $@!Z$4$4![(J, and type $@!X(JGo$@""!Y(J.

Minibuffer becomes $@!Z$4$4(J $@"'8a![(J.

!! Then, type $@!X(JGo$@""""""""""(Jj$@!Y(J.

We have $@!Z$4$4(J $@8a8e![(J in the minibuffer.

!! Hit <return> key.

>> $@8a8e(J
----
;; (skk-use-jisyo "$@$4$4(J /$@8a8e(J/\n$@$4(J /$@8e(J/$@8a(J/$@8k(J/$@8^(J/$@8_(J/$@8`(J/$@8b(J/$@8c(J/$@8d(J/$@8f(J/$@8g(J/$@8h(J/$@8i(J/$@8j(J/$@8l(J/$@8m(J/$@8n(J/$@8o(J/\n")
We now have the entry $@!Z$4$4(J /$@8a8e(J/$@![(J in the  $@<-=q(J buffer.  So the
following problem should be easy.

>> $@8a8e$N8k!#(J
----
;; (skk-use-jisyo "$@$5$$(J /$@:Y(J/$@:G(J/$@:F(J/\n$@$-(J /$@4p(J/$@5-(J/$@5$(J/$@LZ(J/$@5"(J/\n$@$F$-(J /$@E*(J/$@E((J/$@E)(J/$@E,(J/$@E&(J/\n$@$8$7$g(J /$@<-=q(J/$@CO=j(J/\n$@$H$&$m$/(J /$@EPO?(J/\n$@$,$/$7$e$&(J /$@3X=,(J/\n")
== Recursive $@<-=qEPO?(J ==

!! Type $@!X(JSaikiteki$@""!Y(J in $@"#(J mode.
!! Verify the prompt $@!Z$5$$$-$F$-![(J in the echo area, and type $@!X(JSaiki$@""!Y(J.

We don't have $@!Z$5$$$-![(J in the minibuffer either, so we recursively
(i.e., $@:F5"E*$K(J) enter $@<-=qEPO?(J mode.

!! Construct $@!Z:F5"![(J in the minibuffer.  (Hint: $@:F(J($@$5$$(J), $@5"(J($@$-(J))
!! Hit <return> key after you have $@!Z$5$$$-(J $@:F5"![(J in the minibuffer.

Now we can continue the registration of $@!Z$5$$$-$F$-![(J.

!! You should have $@!Z$5$$$-$F$-(J $@:F5"![(J in the minibuffer. Construct $@!ZE*![(J.

Hint: $@<-=q(J($@$8$7$g(J), $@EPO?(J($@$H$&$m$/(J), $@3X=,(J($@$,$/$7$e$&(J)
>> $@:F5"E*<-=qEPO?$r3X=,$7$^$7$?!#(J
----
;; (skk-use-okuri-jisyo "$@$&$4(Jk /$@F0(J/\n")
== How to enter words with okurigana ==

Words like $@!VF0$/!W(J have okurigana parts, and SKK $@<-=q(J have entries like:

	$@$&$4(Jk /$@F0(J/

for these words.  We make use of these entries to enter words with
okuriganas.

!! in $@"#(J mode, type $@!X(JUgoKounimoUgoKenakatta.$@!Y(J.

Some nouns become verbs by affixing them with $@!V$9$k!W(J, but for such verbs
it is recommened to enter the original noun and the okurigana part
separately.

>> $@F0$3$&$K$bF0$1$J$+$C$?!#(J
----
;; (skk-use-jisyo "$@$I$&(J /$@F0(J/\n")
== How to register words with okurigana ==

Let's see what happens if the $@<-=q(J does not have $@!V$&$4(Jk$@!W(J as $@8+=P$78l(J.

!! In $@"#(J mode, type$@!X(JUgoKu$@!Y(J.

We enter $@<-=qEPO?(J mode in the minibuffer, and we have the prompt $@!Z$&$4(J*$@$/(J 
$@![(J.  As the $@<-=q(J has the entry $@!V$I$&(J /$@F0(J/$@!W(J, we can make $@!ZF0![(J in the
minibuffer.

Remark: You have only to construct the main part without the okurigana,
in the minibuffer.

!! Hit <return> key after you have $@!ZF0![(J in the minibuffer.

>> $@F0$/(J
----
;; (skk-use-okuri-jisyo "$@$D$+(Jt /$@;H(J/\n$@$[$C(Js /$@M_(J/\n$@$?$C(Js /$@C#(J/\n$@$7(Jt /$@CN(J/\n" "$@$8$s$3$&(J /$@?M8}(J/\n$@$$$A$*$/(J /$@0l2/(J/\n")
== How to enter words containing double consonants. ==

We do this like the following:

	$@!X(JTukaTta$@""!Y(J $@"*(J $@!Z;H$C$?![(J
	$@!X(JHosSuru$@""!Y(J $@"*(J $@!ZM_$9$k![(J

where our $@<-=q(J is like:

	$@$D$+(Jt /$@;H(J/
	$@$[$C(Js /$@M_(J/

Hint: $@?M8}(J($@$8$s$3$&(J), $@0l2/(J($@$$$A$*$/(J), $@C#$7$?(J($@$?$C$7$?(J), $@CN$C$?(J($@$7$C$?(J)

>> $@?M8}$,0l2/$KC#$7$?$3$H$rCN$C$?!#(J
----
;; (skk-use-jisyo "$@$H$&$m$/(J /$@EPO?(J/\n")
== ASCII conversion ==

It is possible to enter $@8+=P$78l(J in ascii charaters, and tranform them.
This is called $@!V1Q;zJQ49!W(J(ASCII conversion).

!! In $@"#(J mode, type $@!X(J/file$@""!Y(J.

Typing $@!X(J/$@!Y(J in $@"#(J mode lets you enter $@"&(J mode.  Unlike ordinary $@"&(J mode,
however, the ascii characters you type will be entered without any
transoformations.  In this case, our $@<-=q(J does not have the $@8+=P$78l(J 
$@!V(Jfile$@!W(J, we enter $@<-=qEPO?(J mode.

!! Verify that the prompt in the minibuffer is $@!Z(Jfile$@![(J, and type
!! $@!X(Jqfairu$@!Y(J, and then hit <return> key.

>> $@!V%U%!%$%k!W$,EPO?$5$l$^$7$?!#(J
----
;; (skk-use-jisyo "$@$-$4$&(J /$@5-9f(J/$@!"(J/$@!#(J/$@!$(J/$@!%(J/$@!&(J/$@!'(J/$@!((J/$@!)(J/$@!*(J/$@!+(J/$@!,(J/$@!-(J/$@!.(J/$@!/(J/$@!0(J/$@!1(J/$@!2(J/$@!3(J/$@!4(J/$@!5(J/$@!6(J/$@!7(J/$@!8(J/$@!9(J/$@!:(J/$@!;(J/$@!<(J/$@!=(J/$@!>(J/$@!?(J/$@!@(J/$@!A(J/$@!B(J/$@!C(J/$@!D(J/$@!E(J/$@!F(J/$@!G(J/$@!H(J/$@!I(J/$@!J(J/$@!K(J/$@!L(J/$@!M(J/$@!N(J/$@!O(J/$@!P(J/$@!Q(J/$@!R(J/$@!S(J/$@!T(J/$@!U(J/$@!V(J/$@![(J/$@!X(J/$@!Y(J/$@!Z(J/$@![(J/$@!\(J/$@!](J/$@!^(J/$@!_(J/$@!`(J/$@!a(J/$@!b(J/$@!c(J/$@!d(J/$@!e(J/$@!f(J/$@!g(J/$@!h(J/$@!i(J/$@!j(J/$@!k(J/$@!l(J/$@!m(J/$@!n(J/$@!o(J/$@!p(J/$@!q(J/$@!r(J/$@!s(J/$@!t(J/$@!u(J/$@!v(J/$@!w(J/$@!x(J/$@!y(J/$@!z(J/$@!{(J/$@!|(J/$@!}(J/$@!~(J/$@"!(J/$@""(J/$@"#(J/$@"$(J/$@"%(J/$@"&(J/$@"'(J/$@"((J/$@")(J/$@"*(J/$@"+(J/$@",(J/$@"-(J/$@".(J/\n")
== Symbols ==

The following symbols are registered in the $@<-=q(J under the $@8+=P$78l(J 
$@!V$-$4$&!W(J.

      $@!!(J $@!"(J $@!#(J $@!$(J $@!%(J $@!&(J $@!'(J $@!((J $@!)(J $@!*(J $@!+(J $@!,(J $@!-(J $@!.(J $@!/(J $@!0(J $@!1(J $@!2(J $@!3(J $@!4(J $@!5(J $@!6(J $@!7(J
   $@!8(J $@!9(J $@!:(J $@!;(J $@!<(J $@!=(J $@!>(J $@!?(J $@!@(J $@!A(J $@!B(J $@!C(J $@!D(J $@!E(J $@!F(J $@!G(J $@!H(J $@!I(J $@!J(J $@!K(J $@!L(J $@!M(J $@!N(J $@!O(J
   $@!P(J $@!Q(J $@!R(J $@!S(J $@!T(J $@!U(J $@!V(J $@![(J $@!X(J $@!Y(J $@!Z(J $@![(J $@!\(J $@!](J $@!^(J $@!_(J $@!`(J $@!a(J $@!b(J $@!c(J $@!d(J $@!e(J $@!f(J $@!g(J
   $@!h(J $@!i(J $@!j(J $@!k(J $@!l(J $@!m(J $@!n(J $@!o(J $@!p(J $@!q(J $@!r(J $@!s(J $@!t(J $@!u(J $@!v(J $@!w(J $@!x(J $@!y(J $@!z(J $@!{(J $@!|(J $@!}(J $@!~(J
      $@"!(J $@""(J $@"#(J $@"$(J $@"%(J $@"&(J $@"'(J $@"((J $@")(J $@"*(J $@"+(J $@",(J $@"-(J $@".(J $@"/(J $@"0(J $@"1(J $@"2(J $@"3(J $@"4(J $@"5(J $@"6(J $@"7(J

>> $@")(J980
----
;; (skk-use-jisyo "greek /$@&A(J/$@&B(J/$@&C(J/$@&D(J/$@&E(J/$@&F(J/$@&G(J/$@&H(J/$@&I(J/$@&J(J/$@&K(J/$@&L(J/$@&M(J/$@&N(J/$@&O(J/$@&P(J/$@&Q(J/$@&R(J/$@&S(J/$@&T(J/$@&U(J/$@&V(J/$@&W(J/$@&X(J/\nGreek /$@&!(J/$@&"(J/$@&#(J/$@&$(J/$@&%(J/$@&&(J/$@&'(J/$@&((J/$@&)(J/$@&*(J/$@&+(J/$@&,(J/$@&-(J/$@&.(J/$@&/(J/$@&0(J/$@&1(J/$@&2(J/$@&3(J/$@&4(J/$@&5(J/$@&6(J/$@&7(J/$@&8(J/\nrussia /$@'Q(J/$@'R(J/$@'S(J/$@'T(J/$@'U(J/$@'V(J/$@'W(J/$@'X(J/$@'Y(J/$@'Z(J/$@'[(J/$@'\(J/$@'](J/$@'^(J/$@'_(J/$@'`(J/$@'a(J/$@'b(J/$@'c(J/$@'d(J/$@'e(J/$@'f(J/$@'g(J/$@'h(J/$@'i(J/$@'j(J/$@'k(J/$@'l(J/$@'m(J/$@'n(J/$@'o(J/$@'p(J/$@'q(J/\nRussia /$@'!(J/$@'"(J/$@'#(J/$@'$(J/$@'%(J/$@'&(J/$@''(J/$@'((J/$@')(J/$@'*(J/$@'+(J/$@',(J/$@'-(J/$@'.(J/$@'/(J/$@'0(J/$@'1(J/$@'2(J/$@'3(J/$@'4(J/$@'5(J/$@'6(J/$@'7(J/$@'8(J/$@'9(J/$@':(J/$@';(J/$@'<(J/$@'=(J/$@'>(J/$@'?(J/$@'@(J/$@'A(J/\n")
== Greek and Russian characters ==

They are registered in the $@<-=q(J as follows.

Greek /$@&!(J/$@&"(J/$@&#(J/$@&$(J/$@&%(J/$@&&(J/$@&'(J/$@&((J/$@&)(J/$@&*(J/$@&+(J/$@&,(J/$@&-(J/$@&.(J/$@&/(J/$@&0(J/$@&1(J/$@&2(J/$@&3(J/$@&4(J/$@&5(J/$@&6(J/$@&7(J/$@&8(J/
greek /$@&A(J/$@&B(J/$@&C(J/$@&D(J/$@&E(J/$@&F(J/$@&G(J/$@&H(J/$@&I(J/$@&J(J/$@&K(J/$@&L(J/$@&M(J/$@&N(J/$@&O(J/$@&P(J/$@&Q(J/$@&R(J/$@&S(J/$@&T(J/$@&U(J/$@&V(J/$@&W(J/$@&X(J/
Russia /$@'!(J/$@'"(J/$@'#(J/$@'$(J/$@'%(J/$@'&(J/$@''(J/$@'((J/$@')(J/$@'*(J/$@'+(J/$@',(J/$@'-(J/$@'.(J/$@'/(J/$@'0(J/$@'1(J/$@'2(J/$@'3(J/$@'4(J/$@'5(J/$@'6(J/$@'7(J/$@'8(J/$@'9(J/$@':(J/$@';(J/$@'<(J/$@'=(J/$@'>(J/$@'?(J/$@'@(J/$@'A(J/
russia /$@'Q(J/$@'R(J/$@'S(J/$@'T(J/$@'U(J/$@'V(J/$@'W(J/$@'X(J/$@'Y(J/$@'Z(J/$@'[(J/$@'\(J/$@'](J/$@'^(J/$@'_(J/$@'`(J/$@'a(J/$@'b(J/$@'c(J/$@'d(J/$@'e(J/$@'f(J/$@'g(J/$@'h(J/$@'i(J/$@'j(J/$@'k(J/$@'l(J/$@'m(J/$@'n(J/$@'o(J/$@'p(J/$@'q(J/

We can use $@1Q;zJQ49(J (ASCII conversion) to enter these characters.

>> $@&E&D(J
----
;; (skk-use-jisyo "$@$H$&$[$/(J /$@ElKL(J/\n$@$H$&(J /$@El(J/\n$@$[$/(J /$@KL(J/\n$@$@$$(J /$@Bg(J/$@Bh(J/$@Be(J/\n")
== Input by code ==

You can enter any Kanji characters by their codes (either JIS or EUC).

For example, the JIS code for $@!VU\!W(J is $@!V(J555C$@!W(J.  So you can enter it as
follows.

!! In $@"#(J mode, type $@!X(J\$@!Y(J.

You get the prompt $@!Z(JJIS or EUC code: (00nn or CR for Jump Menu)$@![(J.

!! Type $@!X(J555c$@!Y(J and hit <return> key.

Hint: $@ElKL(J($@$H$&$[$/(J), $@Bg(J($@$@$$(J)

>> $@ElKLBgU\(J
----
;; (skk-use-jisyo "$@$R$3$&$-(J /$@Ht9T5!(J/\n")
== Completion of $@8+=P$78l(J ==

Hitting <tab> key in $@"&(J mode invokes completion of $@8+=P$78l(J.  Let $@&R(J be
the string you entered in $@"&(J mode just befor you type <tab>.  Then the
first occurrence (if any) of such a $@&S(J in the $@<-=q(J buffer that has $@&R(J as
its initial segement and distinct from $@&R(J will be displayed.

!! In $@"#(J mode, type $@!X(JkonoHikouki$@""(JyorianoHi$@!Y(J.

The display becomes $@!Z$3$NHt9T5!$h$j$"$N"&$R![(J.

!! Now, hit <tab> key.

Completion is performed and the display becomes 
$@!Z$3$NHt9T5!$h$j$"$N"&$R$3$&$-![(J.

>> $@$3$NHt9T5!$h$j$"$NHt9T5!$K$7$h$&!#(J
----
;; (skk-use-jisyo "$@$5$$$H$&(J /$@:XF#(J/\n$@$5$H$&(J /$@:4F#(J/\n$@$5$$$7$g(J /$@:G=i(J/\n$@$_$g$&$8(J /$@L>;z(J/\n")
The $@8+=P$78l(J search for the completion is performed starting from the
beginning of the $@<-=q(J buffer.  Therefore, if there are several $@8+=P$78l(J 
in the $@<-=q(J buffer whose initial segment matches $@&R(J, then the first such
string will be displayed.  If that is not what you expected, you can type 
$@!X(J.$@!Y(J(period) to get the second candiate, and you can continue to type $@!X(J.$@!Y(J
to get more candates.  If you have overrun, you can back up by typing 
$@!X(J,$@!Y(J(comma) several times. 

Let us try to enter the sentence $@!V:4F#$H:XF#$G$O:4F#$N$[$&$,$"$j$U$l$?L>(J
$@;z$@!#!W(J.

!! In $@"#(J mode, type $@!X(JSatou$@""(JtoSaitou$@""(JdehaSa$@!Y(J and hit <tab> key.

The display becomes$@!Z:4F#$H:XF#$G$O"&$5$$$H$&![(J.

!! Type $@!X(J..,$@!Y(J.

>> $@:4F#$H:XF#$G$O:4F#$N$[$&$,$"$j$U$l$?L>;z$@!#(J
----
;; (skk-use-jisyo "$@$7$e$&$j$g$&(J /$@=*N;(J/\n")
When SKK is invoked for the first time in the current Nemacs session, it
reads in your personal $@<-=q(J file into the $@<-=q(J buffers.  (We use two
$@<-=q(J buffers, one for words with okurigana, and for those without
okurigana.)  A $@<-=q(J buffer will be updated each time you make a kakutei.
When you exit from Nemacs, SKK saves the content of the $@<-=q(J buffer into
your personal $@<-=q(J file.  So, normally, you don't have to worry about
savings of the $@<-=q(J buffers.  When SKK updates your personal $@<-=q(J file
(.skk-jisyo) it copies the content of the current .skk-jisyo to
.skk-jisyo.BAK.  This back up file may be useful if your .skk-jisyo is
damaged accidentaly.

SKK has a lot more features we couldn't explain in this short tutorial.
For further information about SKK refer to the SKK manual.

Here is your last problem.  Hint: $@=*N;(J($@$7$e$&$j$g$&(J)

>> $@$3$l$G(J SKK $@%A%e!<%H%j%"%k$r=*N;$7$^$9!#(J
----
;; (skk-end-of-tutorial)

;; Local Variables:
;; mode:skk-auto-fill-t
;; fill-column:74
;; End:
