.\"Do not edit this file.  It was created from units.texinfo
.\"using texi2man version 1.01k on Thu Dec  8 21:32:27 EST 2011
.\"Copyright (C) 1996, 1997, 1999, 2000, 2001, 2002, 2004, 2005, 2007, 2011
.\"Free Software Foundation, Inc.
.\"
.\"This file is free software; the author gives unlimited permission to
.\"copy, translate and/or distribute it, with or without modifications, as
.\"long as this notice is preserved.
.\"
.TH UNITS 1   "28 November 2011"
.\"
.\" Extensions to man macros
.\"
.\" Constant-width font
.de CW
.hy 0
.if n \{\
.ie \\n(.$>2 \&\\$1'\\$2'\\$3
.el \&'\\$1'\\$2
.\}
.if t \{\
.ie \\n(.$>2 \&\\$1\f(CW\\$2\fR\\$3
.el \&\f(CW\\$1\fR\\$2
.\}
.hy 14
..
.\" Constant-width oblique font
.de CI
.hy 0
.if n \{\
.ie \\n(.$>2 \&\\$1'\fI\\$2\fR'\\$3
.el \&'\fI\\$1\fR'\\$2
.\}
.if t \{\
.ie \\n(.$>2 \&\\$1\f(CI\\$2\fR\\$3
.el \&\f(CI\\$1\fR\\$2
.\}
.hy 14
..
.\" Constant-width font with quotes
.de CQ
.hy 0
.if n \{\
.ie \\n(.$>2 \&\\$1'\\$2'\\$3
.el \&'\\$1'\\$2
.\}
.if t \{\
.ie \\n(.$>2 \&\\$1`\f(CW\\$2\fR'\\$3
.el \&`\f(CW\\$1\fR'\\$2
.\}
.hy 14
..
.\" Example start
.de ES
.hy 0
.if t \{\
.in +4n
.if '\\$1'S' \{\
.nr Ex 1
.ps -1
.\}
.el .nr Ex 0
.nr mE \\n(.f
.ft CW
.\}
.if n .in +3n
.nf
..
.\" Example end
.de EE
.if t \{\
.ft \\n(mE
.if \\n(Ex=1 .ps
.\}
.fi
.in
.hy 14
..
.SH NAME
units \(em unit conversion and calculation program
.PP
.SH SYNOPSIS
.PP
.CW units
.RI [ options ]
.RI [ from-unit
.RI [ to-unit ]]
.PP
.SH DESCRIPTION
The
.CW "units"
program converts quantities expressed in various
systems of measurement to their equivalents in other systems of
measurement.  Like many similar programs, it can handle multiplicative
scale changes. It can also handle nonlinear conversions such as
Fahrenheit to
Celsius.
See the examples below.  
The program can also perform conversions from and to sums of
units, such as converting between meters and feet plus inches.  
.PP
Beyond simple unit conversions,
.CW "units"
can be used as a
general-purpose scientific calculator that keeps track of units in its
calculations.  You can form arbitrary complex mathematical expressions
of dimensions including sums, products, quotients, powers, and even roots
of dimensions.  Thus you can ensure accuracy and dimensional consistency
when working with long expressions that involve many different units
that may combine in complex ways.  
.PP
The units are defined in an external data file.  You can use the
extensive data file that comes with this program, or you can 
provide your own data file to suit your needs.  You can also use your
own data file to supplement the standard data file.
.PP
Basic
operation is simple: you enter the units that you want to convert
\fIfrom\fP and the units that you want to convert \fIto\fP.
You can use the program interactively with prompts, or you can use it
from the command line.
This document describes the basic as well as the advanced features of
.CW "units"
in detail, with many examples.
.PP
.SH INTERACTING WITH \f(BIUNITS\fP
To invoke units for interactive use, type
.CI "units"
at your shell
prompt.  The program will print something like this:
.PP
.ES
2131 units, 53 prefixes, 24 nonlinear units
    
You have:
.EE
.PP
At the
.CQ "You have:"
prompt, type the quantity and units that
you are converting \fIfrom\fP.  For example, if you want to convert ten
meters to feet, type
.CI "10 meters" .
Next,
.CW "units"
will print
.CQ "You want:" .
You should type the units you want to convert
\fIto\fP.  To convert to feet, you would type
.CI "feet" .
Note that if
the
.CW "readline"
library was compiled in then the tab key can be
used to complete unit names. See \fIReadline Support\fP for more
information about
.CW "readline" .
.PP
The answer will be displayed in two ways.  The first line of output,
which is marked with a
.CQ "*"
to indicate multiplication, 
gives the result of the conversion you have asked for.  The second line
of output, which is marked with a
.CQ "/"
to indicate division, gives
the inverse of the conversion factor.  If you convert 10 meters to feet,
.CW "units"
will print
.PP
.ES
    * 32.808399
    / 0.03048
.EE
.PP
which tells you that 10 meters equals about 32.8 feet.  
The second number gives the conversion in the opposite direction. 
In this case, it tells you that 1 foot is equal to about  
0.03 dekameters since the dekameter is 10 meters.  
It also tells you that 1/32.8 is about 0.03.    
.PP
The
.CW "units"
program prints the inverse because sometimes it is a
more convenient number.  In the example above, for example, the inverse
value is an exact conversion: a foot is exactly 0.03048 dekameters.  
But the number given the other direction is inexact.  
.PP
If you convert grains to pounds, you will see the following:
.PP
.ES
You have: grains
You want: pounds
        * 0.00014285714
        / 7000
.EE
.PP
>From the second line of the output you can immediately see that a grain
is equal to a seven thousandth of a pound.  This is not so obvious from
the first line of the output. 
If you find  the output format  confusing, try using the
.CQ "--verbose"
option:
.PP
.ES
You have: grain
You want: aeginamina
        grain = 0.00010416667 aeginamina
        grain = (1 / 9600) aeginamina
.EE
.PP
If you request a conversion between units that measure reciprocal
dimensions, then
.CW "units"
will display the conversion results with an extra
note indicating that reciprocal conversion has been done:
.PP
.ES
You have: 6 ohms
You want: siemens
        reciprocal conversion
        * 0.16666667
        / 6
.EE
.PP
Reciprocal conversion can be suppressed by using the
.CQ "--strict"
option.
As usual, use  
the
.CQ "--verbose"
option to get more comprehensible output:
.PP
.ES
You have: tex
You want: typp
        reciprocal conversion
        1 / tex = 496.05465 typp
        1 / tex = (1 / 0.0020159069) typp

You have: 20 mph
You want: sec/mile
        reciprocal conversion
        1 / 20 mph = 180 sec/mile
        1 / 20 mph = (1 / 0.0055555556) sec/mile
.EE
.PP
If you enter incompatible unit types, the
.CW "units"
program will
print a message indicating that the units are not conformable and
it will display the reduced form for each unit:
.PP
.ES
You have: ergs/hour
You want: fathoms kg^2 / day 
conformability error
        2.7777778e-11 kg m^2 / sec^3
        2.1166667e-05 kg^2 m / sec
.EE
.PP
If you only want to find the reduced form or definition of a unit,
simply press \fIReturn\fP at the
.CQ "You want:"
prompt.  Here is an example:
.PP
.ES
You have: jansky
You want: 
        Definition: fluxunit = 1e-26 W/m^2 Hz = 1e-26 kg / s^2
.EE
.PP
The output from
.CW "units"
indicates that the jansky is defined to be
equal to a fluxunit which in turn is defined to be a certain combination
of watts, meters, and hertz.  The fully reduced (and in this case
somewhat more cryptic) form appears on the far right.  
.PP
Some named units are treated as dimensionless in some situations.
These units include the radian and steradian.  These units will be
treated as equal to 1 in units conversions.  Power is equal to torque
times angular velocity.  This conversion can only be performed if the
radian is dimensionless.
.PP
.ES
You have: (14 ft lbf) (12 radians/sec)
You want: watts
        * 227.77742
        / 0.0043902509
.EE
.PP
Note that named dimensionless units are not treated as dimensionless
in other contexts.  They cannot be used as exponents 
so for example,
.CQ "meter^radian"
is not allowed.  
.PP
If you want a list of options you can type
.CI "?"
at the 
.CQ "You want:"
prompt.  The program will display a list of named
units that are conformable with the unit that you entered at
the
.CQ "You have:"
prompt above.  Note that conformable unit
combinations will not appear on this list.  
.PP
Typing
.CI "help"
at either prompt displays a short help message. 
You can also type
.CI "help"
followed by a unit name.  This will
invoke a pager on the units data base at the point where that unit
is defined.  You can read the definition and comments that may
give more details or historical information about the unit. 
.PP
Typing
.CI "search"
\fItext\fP will display a list of all of the units
whose names contain \fItext\fP as a substring along with their definitions.
This may help in the case where you aren't sure of the right unit name.
.PP
.SH USING \f(BIUNITS\fP NON-INTERACTIVELY
The
.CW "units"
program can perform units conversions non-interactively
from the command line.  To do this, type the command, type the original
unit expression, and type the new units you want.  If a units
expression contains non-alphanumeric characters, you may need to protect
it from interpretation by the shell using single or double quote
characters.
.PP
If you type
.PP
.ES
units "2 liters" quarts
.EE
.PP
then
.CW "units"
will print
.PP
.ES
    * 2.1133764
    / 0.47317647
.EE
.PP
and then exit.
The output tells you that 2 liters is about 2.1 quarts, or alternatively that
a quart is about 0.47 times 2 liters.  
.PP
If the conversion is successful, then
.CW "units"
will return success (zero)
to the calling environment.  If you enter  non-conformable
units then
.CW "units"
will print a message giving the reduced form of
each unit and it will return failure (nonzero) to the calling environment. 
.PP
When you invoke
.CW "units"
with only one argument, it will print out
the definition of the specified unit.  It will return failure if the
unit is not defined and success if the unit is defined.
.PP
.SH UNIT DEFINITIONS
The conversion information is read from a units data file that 
is called
.CQ "units.dat"
and is usually located in
the
.CQ "/usr/share"
directory.  
If you invoke
.CW "units"
with the
.CQ "-V"
option, it will print
the location of this file. 
The default
file includes definitions for all familiar units, abbreviations and
metric prefixes.  It also includes many obscure or archaic units.  
.PP
Many constants of nature are defined, including these:
.PP
.ES
pi          \fRratio of circumference to diameter\fP
c           \fRspeed of light\fP
e           \fRcharge on an electron\fP
force       \fRacceleration of gravity\fP
mole        \fRAvogadro's number\fP
water       \fRpressure per unit height of water\fP
Hg          \fRpressure per unit height of mercury\fP
au          \fRastronomical unit\fP
k           \fRBoltzman's constant\fP
mu0         \fRpermeability of vacuum\fP
epsilon0    \fRpermittivity of vacuum\fP
G           \fRGravitational constant\fP
mach        \fRspeed of sound\fP
.EE
.PP
The standard data file includes atomic masses for all of the elements
and numerous other constants.  Also included are the densities of
various ingredients used in baking so that
.CQ "2 cups flour_sifted"
can be converted to
.CQ "grams" .
This is not an exhaustive list.
Consult the units data file to see the complete list, or to see the
definitions that are used.
.PP
The unit
.CQ "pound"
is a unit of mass.  To get force, multiply by the
force conversion unit
.CQ "force"
or use the shorthand
.CQ "lbf" .
(Note that
.CQ "g"
is already taken as the standard abbreviation for
the gram.)  The unit
.CQ "ounce"
is also a unit of mass.  The fluid
ounce is
.CQ "fluidounce"
or
.CQ "floz" .
British capacity units that
differ from their US counterparts, such as the British Imperial gallon,
are prefixed with
.CQ "br" .
Currency is prefixed with its country
name:
.CQ "belgiumfranc" ,
.CQ "britainpound" .
.PP
When searching for a unit, if the specified string does not appear
exactly as a unit name, then the
.CW "units"
program will try to
remove a trailing
.CQ "s" ,
.CQ "es"
or
.CQ "ies" .
If that fails,
.CW "units"
will check for a prefix.  The database includes all 
of the standard metric prefixes.  Only one prefix is permitted per
unit, so
.CQ "micromicrofarad"
will fail.  However, prefixes can
appear alone with no unit following them, so 
.CQ "micro*microfarad"
will work, as will
.CQ "micro microfarad" .
.PP
To find out which units and prefixes are available, read the standard
units data file, which is extensively annotated.  
.PP
.SS English Customary Length Measure
Before 1959, the value of a yard (and other units of measure defined in
terms of it) differed slightly among English-speaking countries.  In
1959, Australia, Canada, New Zealand, the United Kingdom, the United
States, and South Africa adopted the Canadian value of 1\ yard =
0.9144\ m (exactly), which was approximately halfway between the
values used by the UK and the US; it had the additional advantage of
making 1\ inch = 2.54\ cm (exactly).  This new standard was
termed the \fIInternational Yard\fP.  Australia, Canada, and the UK
then defined all customary lengths in terms of the International Yard
(Australia did not define the furlong or rod); because many US land
surveys were in terms of the pre-1959 units, the US continued to define
customary surveyors' units (furlong, chain, rod, and link) in terms of
the previous value for the foot, which was termed the
\fIUS survey foot\fP.  The US defined a \fIUS survey mile\fP as 5280 US
survey feet, and defined a \fIstatute mile\fP as a US survey mile.  The
US values for these units differ from the international values by about
2\ ppm.
.PP
The
.CW "units"
program uses the international values for these
units; the US values can be obtained by using either the
.CQ "US"
or
the
.CQ "survey"
prefix.  In either case, the simple familiar
relationships among the units are maintained, e.g., 1
.CQ "furlong"
=
660
.CQ "ft" ,
and 1
.CQ "USfurlong"
= 660
.CQ "USft" ,
though the
metric equivalents differ slightly between the two cases.
The
.CQ "US"
prefix or the
.CQ "survey"
prefix can also be used to
obtain the US survey mile and the value of the US yard prior to 1959,
e.g.,
.CQ "USmile"
or
.CQ "surveymile"
(but \fInot\fP
.CQ "USsurveymile" ).
To get the US value of the statute mile, use
either
.CQ "USstatutemile"
or
.CQ "USmile" .
.PP
Except for distances that extend over hundreds of miles (such as in the
US State Plane Coordinate System), the differences in the miles are
usually insignificant:
.PP
.ES
You have: 100 surveymile - 100 mile
You want: inch
        * 12.672025
        / 0.078913984
.EE
.PP
The pre-1959 UK values for these units can be obtained with the prefix
.CQ "UK" .
.PP
In the US, the acre is officially defined in terms of the US survey
foot, and here
.CW "units"
uses that definition.  If you want an
acre defined according to the international foot, use
.CQ "intacre" ;
the difference between these units is about 4 parts per million.
.PP
.SH UNIT EXPRESSIONS
.SS Operators
You can enter more complicated units or fractions by combining units
with operations
such as powers, multiplication, division, addition, subtraction, and 
parentheses for grouping.  
You can use the customary symbols for these operators when
.CW "units"
is invoked with its default options.  Additionally,
.CW "units"
supports some extensions, including high 
priority multiplication using a 
space, and a high priority numerical
 division operator
.CQ ( "|" )
that can simplify 
some expressions.
.PP
Powers of units can be specified using the
.CQ "^"
character as shown in
the following example, or by simple concatenation of a unit and its
exponent:
.CQ "cm3"
is equivalent to
.CQ "cm^3" ;
if the exponent is more than one digit, the
.CQ "^"
is required.  
An
exponent like
.CQ "2^3^2"
is evaluated right to left as usual.  
The
.CQ "^"
operator has the second highest precedence.  You can also use
.CQ "**"
as 
an exponent operator. 
.PP
.ES
You have: cm^3
You want: gallons
        * 0.00026417205
        / 3785.4118

You have: arabicfoot * arabictradepound * force
You want: ft lbf  
        * 0.7296
        / 1.370614
.EE
.PP
You multiply units using a space or an asterisk
.CQ ( "*" ).
The example above shows both forms.  You can divide units using the
slash
.CQ ( "/" )
or with
.CQ "per" .
.PP
.ES
You have: furlongs per fortnight
You want: m/s  
        * 0.00016630986
        / 6012.8727
.EE
.PP
When a unit includes a prefix, exponent operators apply to the
combination, so
.CQ "centimeter^3"
gives cubic centimeters.  If you separate
the prefix from the unit with any multiplication operator, such as
.CQ "centi meter^3" ,
then the prefix is treated as a separate unit, so
the exponent does not apply.  The second example would be a hundredth
of a cubic meter, not a centimeter.  
.PP
Multiplication using a space  has a higher precedence
than division using a slash and is evaluated left to right;
in effect, the first
.CQ "/"
character marks the beginning of the
denominator of a unit expression. 
This makes it simple to 
enter a quotient with several terms in the denominator:
.CQ "W / m^2 Hz" .
If you multiply with
.CQ "*"
then you must group the terms in the 
denominator with parentheses:
.CQ "W / (m^2 * Hz)" .
.PP
The higher precedence of the space operator may not always be advantageous.  
For example,
.CQ "m/s s/day"
is equivalent to
.CQ "m / s s day"
and has dimensions of length per time cubed. 
Similarly,
.CQ "1/2 meter"
refers to a unit of reciprocal length
equivalent to 0.5/meter, perhaps not what you would intend if
you entered that expression.
The
.CQ "*"
operator is convenient for multiplying a sequence of quotients.
With the
.CQ "*"
operator, the example above becomes
.CQ "m/s * s/day" ,
which is 
equivalent to
.CQ "m/day" .
Similarly, you could write
.CQ "1/2 * meter"
to get half a meter.
Alternatively, parentheses can be used for grouping: you could write
.CQ "(1/2) meter)"
to get half a meter.
See \fIComplicated Unit Expressions\fP for an illustration of the various
options.
.PP
The
.CW "units"
program supports another option for numerical fractions. 
You can indicate division of \fInumbers\fP with the vertical bar
.CQ ( "|" ),
so if you wanted half a meter you could write
.CQ "1|2 meter" .
This operator has the highest precedence, so you can 
write the square root of two thirds
.CQ "2|3^1|2" .
You cannot use the vertical bar to indicate division of non-numerical
units (e.g.,
.CQ "m|s"
results in an error message).
.PP
.ES
You have: 1|2 inch
You want: cm
        * 1.27
        / 0.78740157
.EE
.PP
You can use parentheses for grouping:
.PP
.ES
You have: (1/2) kg / (kg/meter)
You want: league
        * 0.00010356166
        / 9656.0833
.EE
.PP
.SS Sums and Differences of Units
Outside of the SI, it is sometimes desirable to add values of
different units.  You may also wish to use
.CW "units"
as a
calculator that keeps track of units.  Sums of conformable units are written with
the
.CQ "+"
character, and differences with the
.CQ "-"
character. 
.PP
.ES
You have: 2 hours + 23 minutes + 32 seconds
You want: seconds
        * 8612
        / 0.00011611705
    
You have: 12 ft + 3 in
You want: cm
        * 373.38
        / 0.0026782366

You have: 2 btu + 450 ft lbf
You want: btu
        * 2.5782804
        / 0.38785542
.EE
.PP
The expressions that are added or subtracted must reduce to identical
expressions in primitive units, or an error message will be displayed:
.PP
.ES
You have: 12 printerspoint - 4 heredium
                                      ^
Illegal sum of non-conformable units
.EE
.PP
As usual, the precedence for
.CQ "+"
and
.CQ "-"
is lower than that of 
the other operators.  
A fractional quantity such as 2\ 1/2 cups can be given as
.CQ "(2+1|2) cups" ;
the parentheses are necessary because
multiplication has higher precedence than addition.  If you omit the
parentheses,
.CW "units"
attempts to add
.CQ "2"
and
.CQ "1|2 cups" ,
and you get an error message:
.PP
.ES
You have: 2+1|2 cups
                   ^
Illegal sum or difference of non-conformable units
.EE
.PP
The expression could also be correctly written as
.CQ "(2+1/2) cups" .
Note that if you write
.CQ "2 1|2 cups"
the space is interpreted as \fImultiplication\fP so the result is the same as
.CQ "1 cup" .
.PP
The
.CQ "+"
and
.CQ "-"
characters sometimes appears in exponents like
.CQ "3.43e+8" .
This leads to an ambiguity in an expression like
.CQ "3e+2 yC" .
The unit
.CQ "e"
is a small unit of charge, so this
can be regarded as equivalent to
.CQ "(3e+2) yC"
or
.CQ "(3 e)+(2 yC)" .
This ambiguity is resolved by always interpreting
.CQ "+"
and
.CQ "-"
as part
of an exponent if possible.
.PP
.SS Numbers as Units
For
.CW "units" ,
numbers are just another kind of unit.  They can
appear as many times as you like and in any order in a unit expression.
For example, to find the volume of a box that is 2 ft by 3 ft by 12 ft
in steres, you could do the following:
.PP
.ES
You have: 2 ft 3 ft 12 ft
You want: stere
        * 2.038813
        / 0.49048148
    
You have: $ 5 / yard
You want: cents / inch
        * 13.888889
        / 0.072
.EE
.PP
And the second example shows how the dollar sign in the units conversion
can precede the five.  Be careful:
.CW "units"
will interpret
.CQ "$5"
with no space as equivalent to
.CQ "dollar^5" .
.PP
.SS Built-in Functions
Several built-in functions are provided:
.CQ "sin" ,
.CQ "cos" ,
.CQ "tan" ,
.CQ "ln" ,
.CQ "log" ,
.CQ "log2" ,
.CQ "exp" ,
.CQ "acos" ,
.CQ "atan"
and
.CQ "asin" .
The
.CQ "sin" ,
.CQ "cos" ,
and
.CQ "tan"
functions require either a dimensionless argument or an argument with
dimensions of angle.  
.PP
.ES
You have: sin(30 degrees)
You want: 
        Definition: 0.5

You have: sin(pi/2)
You want:  
        Definition: 1

You have: sin(3 kg)
                  ^
Unit not dimensionless
.EE
.PP
The other functions on the list require dimensionless arguments.  The
inverse trigonometric functions return arguments with dimensions of
angle.
.PP
If you wish to take roots of units, you may use the
.CQ "sqrt"
or
.CQ "cuberoot"
functions.  These functions require that the argument
have the appropriate root.  You can obtain higher roots by using
fractional exponents:
.PP
.ES
You have: sqrt(acre)
You want: feet
        * 208.71074
        / 0.0047913202
    
You have: (400 W/m^2 / stefanboltzmann)^(1/4)
You have:
        Definition: 289.80882 K
    
You have: cuberoot(hectare)
                          ^
Unit not a root
.EE
.PP
.SS Complicated Unit Expressions
The
.CW "units"
program is especially helpful in ensuring accuracy
and dimensional consistency when converting lengthy unit expressions.
.if t .ig ++
For example, one form of the Darcy-Weisbach fluid-flow equation is
.RS 5n
.PP
Delta \fIP\fP = (8 / pi)^2 (rho \fIfLQ\fP^2) / \fId\fP^5,
.RE
.PP
where Delta \fIP\fP is the pressure drop, rho is the mass density,
\fIf\fP is the (dimensionless) friction factor, \fIL\fP is the length
of the pipe, \fIQ\fP is the volumetric flow rate, and \fId\fP
is the pipe diameter.
It might be desired to have the equation in the form
.RS 5n
.PP
Delta \fIP\fP = A1 rho \fIfLQ\fP^2 / \fId\fP^5
.RE
.PP
.++
.if n .ig ++
.EQ
delim $$
.EN
For example, one form of the Darcy\-Weisbach fluid-flow equation is
.RS 5n
.PP
.EQ
DELTA P = 8 over pi sup 2 rho fL Q sup 2 over d sup 5 ,
.EN
.RE
.PP
where $DELTA P$ is the pressure drop, $rho$ is the mass density,
$f$ is the (dimensionless) friction factor, $L$ is the length
of the pipe, $Q$ is the volumetric flow rate, and $d$
is the pipe diameter.
It might be desired to have the equation in the form
.RS 5n
.PP
.EQ
DELTA P = A sub 1 rho fL Q sup 2 over d sup 5
.EN
.RE
.PP
.EQ
delim off
.EN
.++
.PP
that accepted the user's normal units; for typical units used in the US,
the required conversion could be something like
.PP
.ES
You have: (8/pi^2)(lbm/ft^3)ft(ft^3/s)^2(1/in^5)
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
The parentheses allow individual terms in the expression to be entered naturally,
as they might be read from the formula.  Alternatively, the
multiplication could be done with the
.CQ "*"
rather than a space;
then parentheses are needed only around
.CQ "ft^3/s"
because of its
exponent:
.PP
.ES
You have: 8/pi^2 * lbm/ft^3 * ft * (ft^3/s)^2 /in^5
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
Without parentheses, and using spaces for multiplication, the previous
conversion would need to be entered as
.PP
.ES
You have: 8 lb ft ft^3 ft^3 / pi^2 ft^3 s^2 in^5
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
.SS Backwards Compatibility:
.CQ "*"
and
.CQ "-"
The original
.CW "units"
assigned multiplication a higher
precedence than division using the slash.  This differs from the
usual precedence rules, which give multiplication and division equal
precedence, and can be confusing for people who think
of units as a calculator.  
.PP
The star operator
.CQ ( "*" )
included in this
.CW "units"
program
has, by default, the same precedence as division, 
and hence follows the usual precedence rules.  For backwards 
compatibility you can invoke
.CW "units"
with the
.CQ "--oldstar"
option.  Then
.CQ "*"
has a higher precedence than 
division, and the same precedence as multiplication using the space. 
.PP
Historically, the hyphen
.CQ ( "-" )
has been used in technical
publications to indicate products of units, and the original
.CW "units"
program treated it as a multiplication operator.
Because
.CW "units"
provides
several other ways to obtain unit products, and because
.CQ "-"
is a
subtraction operator in general algebraic expressions,
.CW "units"
treats the binary
.CQ "-"
as a subtraction operator by default.  
For backwards compatibility use the
.CQ "--product"
option, which
causes
.CW "units"
to treat the binary
.CQ "-"
operator as a
product operator.  Note that when
.CQ "-"
is a multiplication operator
it has the same precedence as multiplication with a space, giving it a
higher precedence than division.  
.PP
When
.CQ "-"
is used as a unary operator it negates its operand.
Regardless of the
.CW "units"
options, if 
.CQ "-"
appears after
.CQ "("
or after
.CQ "+"
then it will act as a negation operator.  So you can always compute 20
degrees minus 12 minutes by entering
.CQ "20 degrees + -12 arcmin" .
You must use this construction when you define new units because you
cannot know what options will be in force when your definition is
processed. 
.PP
.SH NONLINEAR UNIT CONVERSIONS
Nonlinear units are represented using functional notation.  They make
possible nonlinear unit conversions such as temperature.
.PP
.SS Temperature Conversions
Conversions between temperatures are different from linear conversions
between temperature \fIincrements\fP\(emsee the example below.  The
absolute temperature conversions are handled by units starting with
.CQ "temp" ,
and you must use functional notation.
The temperature-increment conversions are done using units starting
with
.CQ "deg"
and they do not require functional notation.
.PP
.ES
You have: tempF(45)
You want: tempC
        7.2222222

You have: 45 degF
You want: degC
        * 25
        / 0.04
.EE
.PP
Think of
.CQ "tempF(\fIx\fP)"
not as a function but as a notation that
indicates that \fIx\fP should have units of
.CQ "tempF"
attached to
it.  See \fIDefining Nonlinear Units\fP.  The first conversion shows that if it's 45
degrees Fahrenheit outside, it's 7.2 degrees Celsius.  The second
conversion indicates that a change of 45 degrees Fahrenheit corresponds
to a change of 25 degrees Celsius.  The conversion from
.CQ "tempF(\fIx\fP)"
is to absolute temperature, so that
.PP
.ES
You have: tempF(45)
You want: degR
        * 504.67
        / 0.0019814929
.EE
.PP
gives the same result as
.PP
.ES
You have: tempF(45)
You want: tempR
        * 504.67
        / 0.0019814929
.EE
.PP
But if you convert
.CQ "tempF(\fIx\fP)"
to
.CQ "degC" ,
the output is
probably not what you expect:
.PP
.ES
You have: tempF(45)
You want: degC
        * 280.37222
        / 0.0035666871
.EE
.PP
The result is the temperature in K, because
.CQ "degC"
is defined as
.CQ "K" ,
the Kelvin. For consistent results, use the
.CQ "temp\fIX\fP"
units
when converting to a temperature rather than converting a temperature
increment.
.PP
.SS Other Nonlinear Units
Some other examples of nonlinear units are numerous different ring
sizes and wire gauges, the grit sizes used for abrasives, the decibel
scale, shoe size, scales for the density of sugar (e.g. baume).
The standard data file also supplies units for computing the area of a
circle and the volume of a sphere.  See the standard units data file
for more details.
Note that wire gauges
with multiple zeroes are signified using negative numbers where two
zeroes is
.CQ "-1" .
Alternatively, you can use the synonyms
.CQ "g00" ,
.CQ "g000" ,
and so on that are defined in the standard units data file.
.PP
.ES
You have: wiregauge(11)
You want: inches
        * 0.090742002
        / 11.020255

You have: brwiregauge(g00)
You want: inches
        * 0.348
        / 2.8735632

You have: 1 mm
You want: wiregauge
        18.201919

You have: grit_P(600)
You want: grit_ansicoated
        342.76923
.EE
.PP
The last example shows the conversion from P graded sand paper, 
which is the European standard and may be marked ``P600'' on the back, 
to the USA standard.  
.PP
You can compute the area of a circle using the nonlinear unit,
.CQ "circlearea" .
You can also do this using the circularinch or
circleinch.  The next example shows two ways to compute the area of a
circle with a five inch radius and one way to compute the volume of a
sphere with a radius of one meter.  
.PP
.ES
You have: circlearea(5 in)
You want: in2
        * 78.539816
        / 0.012732395

You have: 10^2 circleinch
You want: in2
        * 78.539816
        / 0.012732395

You have: spherevol(meter)
You want: ft3
        * 147.92573
        / 0.0067601492
.EE
.PP
.SH UNIT LISTS: CONVERSION TO SUMS OF UNITS
Outside of the SI, it is sometimes desirable to convert a single
unit to a sum of units\(emfor example, feet to feet plus inches.
The conversion \fIfrom\fP sums of units was described in 
\fISums and Differences of Units\fP and is a simple matter of adding
the units with the
.CQ "+"
sign:
.PP
.ES
You have: 12 ft + 3 in + 3|8 in
You want: ft
        * 12.28125
        / 0.081424936
.EE
.PP
Although you can similarly write a sum of units to convert \fIto\fP,
the result will not be the conversion to the units in the sum, but
rather the conversion to the particular sum that you have entered:
.PP
.ES
You have: 12.28125 ft
You want: ft + in + 1|8 in
        * 11.228571
        / 0.089058524
.EE
.PP
The unit expression given at the
.CQ "You want:"
prompt is equivalent
to asking for conversion to multiples of
.CQ "1 ft + 1 in + 1|8 in" ,
which is 1.09375 ft, so the conversion in the previous example is
equivalent to
.PP
.ES
You have: 12.28125 ft
You want: 1.09375 ft
        * 11.228571
        / 0.089058524
.EE
.PP
In converting to a sum of units like miles, feet and inches, you
typically want the largest integral value for the first unit, followed
by the largest integral value for the next, and the remainder converted
to the last unit.
You can do this conversion easily with
.CW "units"
using a special
syntax for lists of units.  You must list the desired units in order
from largest to smallest, separated by the semicolon
.CQ ( ";" )
character:
.PP
.ES
You have: 12.28125 ft
You want: ft;in;1|8 in
        12 ft + 3 in + 3|8 in
.EE
.PP
The conversion always gives integer coefficients on the units in the
list, except possibly the last unit when the conversion is not exact:
.PP
.ES
You have: 12.28126 ft
You want: ft;in;1|8 in
        12 ft + 3 in + 3.00096 * 1|8 in
.EE
.PP
Note that the order in which you list the units is important:
.PP
.ES
You have: 3 kg
You want: oz;lb
        105 oz + 0.051367866 lb

You have: 3 kg
You want: lb;oz
        6 lb + 9.8218858 oz
.EE
.PP
Listing ounces before pounds produces a technically correct result,
but not a very useful one.  You must list the units in descending
order of size in order to get the most useful result.  
Ending a unit list with the separator
.CQ ";"
adds the previous unit
to the list; with the example above, this gives
.PP
.ES
You have: 12.28126 ft
You want: ft;in;1|8 in;
        12 ft + 3 in + 3|8 in + 0.00096 * 1|8 in
.EE
.PP
in effect separating the integer and fractional parts of the
coefficient for the last unit.  In many cases, you may prefer
to round the last coefficient to an integer; 
you can do this with the
.CQ "--round"
option.  With the
previous example, the result is
.PP
.ES
You have: 12.28126 ft
You want: ft;in;1|8 in;
        12 ft + 3 in + 3|8 in (rounded down to nearest 1|8 in)
.EE
.PP
When the
.CQ "--round"
option is given, adding the previous unit to
the list makes little sense, and is disabled.  In effect, this allows a
rounded value of a single-item ``list'':
.PP
.ES
You have: 12.28126 ft
You want: in;
        147 in (rounded down to nearest in)
.EE
.PP
Each unit that appears on the list must be conformable with the first 
unit on the list, and of course the listed units must also 
be comformable with the \fIYou have\fP unit that you enter.  
.PP
.ES
You have: meter
You want: ft;kg
             ^
conformability error
        ft = 0.3048 m
        kg = 1 kg

You have: meter
You want: lb;oz
conformability error
        1 m
        0.45359237 kg
.EE
.PP
In the first case,
.CW "units"
reports the disagreement between
units appearing on the list.  In the second case,
.CW "units"
reports disagreement between the unit you entered and the desired
conversion.  Note that the conformability error is based on the first
unit on the unit list.
.PP
Other common candidates for conversion to sums of units are
angles and time:
.PP
.ES
You have: 23.437754 deg
You want; deg;arcmin;arcsec
    23 deg + 26 arcmin + 15.9144 arcsec

    You have: 7.2319 hr
    You want: hr;min;sec
        7 hr + 13 min + 54.84 sec
.EE
.PP
In North America, recipes for cooking typically measure ingredients by
volume, and use units that are not always convenient multiples of each
other.  Suppose that you have a recipe for 6 and you wish to make a
portion for 1.  If the recipe calls for 2\ 1/2 cups of an
ingredient, you might wish to know the measurements in terms of
measuring devices you have available, you could use
.CW "units"
and
enter
.PP
.ES
You have: (2+1|2) cup / 6
You want: cup;1|2 cup;1|3 cup;1|4 cup;tbsp;tsp;1|2 tsp;1|4 tsp
        1|3 cup + 1 tbsp + 1 tsp
.EE
.PP
By default, if a unit in a list begins with fraction of the form
1|\fIx\fP and its multiplier is an integer, the fraction is given as
the product of the multiplier and the numerator; for example,
.PP
.ES
You have: 12.28125 ft
You want: ft;in;1|8 in;
        12 ft + 3 in + 3|8 in
.EE
.PP
In many cases, such as the example above, this is what is wanted, but
sometimes it is not.  For example, a cooking recipe for 6 might call
for 5\ 1/4 cup of an ingredient, but you want a portion for 2, and
your 1-cup measure is not available; you might try
.PP
.ES
You have: (5+1|4) cup / 3
You want: 1|2 cup;1|3 cup;1|4 cup
        3|2 cup + 1|4 cup
.EE
.PP
This result might be fine for a baker who has a 1\ 1/2-cup measure
(and recognizes the equivalence), but it may not be as useful to
someone with more limited set of measures, who does want to do
additional calculations, and only wants to know ``How many 1/2-cup
measures to I need to add?''  After all, that's what was actually
asked.  With the
.CQ "--show-factor"
option, the factor will not be
combined with a unity numerator, so that you get
.PP
.ES
You have: (5+1|4) cup / 3
You want: 1|2 cup;1|3 cup;1|4 cup
        3 * 1|2 cup + 1|4 cup
.EE
.PP
A user-specified fractional unit with a numerator other than 1 is never
overridden, however\(emif a unit list specifies
.CQ "3|4 cup;1|2 cup" ,
a result equivalent to 1\ 1/2 cups will always be shown as
.CQ "2 * 3|4 cup"
whether or not the
.CQ "--show-factor"
option is
given.
.PP
Some applications for unit lists may be less obvious.  Suppose that you
have a postal scale and wish to ensure that it's accurate at 1\ oz,
but have only metric calibration weights.  You might try
.PP
.ES
You have: 1 oz
You want: 100 g;50 g; 20 g;10 g;5 g;2 g;1 g;
        20 g + 5 g + 2 g + 1 g + 0.34952312 * 1 g
.EE
.PP
You might then place one each of the 20\ g, 5\ g, 2\ g, and
1\ g weights on the scale and hope that it indicates close to
.PP
.ES
You have: 20 g + 5 g + 2 g + 1 g
You want: oz;
        0.98767093 oz
.EE
.PP
Appending
.CQ ";"
to
.CQ "oz"
forces a one-line display that includes
the unit; here the integer part of the result is zero, so it is not
displayed.
.PP
A unit list such as
.PP
.ES
cup;1|2\ cup;1|3\ cup;1|4\ cup;tbsp;tsp;1|2\ tsp;1|4\ tsp
.EE
.PP
can be tedious to enter.  The
.CW "units"
program provides shorthand names 
for some common combinations:
.PP
.ES
hms         \fRhours, minutes, seconds\fP                
dms         \fRangle: degrees, minutes, seconds\fP       
time        \fRyears, days, hours, minutes and seconds\fP
usvol       \fRUS cooking volume: cups and smaller\fP    
.EE
.PP
Using these shorthands, or \fIunit list aliases\fP, 
you can do the following conversions:
.PP
.ES
You have: anomalisticyear 
You want: time
        1 year + 25 min + 3.4653216 sec
You have: 1|6 cup
You want: usvol
        2 tbsp + 2 tsp
.EE
.PP
You cannot combine a unit list alias with other units: it must appear
alone at the
.CQ "You want:"
prompt.
.PP
You can display the definition of a unit list by pressing \fIReturn\fP at the
.CQ "You have:"
prompt:
.PP
.ES
You have: dms
        Definition: unit list, deg;arcmin;arcsec
.EE
.PP
When you specify compact output with
.CQ "--compact" ,
.CQ "--terse"
or
.CQ "-t"
and perform conversion to a unit list,
.CW "units"
lists the conversion factors for each unit in the
list, separated by semicolons.  Note that unlike the case of regular
output, zeros \fIare\fP included in this output list:
.PP
.ES
You have: year
You want: day;min;sec
        365 day + 348 min + 45.974678 sec
You have: liter
You want: cup;1|2 cup;1|4 cup;tbsp
        4;0;0;3.6280454
.EE
.PP
.SH INVOKING \f(BIUNITS\fP
You invoke
.CW "units"
like this:
.PP
.ES
units [\fIoptions\fP] [\fIfrom-unit\fP [\fIto-unit\fP]]
.EE
.PP
If the \fIfrom-unit\fP and \fIto-unit\fP are omitted, then the program
will use interactive prompts to determine which conversions to perform.
See \fIInteractive Use\fP.
If both \fIfrom-unit\fP and \fIto-unit\fP are given,
.CW "units"
will
print the result of that single conversion and then exit.  
If only \fIfrom-unit\fP appears on the command line,
.CW "units"
will
display the definition of that unit and exit.  
Units specified on the command line may need
to be quoted to protect them from shell interpretation and to group
them into two arguments.  See \fICommand Line Use\fP.
.PP
The following options allow you to read in an alternative units file,
check your units file, or change the output format:
.PP
.TP
.BR "-\^c" ", " "-\^-\^check"
Check that all units and prefixes defined in the units data file reduce
to primitive units.  Print a list of all units that
cannot be reduced.  Also display some other diagnostics about 
suspicious definitions in the units data file.  Only definitions active
in the current locale are checked.  You should always run
.CW "units"
with this option after modifying a units data file.
.PP
.TP
.BR "-\^-\^check-verbose"
Like the
.CQ "--check"
option, this option prints a list of units that
cannot be reduced.  But to help find unit  definitions that cause
endless loops, 
it lists the units as they are checked.  
If
.CW "units"
hangs, then the last unit to be printed has a bad
definition.  Only definitions active in the current locale are checked.
.PP
.TP
.BR "-\^o \fIformat\fP" ", " "-\^-\^output-format \fIformat\fP"
Use the specified \fIformat\fP for numeric output; the format is a
subset of that for the printf function in the ANSI C standard.  Only a
numeric format
.CQ ( "E" ""
or
.CQ "e"
for scientific notation,
.CQ "f"
for fixed-point decimal, or
.CQ "G"
or
.CQ "g"
to specify the number
of significant figures) is allowed.  The default format is
.CQ "%.8g" ;
for greater precision, you could specify
.CQ "-o %.15g" .
See \fINumeric Output Format\fP and the documentation for printf for more
detailed descriptions of the format specification.
.PP
.TP
.BR "-\^e" ", " "-\^-\^exponential"
Set the numeric output format to exponential (i.e., scientific
notation), like that used in the Unix
.CW "units"
program.
.PP
.TP
.BR "-\^f \fIfilename\fP" ", " "-\^-\^file \fIfilename\fP"
Instruct
.CW "units"
to load the units file
.CW "filename" .
You
can specify up to 25 units files on the command line.  When you use
this option,
.CW "units"
will load \fIonly\fP the files you list
on the command line; it will not load the standard file or your
personal units file unless you explicitly list them.  If \fIfilename\fP
is the empty string
.CQ ( "-f """"" ),
the default units file (or that
specified by
.CW "UNITSFILE" )
will be loaded in addition to any others
specified with
.CQ "-f" .
.PP
.TP
.BR "-\^h" ", " "-\^-\^help"
Print out a summary of the options for
.CW "units" .
.PP
.TP
.BR "-\^m" ", " "-\^-\^minus"
Causes
.CQ "-"
to be interpreted as a subtraction operator.  This is
the default behavior.  
.PP
.TP
.BR "-\^p" ", " "-\^-\^product"
Causes
.CQ "-"
to be interpreted as a multiplication operator when it
has two operands.  It will act as a negation operator when it has only one
operand:
.CQ "(-3)" .
Note that by default
.CQ "-"
is treated as a
subtraction operator.
.PP
.TP
.BR "-\^-\^oldstar"
Causes
.CQ "*"
to have the old-style precedence, higher than the
precedence of division so that
.CQ "1/2*3"
will equal
.CQ "1/6" .
.PP
.TP
.BR "-\^-\^newstar"
Forces
.CQ "*"
to have the new (default) precedence that follows
the usual rules of algebra: the precedence of
.CQ "*"
is the same as
the precedence of
.CQ "/" ,
so that
.CQ "1/2*3"
will equal
.CQ "3/2" .
.PP
.TP
.BR "-\^-\^compact"
Give compact output featuring only the conversion factor.  This turns
off the
.CQ "--verbose"
option. 
.PP
.TP
.BR "-\^q" ", " "-\^-\^quiet" ", " "-\^-\^silent"
Suppress prompting of the user for units and the display of statistics
about the number of units loaded.
.PP
.TP
.BR "-\^n" ", " "-\^-\^nolists"
Disable conversion to unit lists.
.PP
.TP
.BR "-\^r" ", " "-\^-\^round"
When converting to a combination of units given by a unit list, round
the value of the last unit in the list to the nearest integer.
.PP
.TP
.BR "-\^S" ", " "-\^-\^show-factor"
When converting to a combination of units specified in a list,
always show a non-unity factor before a unit that
begins with a fraction with a unity denominator.  By default, if the
unit in a list begins with fraction of the form
.CW ` "1|" \fIx\fP'
and
its multiplier is an integer other than 1, the fraction is given as the
product of the multiplier and the numerator (e.g.,
.CQ "3|8 in"
rather
than
.CQ "3 * 1|8 in" ).
In some cases, this is not what is wanted;
for example, the results for a cooking recipe might show
.CQ "3 * 1|2 cup"
as
.CQ "3|2 cup" .
With the
.CQ "--show-factor"
option, a
result equivalent to 1.5 cups will display as
.CQ "3 * 1|2 cup"
rather
than
.CQ "3|2 cup" .
A user-specified fractional unit with a numerator
other than 1 is never overridden, however\(emif a unit list specifies
.CQ "3|4 cup;1|2 cup" ,
a result equivalent to 1\ 1/2 cups will
always be shown as
.CQ "2 * 3|4 cup"
whether or not the
.CQ "--show-factor"
option is given.
.PP
.TP
.BR "-\^s" ", " "-\^-\^strict"
Suppress conversion of units to their reciprocal units.  For 
example,
.CW "units"
will normally convert hertz to seconds
because these units are reciprocals of each other.  The strict option
requires that units be strictly conformable to perform a conversion, and
will give an error if you attempt to convert hertz to seconds. 
.PP
.TP
.BR "-\^1" ", " "-\^-\^one-line"
Give only one line of output (the forward conversion).  Do not print
the reverse conversion.  Note that if a reciprocal conversion is
performed then
.CW "units"
will still print the ``reciprocal
conversion'' line.
.PP
.TP
.BR "-\^t" ", " "-\^-\^terse"
Give terse output when converting units.  This option can be used when
calling
.CW "units"
from another program so that the output is easy to
parse.  This option has the combined
effect of these options:
.CQ "--strict"
.CQ "--quiet"
.CQ "--one-line"
.CQ "--compact" .
.PP
.TP
.BR "-\^v" ", " "-\^-\^verbose"
Give slightly more verbose output when converting units.  When combined
with the
.CQ "-c"
option this gives the same effect as
.CQ "--check-verbose" .
.PP
.TP
.BR "-\^V" ", " "-\^-\^version"
Print program version number, tell whether the
.CW "readline"
library has been included, and give the location of the default units
data file.
.PP
.SH ADDING YOUR OWN DEFINITIONS
.SS Units Data Files
The units and prefixes that
.CW "units"
can convert are
defined in the units data file, typically
.CQ "/usr/share/units.dat" .
Although you can extend or modify this
data file if you have appropriate user privileges, it's usually better
to put extensions in separate files so that the definitions will be
preserved if the
.CW "units"
program is updated.
.PP
Additional data files can be included in the units database by use of
the
.CQ "!include"
command in the standard units data file, for
example
.PP
.ES
!include    /usr/local/share/localunits.dat
.EE
.PP
might be appropriate for a site-wide supplemental data file.
The location of the
.CQ "!include"
statement in the standard units
data file is important; later definitions replace earlier ones,
so any definitions in an included file will override definitions before
the
.CQ "!include"
statement in the standard units data file.
With normal invocation, no warning is given about redefinitions; to
ensure that you don't have an unintended redefinition, run
.CQ "units\ -c"
after making changes to any units data file.
.PP
If you want to add your own units in addition to or in place of
standard or site-wide supplemental units data files, you can include
them in the
.CQ ".units.dat"
file in your home directory.  If this
file exists it is read after the standard units data file, so that any
definitions in this file will replace definitions of the same units in
the standard data file or in files included from the standard data
file.  This file will not be read if any units files are specified on
the command line.
.PP
The
.CW "units"
program first tries to determine your home
directory from the
.CW "HOME"
environment variable.  On systems running
Microsoft Windows, if
.CW "HOME"
does not exist,
.CW "units"
attempts to find your home directory from
.CW "HOMEDRIVE"
and
.CW "HOMEPATH" .
.PP
You can specify an arbitrary file as your personal units data file with
the
.CW "MYUNITSFILE"
environment variable; if this variable exists, its
value is used without searching your home directory.
.PP
.SS Defining New Units and Prefixes
A unit is specified on a single line by giving its name and an
equivalence.  Comments start with a
.CQ "#"
character, which can appear
anywhere in a line.  The backslash character
.CQ ( "\e" )
acts as a continuation
character if it appears as the last character on a line, making it
possible to spread definitions out over several lines if desired.
A file can be included by giving the command
.CQ "!include"
followed by
the file's name.  The
.CQ "!"
must be the first character on the
line.  The file will be sought in the same directory as the
parent file unless you give a full path.  The name of the file to be
included cannot contain the comment character
.CQ "#" .
.PP
Unit names must not contain any of the operator characters
.CQ "+" ,
.CQ "-" ,
.CQ "*" ,
.CQ "/" ,
.CQ "|" ,
.CQ "^" ,
.CQ ";" ,
the comment
character
.CQ "#" ,
or parentheses.  They cannot begin with a digit,
or a decimal point
.CQ ( "." ),
and cannot begin or end with an
underscore
.CQ ( "_" ).
If a name ends in a digit other than zero, the
digit must be preceded by a string beginning with an underscore, and
afterwards consisting only of digits, decimal points, or commas.  For
example,
.CQ "foo_2" ,
.CQ "foo_2,1" ,
or
.CQ "foo_3.14"
would be
valid names but
.CQ "foo2"
or
.CQ "foo_a2"
would be invalid.  You
could define nitrous oxide as
.PP
.ES
N2O     nitrogen 2  + oxygen
.EE
.PP
but would need to define nitrogen dioxide as
.PP
.ES
NO_2    nitrogen + oxygen 2
.EE
.PP
Be careful to define new units in terms of old ones so that a
reduction leads to the primitive units, which are marked with
.CQ "!"
characters.  Dimensionless units are indicated by using the string
.CQ "!dimensionless"
for the unit definition.
.PP
When adding new units, be sure to use the
.CQ "-c"
option to check that
the new units reduce properly.  
If you create a loop in the units definitions, then
.CW "units"
will
hang when invoked with the
.CQ "-c"
option.  You will need to 
use the
.CQ "--check-verbose"
option, which prints out each unit as it
is checked.  The program will still hang, but the last unit printed
will be the unit that caused the infinite loop.
.PP
If you define any units that contain
.CQ "+"
characters, carefully check them because the
.CQ "-c"
option
will not catch non-conformable sums.  Be careful with the
.CQ "-"
operator as well.  When used as a binary operator, the
.CQ "-"
character can perform addition or multiplication
depending on the options used to invoke
.CW "units" .
To ensure consistent behavior use
.CQ "-"
only as a unary negation
operator when writing units definitions.  To multiply two units leave a
space or use the
.CQ "*"
operator with care, recalling that it has
two possible precedence values and may require parentheses to ensure
consistent behavior.  To compute the difference 
of
.CQ "foo"
and
.CQ "bar"
write
.CQ "foo+(-bar)"
or even
.CQ "foo+-bar" .
.PP
Here is an example of a short data file that defines some basic
units:
.PP
.ES
m       !               # The meter is a primitive unit
sec     !               # The second is a primitive unit
rad     !dimensionless  # A dimensionless primitive unit
micro-  1e-6            # Define a prefix
minute  60 sec          # A minute is 60 seconds
hour    60 min          # An hour is 60 minutes
inch    0.0254 m        # Inch defined in terms of meters
ft      12 inches       # The foot defined in terms of inches
mile    5280 ft         # And the mile
.EE
.PP
A unit that ends with a
.CQ "-"
character is a prefix.  If a prefix
definition contains any
.CQ "/"
characters, be sure they are protected
by parentheses.  If you define
.CQ "half- 1/2"
then
.CQ "halfmeter"
would be equivalent to
.CQ "1 / (2 meter)" .
.PP
.SS Defining Nonlinear Units
Some unit conversions of interest are nonlinear; for
example, temperature conversions between the Fahrenheit and Celsius
scales cannot be done by simply multiplying by conversion factors.  
.PP
When you give a linear unit definition such as
.CQ "inch 2.54 cm"
you
are providing information that
.CW "units"
uses to convert values in
inches into primitive units of meters.  For nonlinear units, you give
a functional definition that provides the same information.  
.PP
Nonlinear units are represented using a functional notation.  
It is best to regard this notation not as a function call but 
as a way of adding units to a number, much the same way that
writing a linear unit name after a number adds units to that number.
Internally, nonlinear units are defined by a pair of functions
that convert to and from linear units in the data file, so that 
an eventual conversion to primitive units is possible.  
.PP
Here is an example nonlinear unit definition:
.PP
.ES
tempF(x) [1;K] (x+(-32)) degF + stdtemp ; (tempF+(-stdtemp))/degF + 32
.EE
.PP
A nonlinear unit definition comprises a unit name, a dummy parameter
name, two functions, and two corresponding units.  The functions tell
.CW "units"
how to convert to and from the new unit.  In order to 
produce valid results, the arguments of these functions need to have
the correct dimensions.  To facilitate error checking, you may specify
the dimensions. 
.PP
The definition begins with the unit name followed immediately (with no
spaces) by a
.CQ "("
character.  In parentheses is the name of the
parameter.  Next is an optional specification of the units required by
the functions in this definition.  In the example above, the
.CQ "tempF"
function requires an input argument conformable with
.CQ "1" .
For normal nonlinear units definitions the forward 
function will always take a dimensionless argument.  
The inverse function requires an input argument conformable
with
.CQ "K" .
In general the inverse function will need units
that match the quantity measured by your nonlinear unit. 
The sole purpose of the expression in brackets to enable
.CW "units"
to perform error checking on function arguments.
.PP
Next the function definitions appear.  In the example above, the
.CQ "tempF"
function is defined by
.PP
.ES
tempF(x) = (x+(-32)) degF + stdtemp
.EE
.PP
This gives a rule for converting
.CQ "x"
in the units
.CQ "tempF"
to linear units of absolute temperature, which makes it possible to 
convert from tempF to other units. 
.PP
In order to make conversions to Fahrenheit possible, you must give
a rule for the inverse conversions. The inverse will be
.CQ "x(tempF)"
and its definition appears after a
.CQ ";"
character.  
In our example, the inverse is
.PP
.ES
x(tempF) = (tempF+(-stdtemp))/degF + 32
.EE
.PP
This inverse definition takes an absolute temperature as its argument
and converts it to the Fahrenheit temperature.  The inverse can be
omitted by leaving out the
.CQ ";"
character, but then conversions to
the unit will be impossible.  If the inverse is omitted then the
.CQ "--check"
option will display a warning.  It is up to you to
calculate and enter the correct inverse function to obtain proper
conversions.  The
.CQ "--check"
option tests the inverse at one point
and print an error if it is not valid there, but this is not a guarantee
that your inverse is correct.
.PP
If you wish to make synonyms for nonlinear units, you still need to define
both the forward and inverse functions.  Inverse functions can be
obtained using the
.CQ "~"
operator.  So to create a synonym 
for
.CQ "tempF"
you could write
.PP
.ES
fahrenheit(x) [1;K] tempF(x); ~tempF(fahrenheit)
.EE
.PP
You may occasionally wish to define a function that operates on units.  
This can be done
using a nonlinear unit definition.  For example, the definition below
provides conversion between radius and the area of a circle.  Note
that this definition requires a length as input and produces an
area as output, as indicated by the specification in brackets. 
.PP
.ES
circlearea(r) [m;m^2] pi r^2 ; sqrt(circlearea/pi)
.EE
.PP
Sometimes you may be interested in a piecewise linear unit such as 
many wire gauges.  Piecewise linear units can be defined by specifying
conversions to linear units on a list of points.
Conversion at other points will be done by linear interpolation.
A partial definition of zinc gauge is
.PP
.ES
zincgauge[in] 1 0.002, 10 0.02, 15 0.04, 19 0.06, 23 0.1
.EE
.PP
In this example,
.CQ "zincgauge"
is the name of the piecewise linear
unit.  The definition of such a unit is indicated by the
embedded
.CQ "["
character.  After the bracket, you should indicate the
units to be attached to the numbers in the table.  
No spaces can appear before the
.CQ "]"
character, so a definition like
.CQ "foo[kg meters]"
is
illegal; instead write
.CQ "foo[kg*meters]" .
The definition of the
unit consists of a list of pairs optionally separated by commas.  
This list defines a function for converting from the piecewise linear
unit to linear units.  The
first item in each pair is the function argument; the second item is the
value of the function at that argument (in the units specified in brackets).
In this example,
we define
.CQ "zincgauge"
at five points.  For example, we set
.CQ "zincgauge(1)"
equal to
.CQ "0.002 in" .
Definitions like this
may be  more readable  if written using  continuation characters as
.PP
.ES
zincgauge[in] \e
     1 0.002  \e
    10 0.02   \e
    15 0.04   \e
    19 0.06   \e
    23 0.1
.EE
.PP
With the preceding definition, the following conversion can be
performed:
.PP
.ES
You have: zincgauge(10)
You want: in
    * 0.02
    / 50
You have: .01 inch
You want: zincgauge
    5
.EE
.PP
If you define a piecewise linear unit that is not strictly
monotonic, then the inverse will not be well defined.  If the inverse is
requested for such a unit,
.CW "units"
will return the smallest
inverse.  The
.CQ "--check"
option will print a warning if a
non-monotonic piecewise linear unit is encountered.  
.PP
.SS Defining Unit List Aliases
Unit list aliases are treated differently from unit definitions,
because they are a data entry shorthand rather than a true definition
for a new unit. 
A unit list alias definition begins with
.CQ "!unitlist"
and includes the
alias and the definition;  for example, the aliases included in the
standard units data file are
.PP
.ES
!unitlist   hms     hr;min;sec
!unitlist   time    year;day;hr;min;sec
!unitlist   dms     deg;arcmin;arcsec
!unitlist   ftin    ft;in;1|8 in
!unitlist   usvol   cup;3|4 cup;2|3 cup;1|2 cup;1|3 cup;1|4 cup;\e
                    tbsp;tsp;1|2 tsp;1|4 tsp;1|8 tsp
.EE
.PP
Unit list aliases are only for unit lists, so the definition must
include a
.CQ ";" .
Unit list aliases can never be combined with
units or other unit list aliases, so the definition of
.CQ "time"
shown above could \fInot\fP have been shortened to
.CQ "year;day;hms" .
As usual, be sure to run
.CW "units --check"
to ensure that the units listed in unit list aliases are conformable.
.PP
.SH NUMERIC OUTPUT FORMAT
By default, results of conversions are shown to eight significant
figures; this can be changed with the
.CQ "--exponential"
and
.CQ "--output-format"
options.  The former sets an exponential
format (i.e., scientifc notation) like that used in the original Unix
.CW "units"
program; the latter allows the format to be given as
that of the printf function in the ANSI\ C standard.
.PP
The format recognized with the
.CQ "--output-format"
option is a
subset of that for printf.  Only a floating-point format of the form
.CW "%" [\fIflag\fP][\fIwidth\fP][\c
.CW "." \fIprecision\fP]\fItype\fP
is allowed: it must begin with
.CQ "%" ,
and must end with a
floating-point type specifier
.CQ ( "E" ""
or
.CQ "e"
for scientific
notation,
.CQ "f"
for fixed-point decimal, or
.CQ "G"
or
.CQ "g"
to
specify the number of significant figures).  The format specification
may include one optional flag
.CQ ( "+" ,
.CQ "-" ,
.CQ "#" ,
or a
space), followed by an optional value for the minimum field width, and
an optional precision specification that begins with a period (e.g.,
.CQ ".6" ).
In addition to the digits, the field width includes the
decimal point, the exponent, and the sign if any of these are shown.  A
width specification is typically used with fixed-point decimal to have
columns of numbers align at the decimal point; it normally is not
useful with
.CW "units" .
Non-floating-point type specifiers make
no sense for
.CW "units" ,
and are forbidden.
.PP
The default format is
.CQ "%.8g" ;
for greater precision, you could
specify
.CQ "-o %.15g" .
The
.CQ "G"
and
.CQ "g"
formats use
exponential format whenever the exponent would be less than \-5,
so the value 0.000013 displays as
.CQ "1.3e-005" .
If you prefer
fixed-point display, you might specify
.CQ "-o %.8f" ;
however, very
small numbers may display very few significant figures, and for very
small numbers, may show nothing but zeros.
.PP
See the documentation for printf for more detailed descriptions of the
format specification.
.PP
.SH LOCALIZATION
Some units have different values in different locations.  The
localization feature accommodates this by allowing a units data file to
specify region dependent definitions.   A locale region in a units
data file begins with
.CQ "!locale"
followed by the name of the locale.
The leading
.CQ "!"
must appear in the first column of a units
data file.  The locale region is terminated by
.CQ "!endlocale" .
The
following example shows how to define a couple units in a locale.
.PP
.ES
!locale en_GB
ton                     brton
gallon                  brgallon
!endlocale
.EE
.PP
The current locale is specified using the standard environment
variables
.CW "LC_CTYPE"
or
.CW "LANG" .
Note that the
.CQ "-c"
option only checks the definitions that are active for the current locale.
.PP
.SH ENVIRONMENT VARIABLES
The
.CW "units"
program uses the following environment variables:
.PP
.TP
.BR "HOME"
Specifies the location of your home directory; it is used by
.CW "units"
to find a personal units data file
.CQ ".units.dat" .
On systems running Microsoft Windows,
.CW "units"
tries to
determine your home directory from the
.CW "HOMEDRIVE"
and
.CW "HOMEPATH"
environment variables if
.CW "HOME"
does not exist.
.PP
.TP
.BR "LANG"
Specifies the locale.  The default is
.CQ "en_US" .
Sections of the
standard units data file are specific to certain locales.
.PP
.TP
.BR "MYUNITSFILE"
Specifies your personal units data file.  If this variable exists,
.CW "units"
uses its value rather than searching your home
directory for
.CQ ".units.dat" .
The personal units file will not be
loaded if any data files are given using the
.CQ "-f"
option.
.PP
.TP
.BR "PAGER"
Specifies the pager to use for help and for displaying the conformable
units.  The help function browses the units database and calls
the pager using the
.CQ "+n" \fIn\fP
syntax for specifying a line
number.  The default pager is
.CW "more" ;
.CW "PAGER"
can be used
to specify alternatives such as
.CW "less" ,
.CW "pg" ,
.CW "emacs" ,
or
.CW "vi" .
.PP
.TP
.BR "UNITSFILE"
Specifies the units data file to use (instead of the default).  Note
that you can only specify a single units data file using this
environment variable.  If units data files are given using the
.CQ "-f"
option, the file specified by
.CW "UNITSFILE"
will be not be loaded
unless the
.CQ "-f"
option is given with the empty string
.CQ ( "units\ -f\ """"" ).
.PP
.SH UNICODE SUPPORT
The standard units data file is written in Unicode using the UTF-8 encoding.
Portions of the file that are not plain ASCII begin with
.CQ "!utf8"
and end with
.CQ "!endutf8" .
As usual, the
.CQ "!"
must
appear as the first character on the line.  If a line of a data file
contains byte sequences that are invalid UTF-8 or non-printing UTF-8
then
.CW "units"
ignores the entire line.
.PP
When
.CW "units"
runs it checks the locale to determine the
character set.  If UTF-8 is listed, then the utf8 definitions are read
into the program.  If any other character set is in use, then
.CW "units"
works in plain ASCII without support for extended
characters. 
.PP
.SH READLINE SUPPORT
If the
.CW "readline"
package has been compiled in, then when
.CW "units"
is used interactively, numerous command line editing
features are available.  To check if your version of
.CW "units"
includes
.CW "readline" ,
invoke the program with the
.CQ "--version"
option.
.PP
For complete information about
.CW "readline" ,
consult the
documentation for the
.CW "readline"
package.  Without any
configuration,
.CW "units"
will allow editing in the style of
emacs.  Of particular use with
.CW "units"
are the completion
commands.
.PP
If you type a few characters and then hit \fIESC\fP followed by
.CI "?"
then
.CW "units"
will display a list of all the units that
start with the characters typed.  For example, if you type
.CI "metr"
and
then request completion, you will see something like this:
.PP
.ES
You have: metr
metre             metriccup         metrichorsepower  metrictenth
metretes          metricfifth       metricounce       metricton
metriccarat       metricgrain       metricquart       metricyarncount
You have: metr
.EE
.PP
If there is a unique way to complete a unitname, you can hit the \fITAB\fP key
and
.CW "units"
will provide the rest of the unit name.  If
.CW "units"
beeps, it means that there is no unique completion.  Pressing the \fITAB\fP
key a second time will print the list of all completions.  
.PP
.SH FILES
@DATAFILE@ \(em the standard units data file
.SH AUTHOR
Adrian Mariano (adrianm@gnu.org)
