/* tag: ticket renewal functions (source)
 *
 * Copyright (C) 2000  Andrew Chatham
 * Copyright (C) 2003  Charles Duffy
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <config.h>
#include <glib.h>
#include <string.h>

#include "krb-util.h"
#include "renew.h"

static void
run_cmds(TicketApplet *ad)
{
  GList *cur;
  gchar *cmd;
  gint ret;
  
  for (cur = ad->cmds; cur != NULL; cur = g_list_next(cur)) {
    cmd = cur->data;
    ret = system(cmd);
  }
}

static void
activate_cb(GtkObject *obj, gpointer data)
{
  TicketApplet *ad = data;
  gchar *password;
  gchar *princ;
  gchar *user;
  krb_error error;
  char error_msg[256];

  password = gtk_editable_get_chars(GTK_EDITABLE(ad->pass_entry),
				    0, 100);

  if(ad->user != NULL && strlen(ad->user) > 0)
    user = ad->user;
  else
    user = getenv("USER");
  
  if (ad->realm != NULL && strlen(ad->realm) > 0)
    princ = g_strjoin("@", user, ad->realm, NULL);
  else
    princ = g_strdup(user);

  error = krb_get_tickets(princ, password);
  g_free(princ);

  if (error.code) {
    snprintf(error_msg, 255, _("Error renewing tickets: %s"), 
	     error.message);
    gnome_warning_dialog(error_msg);
  }

#ifdef DO_KRBAFS
  if (get_afs_tokens()) {
    puts("An error");
  }
#endif

  run_cmds(ad);
  refresh(ad);
}

void
renew(TicketApplet *ad)
{
  GtkWidget *pass_box;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *pass_entry;

  pass_box = gnome_dialog_new( _("Ticket Renewal"),
			       GNOME_STOCK_BUTTON_OK,
			       GNOME_STOCK_BUTTON_CANCEL,
			       NULL);

  pass_entry = gtk_entry_new();
  ad->pass_entry = pass_entry;
  gtk_entry_set_visibility(GTK_ENTRY(pass_entry), FALSE);

  label = gtk_label_new("Password: ");

  hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(hbox), label, 0, 0, 5);
  gtk_box_pack_start(GTK_BOX(hbox), pass_entry, 0, 0, 5);

  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(pass_box)->vbox), 
		     hbox, TRUE, TRUE, 0);


  gtk_signal_connect(GTK_OBJECT(pass_entry), "activate", 
		     GTK_SIGNAL_FUNC(activate_cb), ad);

  /* So cancel button and pressing enter will close the dialog */
  gnome_dialog_set_close(GNOME_DIALOG(pass_box), TRUE);
  gnome_dialog_editable_enters(GNOME_DIALOG(pass_box), 
			       GTK_EDITABLE(pass_entry));
  
  /* OK button */
  gnome_dialog_button_connect(GNOME_DIALOG(pass_box), 0, 
			      GTK_SIGNAL_FUNC(activate_cb), ad);


  gtk_widget_grab_focus(pass_entry);
  gtk_widget_show_all(GTK_WIDGET(pass_box));
}
