/*
  File autogenerated by gengetopt version 2.12.2
  generated with the following command:
  gengetopt --no-handle-help --no-handle-error --input shishid.ggo --file-name shishid_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shishid_cmd.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->listen_given = 0 ;
  args_info->setuid_given = 0 ;
  args_info->x509cafile_given = 0 ;
  args_info->x509certfile_given = 0 ;
  args_info->x509crlfile_given = 0 ;
  args_info->x509keyfile_given = 0 ;
  args_info->resume_limit_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->listen_arg = NULL;
  args_info->setuid_arg = NULL;
  args_info->x509cafile_arg = NULL;
  args_info->x509certfile_arg = NULL;
  args_info->x509crlfile_arg = NULL;
  args_info->x509keyfile_arg = NULL;
  args_info->resume_limit_arg = 50 ;
  args_info->configuration_file_arg = NULL;
  args_info->quiet_flag = 0;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
"  Shishi Key Distribution Center server.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                    Print help and exit");
  printf("%s\n","  -V, --version                 Print version and exit");
  printf("%s\n","\nCommands:");
  printf("%s\n","  -l, --listen=[FAMILY:]ADDR:PORT/TYPE\n                                Sockets to listen for queries on.  Family is \n                                  `IPv4' or `IPv6', if absent the family is \n                                  decided by gethostbyname(ADDR). An address of \n                                  `*' indicates all addresses on the local \n                                  host. The default is `IPv4:*:kerberos/udp, \n                                  IPv4:*:kerberos/tcp, IPv6:*:kerberos/udp, \n                                  IPv6:*:kerberos/tcp'.");
  printf("%s\n","  -u, --setuid=NAME             After binding socket, set user identity.");
  printf("%s\n","\nTLS settings:");
  printf("%s\n","      --x509cafile=FILE         X.509 certificate authorities used to verify \n                                  client certificates, in PEM format.");
  printf("%s\n","      --x509certfile=FILE       X.509 server certificate, in PEM format.");
  printf("%s\n","      --x509crlfile=FILE        X.509 certificate revocation list to check for \n                                  revoked client certificates, in PEM format.");
  printf("%s\n","      --x509keyfile=FILE        X.509 server certificate key, in PEM format.");
  printf("%s\n","      --resume-limit=SHORT      Keep track of up to this many TLS sessions for \n                                  resume purposes (0 to disable TLS resume).  \n                                  (default=`50')");
  printf("%s\n","\nOther options:");
  printf("%s\n","  -c, --configuration-file=FILE Use specified configuration file.");
  printf("%s\n","  -v, --verbose                 Produce verbose output.\n                                  Use multiple times to increase amount of \n                                  information.");
  printf("%s\n","  -q, --quiet                   Don't produce any diagnostic output.\n                                    (default=off)");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  if (args_info->listen_arg)
    {
      free (args_info->listen_arg); /* free previous argument */
      args_info->listen_arg = 0;
    }
  if (args_info->setuid_arg)
    {
      free (args_info->setuid_arg); /* free previous argument */
      args_info->setuid_arg = 0;
    }
  if (args_info->x509cafile_arg)
    {
      free (args_info->x509cafile_arg); /* free previous argument */
      args_info->x509cafile_arg = 0;
    }
  if (args_info->x509certfile_arg)
    {
      free (args_info->x509certfile_arg); /* free previous argument */
      args_info->x509certfile_arg = 0;
    }
  if (args_info->x509crlfile_arg)
    {
      free (args_info->x509crlfile_arg); /* free previous argument */
      args_info->x509crlfile_arg = 0;
    }
  if (args_info->x509keyfile_arg)
    {
      free (args_info->x509keyfile_arg); /* free previous argument */
      args_info->x509keyfile_arg = 0;
    }
  if (args_info->configuration_file_arg)
    {
      free (args_info->configuration_file_arg); /* free previous argument */
      args_info->configuration_file_arg = 0;
    }
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  char *tok, *ret;
  int len;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (tok)
    len = (tok - arg + 1);
  else
    len = strlen (arg) + 1;

  ret = (char *) malloc (len);
  strncpy (ret, arg, len-1);
  ret[len-1] = '\0';

  return ret;
}

static char *
get_multiple_arg_token_next(const char *arg)
{
  char *tok;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  char *multi_token, *multi_next; /* for multiple options */

  int i;        /* Counter */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "listen",	1, NULL, 'l' },
        { "setuid",	1, NULL, 'u' },
        { "x509cafile",	1, NULL, 0 },
        { "x509certfile",	1, NULL, 0 },
        { "x509crlfile",	1, NULL, 0 },
        { "x509keyfile",	1, NULL, 0 },
        { "resume-limit",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 'c' },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVl:u:c:vq", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'l':	/* Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDR). An address of `*' indicates all addresses on the local host. The default is `IPv4:*:kerberos/udp, IPv4:*:kerberos/tcp, IPv6:*:kerberos/udp, IPv6:*:kerberos/tcp'..  */
          if (local_args_info.listen_given)
            {
              fprintf (stderr, "%s: `--listen' (`-l') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->listen_given && ! override)
            continue;
          local_args_info.listen_given = 1;
          args_info->listen_given = 1;
          if (args_info->listen_arg)
            free (args_info->listen_arg); /* free previous string */
          args_info->listen_arg = gengetopt_strdup (optarg);
          break;

        case 'u':	/* After binding socket, set user identity..  */
          if (local_args_info.setuid_given)
            {
              fprintf (stderr, "%s: `--setuid' (`-u') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->setuid_given && ! override)
            continue;
          local_args_info.setuid_given = 1;
          args_info->setuid_given = 1;
          if (args_info->setuid_arg)
            free (args_info->setuid_arg); /* free previous string */
          args_info->setuid_arg = gengetopt_strdup (optarg);
          break;

        case 'c':	/* Use specified configuration file..  */
          if (local_args_info.configuration_file_given)
            {
              fprintf (stderr, "%s: `--configuration-file' (`-c') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->configuration_file_given && ! override)
            continue;
          local_args_info.configuration_file_given = 1;
          args_info->configuration_file_given = 1;
          if (args_info->configuration_file_arg)
            free (args_info->configuration_file_arg); /* free previous string */
          args_info->configuration_file_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Produce verbose output.\nUse multiple times to increase amount of information..  */
          local_args_info.verbose_given++;
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (local_args_info.quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->quiet_given && ! override)
            continue;
          local_args_info.quiet_given = 1;
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;


        case 0:	/* Long option with no short option */
          /* X.509 certificate authorities used to verify client certificates, in PEM format..  */
          if (strcmp (long_options[option_index].name, "x509cafile") == 0)
          {
            if (local_args_info.x509cafile_given)
              {
                fprintf (stderr, "%s: `--x509cafile' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->x509cafile_given && ! override)
              continue;
            local_args_info.x509cafile_given = 1;
            args_info->x509cafile_given = 1;
            if (args_info->x509cafile_arg)
              free (args_info->x509cafile_arg); /* free previous string */
            args_info->x509cafile_arg = gengetopt_strdup (optarg);
          }
          
          /* X.509 server certificate, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509certfile") == 0)
          {
            if (local_args_info.x509certfile_given)
              {
                fprintf (stderr, "%s: `--x509certfile' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->x509certfile_given && ! override)
              continue;
            local_args_info.x509certfile_given = 1;
            args_info->x509certfile_given = 1;
            if (args_info->x509certfile_arg)
              free (args_info->x509certfile_arg); /* free previous string */
            args_info->x509certfile_arg = gengetopt_strdup (optarg);
          }
          
          /* X.509 certificate revocation list to check for revoked client certificates, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509crlfile") == 0)
          {
            if (local_args_info.x509crlfile_given)
              {
                fprintf (stderr, "%s: `--x509crlfile' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->x509crlfile_given && ! override)
              continue;
            local_args_info.x509crlfile_given = 1;
            args_info->x509crlfile_given = 1;
            if (args_info->x509crlfile_arg)
              free (args_info->x509crlfile_arg); /* free previous string */
            args_info->x509crlfile_arg = gengetopt_strdup (optarg);
          }
          
          /* X.509 server certificate key, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509keyfile") == 0)
          {
            if (local_args_info.x509keyfile_given)
              {
                fprintf (stderr, "%s: `--x509keyfile' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->x509keyfile_given && ! override)
              continue;
            local_args_info.x509keyfile_given = 1;
            args_info->x509keyfile_given = 1;
            if (args_info->x509keyfile_arg)
              free (args_info->x509keyfile_arg); /* free previous string */
            args_info->x509keyfile_arg = gengetopt_strdup (optarg);
          }
          
          /* Keep track of up to this many TLS sessions for resume purposes (0 to disable TLS resume)..  */
          else if (strcmp (long_options[option_index].name, "resume-limit") == 0)
          {
            if (local_args_info.resume_limit_given)
              {
                fprintf (stderr, "%s: `--resume-limit' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->resume_limit_given && ! override)
              continue;
            local_args_info.resume_limit_given = 1;
            args_info->resume_limit_given = 1;
            args_info->resume_limit_arg = (short)strtol (optarg,&stop_char,0);
          }
          

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  args_info->verbose_given += local_args_info.verbose_given;
  
  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  return (EXIT_FAILURE);
}
