.TH GROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff \- front-end for the groff document formatting system
.
.\" groff.man -> groff.1
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr groff_1_c \n[.C]
.cp 0
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2014 Free Software Foundation, Inc.
.\"
.\" This document is part of groff, a free GNU software project.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with the Invariant Sections being the macro definition
.\" or .co and .au, with no Front-Cover Texts, and with no Back-Cover
.\" Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.\"
.\" It is also available in the internet at the
.\" <http://www.gnu.org/copyleft/fdl.html>.
.
.
.\" ====================================================================
.\" Definitions
.\" ====================================================================
.
.\" ====================================================================
.\" Environment variable
.de EnvVar
.  SM
.  BR \%\\$1 \\$2
..
.\" ====================================================================
.\" 'char or string'
.de Quoted
.  ft CR
\[oq]\\$*\[cq]
.  ft
..
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY groff
.OP \-abcegijklpstzCEGNRSUVXZ
.OP \-d cs
.OP \-D arg
.OP \-f fam
.OP \-F dir
.OP \-I dir
.OP \-K arg
.OP \-L arg
.OP \-m name
.OP \-M dir
.OP \-n num
.OP \-o list
.OP \-P arg
.OP \-r cn
.OP \-T dev
.OP \-w name
.OP \-W name
.RI [ file\~ .\|.\|.]
.
.SY groff
.B \-h
|
.B \-\-help
.
.SY groff
.B \-v
|
.B \-\-version
.RI [ option\~ .\|.\|.]
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
This document describes the
.B groff
program, the main front-end for the
.I groff
document formatting system.
.
The
.I groff
program and macro suite is the implementation of a
.BR roff (@MAN7EXT@)
system within the free software collection
.UR http://\:www.gnu.org
GNU
.UE .
.
The
.I groff
system has all features of the classical
.IR roff ,
but adds many extensions.
.
.
.P
The
.B groff
program allows control of the whole
.I groff
system by command-line options.
.
This is a great simplification in comparison to the classical case (which
uses pipes only).
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
The command line is parsed according to the usual \f[CR]GNU\f[]
convention.
.
The whitespace between a command-line option and its argument is
optional.
.
Options can be grouped behind a single \[oq]\-\[cq] (minus character).
.
A filename of
.B \-
(minus character) denotes the standard input.
.
.
.P
As
.B groff
is a wrapper program for
.B @g@troff
both programs share a set of options.
.
But the
.B groff
program has some additional, native options and gives a new meaning to
some
.B @g@troff
options.
.
On the other hand, not all
.B @g@troff
options can be fed into
.BR groff .
.
.
.\" ====================================================================
.SS Native groff Options
.\" ====================================================================
.
The following options either do not exist for
.B @g@troff
or are differently interpreted by
.BR groff .
.
.
.TP
.BI \-D\  arg
Set default input encoding used by
.B preconv
to
.IR arg .
.
Implies
.BR \-k .
.
.
.TP
.B \-e
Preprocess with
.BR @g@eqn .
.
.
.TP
.B \-g
Preprocess with
.BR @g@grn .
.
.
.TP
.B \-G
Preprocess with
.BR grap .
.
Implies
.BR \-p .
.
.
.TP
.B \-h
.TQ
.B \-\-help
Print a help message.
.
.
.TP
.BI \-I\  dir
This option may be used to specify a directory to search for
files (both those on the command line and those named in
.B .psbb
and
.B .so
requests, and
.B \eX'ps: import'
,
.B \eX'ps: file'
and
.B \eX'pdf: pdfpic'
escapes).
.
The current directory is always searched first.
.
This option may be specified more than once;
the directories are searched in the order specified.
.
No directory search is performed for files specified using an absolute path.
.
This option implies the
.B \-s
option.
.
.
.TP
.B \-j
Preprocess with
.BR @g@chem .
.
Implies
.BR \-p .
.
.
.TP
.B \-k
Preprocess with
.BR preconv .
.
This is run before any other preprocessor.
.
Please refer to
.BR preconv 's
manual page for its behaviour if no
.B \-K
(or
.BR \-D )
option is specified.
.
.
.TP
.BI \-K\  arg
Set input encoding used by
.B preconv
to
.IR arg .
.
Implies
.BR \-k .
.
.
.TP
.B \-l
Send the output to a spooler program for printing.
.
The command that should be used for this is specified by the
.B print
command in the device description file, see
.BR \%groff_font (@MAN5EXT@).
.
If this command is not present, the output is piped into the
.BR lpr (1)
program by default.
.
See options
.B \-L
and
.BR \-X .
.
.
.TP
.BI \-L\  arg
Pass
.I arg
to the spooler program.
.
Several arguments should be passed with a separate
\-L
option each.
.
Note that
.B groff
does not prepend
\[oq]\-\[cq]
(a minus sign) to
.I arg
before passing it to the spooler program.
.
.
.TP
.B \-N
Don't allow newlines within
.I eqn
delimiters.
.
This is the same as the
.B \-N
option in
.BR @g@eqn .
.
.
.TP
.B \-p
Preprocess with
.BR @g@pic .
.
.
.TP
.BI \-P\  \-option
.TQ
.BI \-P\  \-option \ \-P\  arg
Pass
.I \-option
or
.I "\-option\~arg"
to the postprocessor.
.
The option must be specified with the necessary preceding minus
sign(s)
.Quoted \-
or
.Quoted \-\-
because
.B groff
does not prepend any dashes before passing it to the postprocessor.
.
For example, to pass a title to the
.B \%gxditview
postprocessor, the shell command
.
.RS
.IP
.EX
groff \-X \-P \-title \-P 'groff it' \f[I]foo\f[]
.EE
.RE
.
.IP
is equivalent to
.
.RS
.IP
.EX
groff \-X \-Z \f[I]foo\f[] | \
gxditview \-title 'groff it' \-
.EE
.RE
.
.
.TP
.B \-R
Preprocess with
.BR @g@refer .
.
No mechanism is provided for passing arguments to
.B @g@refer
because most
.B @g@refer
options have equivalent language elements that can be specified within
the document.
.
See
.BR \%@g@refer (@MAN1EXT@)
for more details.
.
.
.TP
.B \-s
Preprocess with
.BR @g@soelim .
.
.
.TP
.B \-S
Safer mode.
.
Pass the
.B \-S
option to
.B @g@pic
and disable the following
.B @g@troff
requests:
.BR .open ,
.BR .opena ,
.BR .pso ,
.BR .sy ,
and
.BR .pi .
.
For security reasons, safer mode is enabled by default.
.
.
.TP
.B \-t
Preprocess with
.BR @g@tbl .
.
.
.TP
.BI \-T\  dev
Set output device to
.IR dev .
.
For this device,
.B @g@troff
generates the
.I intermediate
.IR output ;
see
.BR \%groff_out (@MAN5EXT@).
.
Then
.B groff
calls a postprocessor to convert
.BR @g@troff 's
.I intermediate output
to its final format.
.
Real devices in
.B groff
are
.
.RS
.RS
.TP
dvi
TeX DVI format (postprocessor is
.BR grodvi ).
.
.TP
html
.TQ
xhtml
HTML and XHTML output (preprocessors are
.B @g@soelim
and
.BR \%pre-grohtml ,
postprocessor is
.BR \%post-grohtml ).
.
.TP
lbp
Canon CAPSL printers (\%LBP-4 and \%LBP-8 series laser printers;
postprocessor is
.BR grolbp ).
.
.TP
lj4
HP LaserJet4 compatible (or other PCL5 compatible) printers (postprocessor
is
.BR grolj4 ).
.
.TP
ps
PostScript output (postprocessor is
.BR grops ).
.
.TP
pdf
Portable Document Format (PDF) output (postprocessor is
.BR gropdf ).
.RE
.RE
.
.
.IP
For the following TTY output devices (postprocessor is always
.BR grotty ),
.B \-T
selects the output encoding:
.
.RS
.RS
.TP
ascii
7bit \f[CR]ASCII\f[].
.
.TP
cp1047
\%Latin-1 character set for EBCDIC hosts.
.
.TP
latin1
ISO \%8859-1.
.
.TP
utf8
Unicode character set in \%UTF-8 encoding.
.
This mode has the most useful fonts for TTY mode, so it is the best
mode for TTY output.
.RE
.RE
.
.
.IP
The following arguments select
.B \%gxditview
as the \[oq]postprocessor\[cq] (it is rather a viewing program):
.
.RS
.RS
.TP
X75
75\|dpi resolution, 10\|pt document base font.
.TP
X75\-12
75\|dpi resolution, 12\|pt document base font.
.TP
X100
100\|dpi resolution, 10\|pt document base font.
.TP
X100\-12
100\|dpi resolution, 12\|pt document base font.
.RE
.RE
.
.IP
The default device is
.BR @DEVICE@ .
.
.
.TP
.B \-U
Unsafe mode.
.
Reverts to the (old) unsafe behaviour; see option
.BR \-S .
.
.
.TP
.B \-v
.TQ
.B \-\-version
Output version information of
.B groff
and of all programs that are run by it; that is, the given command line
is parsed in the usual way, passing
.B \-v
to all subprograms.
.
.
.TP
.B \-V
Output the pipeline that would be run by
.BR groff
(as a wrapper program) on the standard output, but do not execute it.
.
If given more than once,
the commands are both printed on the standard error and run.
.
.
.TP
.B \-X
Use
.B \%gxditview
instead of using the usual postprocessor to (pre)view a document.
.
The printing spooler behavior as outlined with options
.B \-l
and
.B \-L
is carried over to
.BR \%gxditview (@MAN1EXT@)
by determining an argument for the
.B \-printCommand
option of
.BR \%gxditview (@MAN1EXT@).
.
This sets the default
.B Print
action and the corresponding menu entry to that value.
.
.B \-X
only produces good results with
.BR \-Tps ,
.BR \-TX75 ,
.BR \-TX75\-12 ,
.BR \-TX100 ,
and
.BR \-TX100\-12 .
.
The default resolution for previewing
.B \-Tps
output is 75\|dpi; this can be changed by passing the
.B \-resolution
option to
.BR \%gxditview ,
for example
.
.RS
.IP
.EX
groff \-X \-P\-resolution \-P100 \-man foo.1
.EE
.RE
.
.
.TP
.B \-z
Suppress output generated by
.BR @g@troff .
.
Only error messages are printed.
.
.
.TP
.B \-Z
Do not automatically postprocess
.I groff intermediate output
in the usual manner.
.
This will cause the
.B @g@troff
.I output
to appear on standard output,
replacing the usual postprocessor output; see
.BR \%groff_out (@MAN5EXT@).
.
.
.\" ====================================================================
.SS Transparent Options
.\" ====================================================================
.
The following options are transparently handed over to the formatter
program
.B @g@troff
that is called by
.B groff
subsequently.
.
These options are described in more detail in
.BR @g@troff (@MAN1EXT@).
.
.TP
.B \-a
\f[CR]ASCII\f[] approximation of output.
.
.TP
.B \-b
Backtrace on error or warning.
.
.TP
.B \-c
Disable color output.
.
Please consult the
.BR \%grotty (@MAN1EXT@)
man page for more details.
.
.TP
.B \-C
Enable compatibility mode.
.
.TP
.BI \-d\  cs
.TQ
.BI \-d\  name = s
Define string.
.
.TP
.B \-E
Disable
.B @g@troff
error messages.
.
.TP
.BI \-f\  fam
Set default font family.
.
.TP
.BI \-F\  dir
Set path for font DESC files.
.
.TP
.B \-i
Process standard input after the specified input files.
.
.TP
.BI \-m\  name
Include macro file
.IB name .tmac
(or
.BI tmac. name\c
); see also
.BR \%groff_tmac (@MAN5EXT@).
.
.TP
.BI \-M\  dir
Path for macro files.
.
.TP
.BI \-n\  num
Number the first page
.IR num .
.
.TP
.BI \-o\  list
Output only pages in
.IR list .
.
.TP
.BI \-r\  cn
.TQ
.BI \-r\  name = n
Set number register.
.
.TP
.BI \-w\  name
Enable warning
.IR name .
.
See
.BR @g@troff (@MAN1EXT@)
for names.
.
.TP
.BI \-W\  name
disable warning
.IR name .
.
See
.BR @g@troff (@MAN1EXT@)
for names.
.
.
.\" ====================================================================
.SH "USING GROFF"
.\" ====================================================================
.
The
.I groff system
implements the infrastructure of classical roff; see
.BR roff (@MAN7EXT@)
for a survey on how a
.I roff
system works in general.
.
Due to the front-end programs available within the
.I groff
system, using
.I groff
is much easier than
.IR "classical roff" .
.
This section gives an overview of the parts that constitute the
.I groff
system.
.
It complements
.BR roff (@MAN7EXT@)
with
.IR groff -specific
features.
.
This section can be regarded as a guide to the documentation around
the
.I groff
system.
.
.
.\" ====================================================================
.SS Paper Size
.\" ====================================================================
.
The
.I virtual
paper size used by
.B troff
to format the input is controlled globally with the requests
.BR .po ,
.BR .pl ,
and
.BR .ll .
.
See
.BR groff_tmac (@MAN5EXT@)
for the \[oq]papersize\[cq] macro package which provides a convenient
interface.
.
.
.P
The
.I physical
paper size, giving the actual dimensions of the paper sheets, is
controlled by output devices like
.BR grops
with the command-line options
.B \-p
and
.BR \-l .
.
See
.BR groff_font (@MAN5EXT@)
and the man pages of the output devices for more details.
.
.B groff
uses the command-line option
.B \-P
to pass options to output devices; for example, the following selects
A4 paper in landscape orientation for the PS device:
.
.IP
.EX
groff \-Tps \-P\-pa4 \-P\-l ...
.EE
.
.
.\" ====================================================================
.SS Front-ends
.\" ====================================================================
.
The
.B groff
program is a wrapper around the
.BR @g@troff (@MAN1EXT@)
program.
.
It allows one to specify the preprocessors by command-line options and
automatically runs the postprocessor that is appropriate for the
selected device.
.
Doing so, the sometimes tedious piping mechanism of classical
.BR roff (@MAN7EXT@)
can be avoided.
.
.
.P
The
.BR grog (@MAN1EXT@)
program can be used for guessing the correct
.I groff
command line to format a file.
.
.
.P
The
.BR \%groffer (@MAN1EXT@)
program is an all-around viewer for
.I groff
files and man pages.
.
.
.\" ====================================================================
.SS Preprocessors
.\" ====================================================================
.
The
.I groff
preprocessors are reimplementations of the classical preprocessors
with moderate extensions.
.
The standard preprocessors distributed with the
.I groff
package are
.
.TP
.BR @g@eqn (@MAN1EXT@)
for mathematical formulae,
.
.TP
.BR @g@grn (@MAN1EXT@)
for including
.BR gremlin (1)
pictures,
.
.TP
.BR @g@pic (@MAN1EXT@)
for drawing diagrams,
.
.TP
.BR @g@chem (@MAN1EXT@)
for chemical structure diagrams,
.
.TP
.BR \%@g@refer (@MAN1EXT@)
for bibliographic references,
.
.TP
.BR \%@g@soelim (@MAN1EXT@)
for including macro files from standard locations,
.
.P
and
.
.TP
.BR @g@tbl (@MAN1EXT@)
for tables.
.
.P
A new preprocessor not available in classical
.I troff
is
.BR \%preconv (@MAN1EXT@)
which converts various input encodings to something
.B groff
can understand.
.
It is always run first before any other preprocessor.
.
.P
Besides these, there are some internal preprocessors that are
automatically run with some devices.
.
These aren't visible to the user.
.
.
.\" ====================================================================
.SS "Macro Packages"
.\" ====================================================================
.
Macro packages can be included by option
.BR \-m .
.
The
.I groff
system implements and extends all classical macro packages in a
compatible way and adds some packages of its own.
.
Actually, the following macro packages come with
.IR groff :
.
.TP
.B man
The traditional man page format; see
.BR \%groff_man (@MAN7EXT@).
It can be specified on the command line as
.B \-man
or
.BR \-m\~man .
.
.TP
.B mandoc
The general package for man pages; it automatically recognizes
whether the documents uses the
.I man
or the
.I mdoc
format and branches to the corresponding macro package.
.
It can be specified on the command line as
.B \%\-mandoc
or
.BR \-m\~\%mandoc .
.
.TP
.B mdoc
The \f[CR]BSD\f[]-style man page format; see
.BR \%groff_mdoc (@MAN7EXT@).
.
It can be specified on the command line as
.B \-mdoc
or
.BR \-m\~mdoc .
.
.TP
.B me
The classical
.I me
document format; see
.BR \%groff_me (@MAN7EXT@).
.
It can be specified on the command line as
.B \-me
or
.BR \-m\~me .
.
.TP
.B mm
The classical
.I mm
document format; see
.BR \%groff_mm (@MAN7EXT@).
.
It can be specified on the command line as
.B \-mm
or
.BR \-m\~mm .
.
.TP
.B ms
The classical
.I ms
document format; see
.BR \%groff_ms (@MAN7EXT@).
It can be specified on the command line as
.B \-ms
or
.BR \-m\~ms .
.
.TP
.B www
HTML-like macros for inclusion in arbitrary
.I groff
documents; see
.BR \%groff_www (@MAN7EXT@).
.
.P
Details on the naming of macro files and their placement can be found
in
.BR \%groff_tmac (@MAN5EXT@);
this man page also documents some other, minor auxiliary macro packages
not mentioned here.
.
.
.\" ====================================================================
.SS "Programming Language"
.\" ====================================================================
.
General concepts common to all
.I roff
programming languages are described in
.BR roff (@MAN7EXT@).
.
.
.P
The
.I groff
extensions to the classical
.I troff
language are documented in
.BR \%groff_diff (@MAN7EXT@).
.
.
.P
The
.I groff
language as a whole is described in the (still incomplete)
.IR "groff info file" ;
a short (but complete) reference can be found in
.BR groff (@MAN7EXT@).
.
.
.\" ====================================================================
.SS Formatters
.\" ====================================================================
.
The central
.I roff
formatter within the
.I groff
system is
.BR @g@troff (@MAN1EXT@).
.
It provides the features of both the classical
.I troff
and
.IR nroff ,
as well as the
.I groff
extensions.
.
The command-line option
.B \-C
switches
.B @g@troff
into
.I "compatibility mode"
which tries to emulate classical
.I roff
as much as possible.
.
.
.P
There is a shell script
.BR @g@nroff (@MAN1EXT@)
that emulates the behavior of classical
.BR nroff .
.
It tries to automatically select the proper output encoding, according to
the current locale.
.
.
.P
The formatter program generates
.IR "intermediate output" ;
see
.BR \%groff_out (@MAN7EXT@).
.
.
.\" ====================================================================
.SS Devices
.\" ====================================================================
.
In
.IR roff ,
the output targets are called
.IR devices .
A device can be a piece of hardware, e.g., a printer, or a software
file format.
.
A device is specified by the option
.BR \-T .
.
The
.I groff
devices are as follows.
.
.TP
.B ascii
Text output using the
.BR ascii (7)
character set.
.
.TP
.B cp1047
Text output using the EBCDIC code page IBM cp1047 (e.g., OS/390 Unix).
.
.TP
.B dvi
TeX DVI format.
.
.TP
.B html
HTML output.
.
.TP
.B latin1
Text output using the ISO \%Latin-1 (ISO \%8859-1) character set; see
.BR \%iso_8859_1 (7).
.
.TP
.B lbp
Output for Canon CAPSL printers (\%LBP-4 and \%LBP-8 series laser
printers).
.
.TP
.B lj4
HP LaserJet4-compatible (or other PCL5-compatible) printers.
.
.TP
.B ps
PostScript output; suitable for printers and previewers like
.BR gv (1).
.
.TP
.B pdf
PDF files; suitable for viewing with tools such as
.BR evince (1)
and
.BR okular (1).
.
.TP
.B utf8
Text output using the Unicode (ISO 10646) character set with \%UTF-8
encoding; see
.BR unicode (7).
.
.TP
.B xhtml
XHTML output.
.
.TP
.B X75
75dpi X Window System output suitable for the previewers
.BR \%xditview (1x)
and
.BR \%gxditview (@MAN1EXT@).
.
A variant for a 12\|pt document base font is
.BR \%X75-12 .
.
.TP
.B X100
100dpi X Window System output suitable for the previewers
.BR \%xditview (1x)
and
.BR \%gxditview (@MAN1EXT@).
.
A variant for a 12\|pt document base font is
.BR \%X100-12 .
.
.
.P
The postprocessor to be used for a device is specified by the
.B postpro
command in the device description file; see
.BR \%groff_font (@MAN5EXT@).
.
This can be overridden with the
.B \-X
option.
.
.P
The default device is
.BR @DEVICE@ .
.
.
.\" ====================================================================
.SS Postprocessors
.\" ====================================================================
.
.I groff
provides 3\~hardware postprocessors:
.
.TP
.BR \%grolbp (@MAN1EXT@)
for some Canon printers,
.
.TP
.BR \%grolj4 (@MAN1EXT@)
for printers compatible to the HP LaserJet\~4 and PCL5,
.
.TP
.BR \%grotty (@MAN1EXT@)
for text output using various encodings, e.g., on text-oriented
terminals or line printers.
.
.
.P
Today, most printing or drawing hardware is handled by the operating
system, by device drivers, or by software interfaces, usually
accepting PostScript.
.
Consequently, there isn't an urgent need for more hardware device
postprocessors.
.
.
.P
The
.I groff
software devices for conversion into other document file formats are
.
.TP
.BR \%grodvi (@MAN1EXT@)
for the DVI format,
.
.TP
.BR \%grohtml (@MAN1EXT@)
for HTML and XHTML formats,
.
.TP
.BR grops (@MAN1EXT@)
for PostScript.
.
.TP
.BR gropdf (@MAN1EXT@)
for PDF.
.
.
.P
Combined with the many existing free conversion tools this should
be sufficient to convert a
.I troff
document into virtually any existing data format.
.
.
.\" ====================================================================
.SS Utilities
.\" ====================================================================
.
The following utility programs around
.I groff
are available.
.
.TP
.BR \%addftinfo (@MAN1EXT@)
Add information to
.I troff
font description files for use with
.IR groff .
.
.TP
.BR \%afmtodit (@MAN1EXT@)
Create font description files for PostScript device.
.
.TP
.BR \%eqn2graph (@MAN1EXT@)
Convert an
.B eqn
image into a cropped image.
.
.TP
.BR \%gdiffmk (@MAN1EXT@)
Mark differences between
.IR groff ,
.IR nroff ,
or
.I troff
files.
.
.TP
.BR \%grap2graph (@MAN1EXT@)
Convert a
.B grap
diagram into a cropped bitmap image.
.
.TP
.BR \%groffer (@MAN1EXT@)
General viewer program for
.I groff
files and man pages.
.
.TP
.BR \%gxditview (@MAN1EXT@)
The
.I groff
X viewer, the \f[CR]GNU\f[] version of
.BR xditview .
.
.TP
.BR \%hpftodit (@MAN1EXT@)
Create font description files for lj4 device.
.
.TP
.BR \%@g@indxbib (@MAN1EXT@)
Make inverted index for bibliographic databases.
.
.TP
.BR lkbib (@MAN1EXT@)
Search bibliographic databases.
.
.TP
.BR \%@g@lookbib (@MAN1EXT@)
Interactively search bibliographic databases.
.
.TP
.BR \%pdfroff (@MAN1EXT@)
Create PDF documents using
.BR groff .
.
.TP
.BR \%pfbtops (@MAN1EXT@)
Translate a PostScript font in \&.pfb format to \f[CR]ASCII\f[].
.
.TP
.BR \%pic2graph (@MAN1EXT@)
Convert a
.B pic
diagram into a cropped image.
.
.TP
.BR \%tfmtodit (@MAN1EXT@)
Create font description files for TeX DVI device.
.
.TP
.BR \%xditview (1x)
.I roff
viewer historically distributed with the X Window System.
.\" Nowadays (2017) it's its own module as X.Org does not do monolithic
.\" releases anymore (since 2012).  Development on "app/xditview" is
.\" close to moribund, though.
.
.TP
.BR \%xtotroff (@MAN1EXT@)
Convert X font metrics into \f[CR]GNU\f[]
.I troff
font metrics.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
Normally, the path separator in the following environment variables is
the colon; this may vary depending on the operating system.
.
For example, DOS and Windows use a semicolon instead.
.
.
.TP
.EnvVar GROFF_BIN_PATH
This search path, followed by
.EnvVar $PATH ,
is used for commands that are executed by
.BR groff .
.
If it is not set then the directory where the
.I groff
binaries were installed is prepended to
.EnvVar PATH .
.
.
.TP
.EnvVar GROFF_COMMAND_PREFIX
When there is a need to run different
.I roff
implementations at the same time
.I groff
provides the facility to prepend a prefix to most of its programs that
could provoke name clashings at run time (default is to have none).
.
Historically, this prefix was the character
.BR g ,
but it can be anything.
.
For example,
.BR gtroff
stood for
.IR groff 's
.BR troff ,
.BR gtbl
for the
.I groff
version of
.BR tbl .
.
By setting
.EnvVar GROFF_COMMAND_PREFIX
to different values, the different
.I roff
installations can be addressed.
.
More exactly, if it is set to prefix
.I xxx
then
.B groff
as a wrapper program internally calls
.IB xxx troff
instead of
.BR troff .
.
This also applies to the preprocessors
.BR eqn ,
.BR grn ,
.BR pic ,
.BR \%refer ,
.BR tbl ,
.BR \%soelim ,
and to the utilities
.B \%@g@indxbib
and
.BR \%@g@lookbib .
.
This feature does not apply to any programs different from the ones
above (most notably
.B groff
itself) since they are unique to the
.I groff
package.
.
.
.TP
.EnvVar GROFF_ENCODING
The value of this environment value is passed to the
.B preconv
preprocessor to select the encoding of input files.
.
Setting this option implies
.BR groff 's
command-line option
.B \-k
(this is,
.B groff
actually always calls
.BR preconv ).
.
If set without a value,
.B groff
calls
.B preconv
without arguments.
.
An explicit
.B \-K
command-line option overrides the value of
.EnvVar GROFF_ENCODING .
.
See
.BR preconv (@MAN1EXT@)
for details.
.
.
.TP
.EnvVar GROFF_FONT_PATH
A list of directories in which to search for the
.BI dev name
directory in addition to the default ones.
.
See
.BR @g@troff (@MAN1EXT@)
and
.BR \%groff_font (@MAN5EXT@)
for more details.
.
.
.TP
.EnvVar GROFF_TMAC_PATH
A list of directories in which to search for macro files in addition
to the default directories.
.
See
.BR @g@troff (@MAN1EXT@)
and
.BR \%groff_tmac (@MAN5EXT@)
for more details.
.
.
.TP
.EnvVar GROFF_TMPDIR
The directory in which temporary files are created.
.
If this is not set but the environment variable
.EnvVar TMPDIR
instead, temporary files are created in the directory
.EnvVar $TMPDIR .
.
On MS-DOS and Windows platforms, the environment variables
.EnvVar TMP
and
.EnvVar TEMP
(in that order) are searched also, after
.EnvVar GROFF_TMPDIR
and
.EnvVar TMPDIR .
.
Otherwise, temporary files are created in
.BR /tmp .
.
The
.BR \%@g@refer (@MAN1EXT@),
.BR \%groffer (@MAN1EXT@),
.BR \%grohtml (@MAN1EXT@),
and
.BR grops (@MAN1EXT@)
commands use temporary files.
.
.
.TP
.EnvVar GROFF_TYPESETTER
Preset the default device.
.
If this is not set the
.B @DEVICE@
device is used as default.
.
This device name is overwritten by the option
.BR \-T .
.
.
.\" ====================================================================
.SH EXAMPLES
.\" ====================================================================
.
The following example illustrates the power of the
.B groff
program as a wrapper around
.BR @g@troff .
.
.
.P
To process a
.I roff
file using the preprocessors
.B tbl
and
.B pic
and the
.B me
macro set, classical
.I troff
had to be called by
.
.IP
.EX
pic foo.me | tbl | troff \-me \-Tlatin1 | grotty
.EE
.
.
.P
Using
.BR groff ,
this pipe can be shortened to the equivalent command
.
.IP
.EX
groff \-p \-t \-me \-T latin1 foo.me
.EE
.
.
.P
An even easier way to call this is to use
.BR grog (@MAN1EXT@)
to guess the preprocessor and macro options and execute the generated
command (by using backquotes to specify shell command substitution)
.
.IP
.EX
\[ga]grog \-Tlatin1 foo.me\[ga]
.EE
.
.
.P
The simplest way is to view the contents in an automated way by
calling
.
.IP
.EX
groffer foo.me
.EE
.
.
.\" ====================================================================
.SH BUGS
.\" ====================================================================
.
On \f[CR]EBCDIC\f[] hosts (e.g., \f[CR]OS/390 Unix\f[]), output
devices
.B ascii
and
.B latin1
aren't available.
.
Similarly, output for \f[CR]EBCDIC\f[] code page
.B cp1047
is not available on \f[CR]ASCII\f[] based operating systems.
.
.
.P
Report bugs to
.MT bug\-groff@\:gnu.org
the groff mailing list
.ME .
.
Include a complete, self-contained example that allows the bug to
be reproduced, and say which version of
.I groff
you are using.
.
.
.\" ====================================================================
.SH "POSITIONS FROM INSTALLATION"
.\" ====================================================================
.
There are some directories in which
.I groff
installs all of its data files.
.
Due to different installation habits on different operating systems,
their locations are not absolutely fixed, but their function is
clearly defined and coincides on all systems.
.
.
.\" ====================================================================
.SS "Collection of Installation Directories"
.\" ====================================================================
.
This section describes the position of all files of the
.I groff
package after the installation \[em] got from
.B Makefile.comm
at the top of the
.I groff
source package.
.
.
.TP
.B @DEFAULT_INDEX@
index directory and index name
.TP
.B @LEGACYFONTDIR@
legacy font directory
.TP
.B @BINDIR@
directory for binary programs
.TP
.B @SYSTEMMACRODIR@
system tmac directory
.TP
.B @DOCDIR@
documentation directory
.TP
.B @EXAMPLEDIR@
directory for examples
.TP
.B @HTMLDOCDIR@
documentation directory for HTML files
.TP
.B @PDFDOCDIR@
documentation directory for PDF files
.TP
.B @DATASUBDIR@
data subdirectory
.TP
.B @COMMON_WORDS_FILE@
file for common words
.TP
.B @FONTDIR@
directory for fonts
.TP
.B @OLDFONTDIR@
directory for old fonts
.TP
.B @MACRODIR@
tmac directory
.TP
.B @TMAC_MDIR@
mm tmac directory
.TP
.B @LOCALFONTDIR@
local font directory
.TP
.B @LOCALMACRODIR@
local tmac directory
.
.
.\" ====================================================================
.SS "groff Macro Directory"
.\" ====================================================================
.
This contains all information related to macro packages.
.
Note that more than a single directory is searched for those files
as documented in
.BR \%groff_tmac (@MAN5EXT@).
.
For the
.I groff
installation corresponding to this document, it is located at
.IR @MACRODIR@ .
.
The following files contained in the
.I groff macro directory
have a special meaning:
.
.
.TP
.B troffrc
Initialization file for
.IR troff .
.
This is interpreted by
.B @g@troff
before reading the macro sets and any input.
.
.
.TP
.B troffrc\-end
Final startup file for
.IR troff .
.
It is parsed after all macro sets have been read.
.
.
.TP
.IB name .tmac
.TQ
.BI tmac. name
Macro file for macro package
.IR name .
.
.
.\" ====================================================================
.SS "groff Font Directory"
.\" ====================================================================
.
This contains all information related to output devices.
.
Note that more than a single directory is searched for those files; see
.BR @g@troff (@MAN1EXT@).
.
For the
.I groff
installation corresponding to this document, it is located at
.IR @FONTDIR@ .
.
The following files contained in the
.I "groff font directory"
have a special meaning:
.
.
.TP
.BI dev name /DESC
Device description file for device
.IR name ,
see
.BR \%groff_font (@MAN5EXT@).
.
.
.TP
.BI dev name / F
Font file for font
.I F
of device
.IR name .
.
.
.\" ====================================================================
.SH AVAILABILITY
.\" ====================================================================
.
Information on how to get
.I groff
and related information is available at the
.UR http://\:www.gnu.org/\:software/\:groff
groff GNU website
.UE .
.
.P
Three
.I groff
mailing lists are available:
.IP
.MT bug\-groff@\:gnu.org
for reporting bugs
.ME .
.
.IP
.MT groff@\:gnu.org
for general discussion of
.IR groff ,
.ME .
.IP
.MT groff\-commit@\:ffii.org
the groff commit list
.ME ,
a read-only list showing logs of commitments to the groff repository.
.
.P
Details on repository access and much more can be found in the file
.B README
at the top directory of the
.I groff
source package.
.
.
.P
There is a free implementation of the
.B grap
preprocessor, written by
.MT faber@\:lunabase.org
Ted Faber
.ME .
.
The actual version can be found at the
.
.UR http://\:www.lunabase.org/\:\|\[ti]faber/\:Vault/\:software/\:grap/
grap website
.UE .
This is the only grap version supported by
.IR groff .
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.B groff
was written by
.MT jjc@\:jclark.com
James Clark
.ME .
.
This document was rewritten, enhanced, and put under the FDL license in
2002 by
.MT groff\-bernd.warken\-72@\:web.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
The
.I groff info file
contains all information on the
.I groff
system within a single document, providing many examples and
background information.
.
See
.BR info (1)
on how to read it.
.
.
.P
Due to its complex structure, the
.I groff
system has many man pages.
.
They can be read with
.BR man (1)
or
.BR \%groffer (@MAN1EXT@).
.
.P
But there are special sections of
.IR "man pages" .
.
.I groff
has man pages in sections
.BR 1 , " 5" , and " 7" .
.
When there are several
.I man pages
with the same name in the same
.I man
section, the one with the lowest section is should as first.
.
The other man pages can be shown anyway by adding the section number
as argument before the man page name.
.
Reading the man page about the
.I groff
language is done by one of
.RS
.nf
.nh
.EX
.B man 7 groff
.B groffer 7 groff
.EE
.hy
.fi
.RE
.
.ad l
.TP
Introduction, history and further readings:
.BR roff (@MAN7EXT@).
.
.TP
Viewer for groff files:
.BR \%groffer (@MAN1EXT@),
.BR \%gxditview (@MAN1EXT@),
.BR \%xditview (1x).
.
.TP
Wrapper programs for formatters:
.BR \%groff (@MAN1EXT@),
.BR \%grog (@MAN1EXT@).
.
.TP
Roff preprocessors:
.BR \%@g@eqn (@MAN1EXT@),
.BR \%@g@grn (@MAN1EXT@),
.BR \%@g@pic (@MAN1EXT@),
.BR \%@g@chem (@MAN1EXT@),
.BR \%preconv (@MAN1EXT@),
.BR \%@g@refer (@MAN1EXT@),
.BR \%@g@soelim (@MAN1EXT@),
.BR \%@g@tbl (@MAN1EXT@),
.BR grap (1).
.
.TP
Roff language with the groff extensions:
.BR \%groff (@MAN7EXT@),
.BR \%groff_char (@MAN7EXT@),
.BR \%groff_diff (@MAN7EXT@),
.BR \%groff_font (@MAN5EXT@).
.
.TP
Roff formatter programs:
.BR \%@g@nroff (@MAN1EXT@),
.BR \%@g@troff (@MAN1EXT@),
.BR ditroff (@MAN7EXT@).
.
.TP
The intermediate output language:
.BR \%groff_out (@MAN7EXT@).
.
.TP
Postprocessors for the output devices:
.BR \%grodvi (@MAN1EXT@),
.BR \%grohtml (@MAN1EXT@),
.BR \%grolbp (@MAN1EXT@),
.BR \%grolj4 (@MAN1EXT@),
.BR \%lj4_font (@MAN5EXT@),
.BR \%grops (@MAN1EXT@),
.BR \%gropdf (@MAN1EXT@),
.BR \%grotty (@MAN1EXT@).
.
.TP
Groff macro packages and macro-specific utilities:
.BR \%groff_tmac (@MAN5EXT@),
.BR \%groff_man (@MAN7EXT@),
.BR \%groff_mdoc (@MAN7EXT@),
.BR \%groff_me (@MAN7EXT@),
.BR \%groff_mm (@MAN7EXT@),
.BR \%groff_mmse (@MAN7EXT@),
.BR \%groff_mom (@MAN7EXT@),
.BR \%groff_ms (@MAN7EXT@),
.BR \%groff_www (@MAN7EXT@),
.BR \%groff_trace (@MAN7EXT@),
.BR \%mmroff (@MAN7EXT@).
.
.TP
The following utilities are available:
.BR \%addftinfo (@MAN1EXT@),
.BR \%afmtodit (@MAN1EXT@),
.BR \%eqn2graph (@MAN1EXT@),
.BR \%gdiffmk (@MAN1EXT@),
.BR \%grap2graph (@MAN1EXT@),
.BR \%groffer (@MAN1EXT@),
.BR \%gxditview (@MAN1EXT@),
.BR \%hpftodit (@MAN1EXT@),
.BR \%@g@indxbib (@MAN1EXT@),
.BR \%lkbib (@MAN1EXT@),
.BR \%@g@lookbib (@MAN1EXT@),
.BR \%pdfroff (@MAN1EXT@),
.BR \%pfbtops (@MAN1EXT@),
.BR \%pic2graph (@MAN1EXT@),
.BR \%tfmtodit (@MAN1EXT@),
.BR \%xtotroff (@MAN1EXT@).
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[groff_1_c]
.
.
.\" ====================================================================
.\" Emacs setup
.\" ====================================================================
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
