/*

ssh2includes.h

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

*/

#ifndef SSH2INCLUDES_H
#define SSH2INCLUDES_H

#include "sshincludes.h"
#include "sshsessionincludes.h"
#include "ssh2version.h"


#ifdef WIN32
  /* SSH_WIN_CLIENT is defined if this is a Windows client compile. */
#  define SSH_WIN_CLIENT
#endif

#ifdef SSH_WIN_CLIENT
/* We'll define internal_ss1 here because it's not defined during distribution
   for Windows client, and it needs to be defined somewhere globally.*/
#define WITH_INTERNAL_SSH1_EMULATION

/* The global defines for the client compile are also set here. */
#define SSH_CHANNEL_SESSION
#define SSH_CHANNEL_X11
#endif /* SSH_WIN_CLIENT */



/* File executed in user's home directory during login. */
#define SSH_USER_RC             "rc"
#define SSH_USER_ENV_FILE       "environment"
#define SSH_SYSTEM_RC           ETCDIR "/sshrc"

/* Default tcp/udp port */
#define SSH_DEFAULT_PORT        "22"

/* Definitions for authentication method names. */
#define SSH_AUTH_PUBKEY "publickey"
#define SSH_AUTH_PASSWD "password"
#define SSH_AUTH_HOSTBASED "hostbased"

/* Path to sshsigner2 */
#define SSH_SIGNER_PATH "ssh-signer2"

/* arguments to ssh2 */
#define SSH2_GETOPT_ARGUMENTS "ac:C::vd:e:f::F:hi:l:L:no:p:PqR:s:Stx8gVkw1:m:"


#define SSH2_VERSION_STRING "SSH Secure Shell " SSH2_VERSION \
                            " (non-commercial version)"
#define SSH2_PROTOCOL_VERSION_STRING SSH2_VERSION \
                                     " SSH Secure Shell (non-commercial)"


#endif /* SSH2INCLUDES_H */
