/*

  Author: Tomi Salo <ttsalo@ssh.fi>

  Copyright (C) 1996 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Header file for snprintf.c

  */

/*
 * $Id:
 * $Log: sshsnprintf.h,v $
 * $EndLog$
 */

#ifndef SNPRINTF_H
#define SNPRINTF_H

#ifndef NO_SNPRINTF

/* Write formatted text to buffer 'str', using format string 'format'.
   Returns number of characters written, or negative if error
   occurred. Buffer's size is given in 'size'. Format string is
   understood as defined in ANSI C.

   NOTE: This does NOT work identically with BDS's snprintf.

   Integers: Ansi C says that precision specifies the minimun number
   of digits to print. BSD's version however counts the prefixes (+,
   -, ' ', '0x', '0X', octal prefix '0'...) as 'digits'.

   Also, BSD implementation does not permit padding integers to
   specified width with zeros on left (in front of the prefixes), it
   uses spaces instead, even when Ansi C only forbids padding with
   zeros on the right side of numbers. */

#ifdef SSH_MAKING_EPRINTF
DLLEXPORT int ssh_esnprintf(char *str, size_t size, const char *format, ...);
DLLEXPORT int ssh_evsnprintf(char *str, size_t size, const char *format, va_list ap);
#else
DLLEXPORT int snprintf(char *str, size_t size, const char *format, ...);
DLLEXPORT int vsnprintf(char *str, size_t size, const char *format, va_list ap);
#endif /* SSH_MAKING_EPRINTF */

#endif /* NO_SNPRINTF */
#endif /* SNPRINTF_H */
