/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_keymgrd.C	1.13 95/11/22"

/*
 * Author: Ashar Aziz
 */
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include "skip_log.h"
#include "Bstream.h"
#include "Bigint.h"
#include "SkipCert.h"

#include <netinet/in.h>
#include <sys/errno.h>

#include "skip_fetchcert.h"
#include "skip_keymgr.h"

extern int skip_fetch_cert;		/* Is certificate fetching turned on? */
extern int skip_disk_cache;
extern int verbose;				/* generate verbose output */
extern int readrc;
extern u_char mynsid;

extern int		errno;
int keyfd;		// XXX

extern Bstream		CA_X509_Cert;


char		outbuf[MGTCSIZE];
char		inbuf[MGTCSIZE];

void usage(){
	skip_log(SKIP_ERROR,"Usage: skip_keymgrd [-f] [-c] [-v]\n");
	exit(1);
}


void get_certificate(int, struct remote_info *, void *);

main(int argc, char **argv)
{
	struct remote_info rem_boxid;
	u_long status;
	int size;
	int c;
	char *secret_file, *dhparams_file, *ca_file, *cert_file;
	String temp;
	Bstream tempstr;
	extern char *optarg;

	secret_file=NULL;		/* Use the defaults */
	dhparams_file=NULL;
	ca_file=NULL;
	cert_file=NULL;
	skip_fetch_cert = 0;
	skip_disk_cache = 0;
	readrc = 1;
	verbose = 0;
	UPDATE_FREQ = 3600;
	while ((c=getopt(argc,argv,"fvc"))!= -1) {
		switch (c) {
			case 'c':
				skip_disk_cache = 1;
				break;
			case 'f':
				readrc = 0;
				break;
			case 'v':
				verbose = 1;
				break;
			default:
				usage();
				break;
		}
	}

	keyfd = skip_open_device();

	if (keyfd < 0) 
		exit(1);

// The order of this section is VERY important

	skip_init_internal_cryptors(keyfd);

	skip_keymgr_init(keyfd);

	if (readrc)
		keymgrd_read_rc();
// End of Critical ordering section

	if (skip_fetch_cert < 0)	
		skip_fetch_cert = 0;


 	skip_log(SKIP_NOTICE, "Global n-counter frequency set to %d seconds", UPDATE_FREQ);

	for (;;) {
		size=get_skip_msg(keyfd, inbuf, MGTCSIZE);
		if (size <= 0 ) /* XXX */
			continue;

		status = make_response(inbuf, outbuf, &size, &rem_boxid);

		switch(status) {
			case KEYMGR_NOCERT:
				if (skip_fetch_cert) {
			 	    get_certificate(keyfd, &rem_boxid, inbuf);
				    continue;
				}
				else {
#if 0
					tempstr=rem_boxid.keyid;
					temp=tempstr.gethexstr();
					skip_log(SKIP_ERROR,"Unable to retrieve certificiate for %s",(const char *)temp);
#endif
					continue;
				}

			case KEYMGR_LOCAL_EXPIRED:
				continue;

			case KEYMGR_NO_MANUAL_KEY: {
				tempstr=rem_boxid.keyid;
				temp=tempstr.gethexstr();
				skip_log(SKIP_ERROR,"Manual key not setup for 0x%s",(const char *)temp);
				continue;
			}
			case KEYMGR_BAD_N_OFFSET:
				skip_log(SKIP_ERROR,"N-counter out of range - discarding request");
				continue;

			case KEYMGR_BADALG:
				continue;

			case KEYMGR_OK:
			default:
				put_skip_msg(keyfd, outbuf, size);
		}
	}
	return(0);
}
