/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_bn_glue.C	1.9 %V%"

// This file creates a glue layer between the bn (BigNum) package and the
// key manager.  In theory, we could have several packages which perform
// exponentiation which would also have a glue file.

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include "Bigint.h"
#include "Bstream.h"
#include "skip_log.h"

#include "my_types.h"
#include "bn.h"
#include "bn_glue.h"
#include "bnprint.h"

// opaque structure returned to key manager for DH parameters
struct bn_dh_params {
	struct BigNum *g, *p;
};

Bstream compute_dh_secret(void *, Bstream , Bstream );

// Takes the Bigint diffie-hellman parameters and turns them into something
// the BigNum package can understand.  Returns the opaque structure above.

void *
localize_dhparams( const Bigint g, const Bigint p )
{
	struct bn_dh_params *dh;

        int retval;
	int n;

	dh=new bn_dh_params;

	dh->p=new BigNum;
	dh->g=new BigNum;
	bnBegin(dh->p);	
	bnBegin(dh->g);	

	Bigint_to_BigNum(&p, dh->p);
	Bigint_to_BigNum(&g, dh->g);

#ifdef DEBUG
	printf("g=");
	bnPrint(stdout,&tempg);
	printf("\np=");
	bnPrint(stdout,dh->p);
	printf("\n");
	fflush(stdout);
#endif
	return dh;
}

// Routine to call the routine which actually does the exponentiation.
Bstream
bn_exponentiate( Bstream generator, Bstream exponent, Bstream modulus)
{
	Bstream retstr;
	BigNum g, i, j, p;
	BigNum result;
	u_char 	buf[10240];
        int o;

	bnBegin(&g);	
	bnBegin(&i);	
	bnBegin(&p);	
	bnBegin(&result);

	Bstream_to_BigNum(&generator, &g);
	Bstream_to_BigNum(&exponent, &i);
	Bstream_to_BigNum(&modulus, &p);

	if (bnExpMod(&result, &g,&i,&p)< 0)
		return retstr;
	BigNum_to_Bstream(&result, &retstr);

	bnEnd(&g);
	bnEnd(&i);
	bnEnd(&p);
	bnEnd(&result);
	return retstr;
}

// Another routine to do exponentation, more specific to the key manager.
// This should probably be folded into exponentiate.

Bstream compute_dh_secret(void *dhbuf, Bstream mydhsecret,
                        	Bstream other_dh_public_value)
{
	struct bn_dh_params *dh_params;
	Bstream retstr;
	BigNum i,p,j,g, result;

	dh_params=(bn_dh_params *) dhbuf;

	bnBegin(&g);
	bnBegin(&i);
	bnBegin(&p);
	bnBegin(&j);
	bnBegin(&result);

	bnCopy(&g, dh_params->g);
	Bstream_to_BigNum(&mydhsecret, &i);
	bnCopy(&p, dh_params->p);
	Bstream_to_BigNum(&other_dh_public_value, &j);

	if (bnExpMod(&result, &j,&i,&p)< 0)
		return retstr;

	BigNum_to_Bstream(&result, &retstr);

	bnEnd(&result);
	bnEnd(&g);
	bnEnd(&i);
	bnEnd(&j);
	bnEnd(&p);
	return retstr;
}

// Initialize internal structures of BigNum
void init_cryptolib()
{
	bnInit();
}
