/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_ioctl.h	1.13 95/11/16 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

#define	SKIPSZ		(16)

/*
 * max number of crypto systems supported (== sizeof unsigned char)
 */
#define SKIP_MAXCRYPTORS        256

/*
 * SKIP end system ioctls
 */
enum {	SKIP_ES_ADD_IF,			/* create new interface */
	SKIP_ES_DEL_IF,			/* delete an interface */
	SKIP_ES_ADD_HOST,		/* add a host to the access list */
	SKIP_ES_DEL_HOST,		/* remove a host from the list */
	SKIP_ES_GET_HOST,		/* get a host's acl from the list */
	SKIP_ES_LIST_HOSTS,		/* return list of current hosts */
	SKIP_ES_SET_MODE,		/* turn access control on/off */
	SKIP_ES_GET_MODE,		/* test if access control on/off */
	SKIP_ES_GET_IF_STATS,		/* get skip interface statistics */
	SKIP_ES_GET_KEY_STATS,		/* get skip keys statistics */
	SKIP_ES_GET_HDR_STATS,		/* get skip headers statistics */
	SKIP_ES_GET_CPT_STATS,		/* get crypto modules statistics */
	SKIP_ES_GET_CRYPTORS,		/* get loaded cryptors list */
	SKIP_ES_GET_KIJ_ALGS,		/* get supported kij algs list */
	SKIP_ES_GET_VAR,		/* get named variable value (kvm like)*/
	SKIP_ES_SET_VAR,		/* set named variable value (kvm like)*/
	SKIP_ES_KEY_STATUS		/* get crypto keys status (kvm like)*/
};		

#ifndef boolean_t
#define boolean_t       int
#endif

/*
 * SKIP_ES_ADD_HOST SKIP_ES_DEL_HOST SKIP_ES_LIST_HOSTS ioctls
 */
typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */

	/* followed by array of skip_param_t[] */
	void		*hostinfo;

} skip_es_req_t;
	
/*
 * maximum hosts in an ACL... XXX
 */
#define	SKIP_MAX_HOSTS	1024
#define	SKIP_MAX_IOSZ	(SKIPSZ + SKIP_MAX_HOSTS * sizeof(skip_param_t))

/*
 * SKIP_ES_XXX_MODE ioctls
 */
enum { SkipAccessControlOn, SkipAccessControlOff, SkipInteractive };

typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */
	int		if_mode;
} skip_es_mode_t;

/*
 * structures describing SKIP key driver statistics
 */
typedef struct {
	unsigned long		skip_encrypt_keys_active;
	unsigned long		skip_decrypt_keys_active;
	unsigned long		skip_key_lookups;
	unsigned long		skip_keymgr_requests;
	unsigned long		skip_key_reclaims;
	unsigned long		skip_key_nocanput;
	unsigned long		skip_key_allocbfail;
	unsigned long		skip_key_kmemallocfail;
	unsigned long		skip_hash_collisions;
} ioctl_key_stat_t;

typedef struct {
	unsigned long		skip_hdr_encodes;
	unsigned long		skip_hdr_decodes;
	unsigned long		skip_hdr_runts;
	unsigned long		skip_hdr_short_nodeids;
	unsigned long		skip_hdr_short_r_mkeyid;
	unsigned long		skip_hdr_short_s_mkeyid;
	unsigned long		skip_hdr_bad_r_mkeyid;
	unsigned long		skip_hdr_short_ekps;
	unsigned long		skip_hdr_short_mids;
	unsigned long		skip_hdr_bad_kp_algs;
	unsigned long		skip_hdr_bad_versions;
	unsigned long		skip_ipsp_decodes;
	unsigned long		skip_ipsp_encodes;
	unsigned long		skip_hdr_bad_nsid;
	unsigned long		skip_hdr_bad_next;
	unsigned long		skip_hdr_bad_spi;
	unsigned long		skip_hdr_bad_iv;
	
} ioctl_hdr_stat_t;

/*
 * structure describing SKIP per-crypto system statistics
 */
typedef struct {
	unsigned int		module_id;
	unsigned long		encrypts;
	unsigned long		encrypterrs;
	unsigned long		decrypts;
	unsigned long		decrypterrs;
} crypt_mod_stat_t;

/*
 * Per SKIP interface statistics
 */
typedef struct {
	unsigned long	skip_if_ipkts;
	unsigned long	skip_if_opkts;
	unsigned long	skip_if_encrypts;
	unsigned long	skip_if_decrypts;
	unsigned long	skip_if_bypasses;
	unsigned long	skip_if_drops;
	unsigned long	skip_if_nocanput;
#ifdef SYSV
	unsigned long	skip_if_allocbfail;
#endif
	/*
	 * New - ESP support
	 */
	unsigned long	skip_if_bad_ah;
} ioctl_if_stat_t;

/*
 * Crypto Modules statistics
 */
typedef struct {
	unsigned int		nb_algs;
	unsigned char		version;
	crypt_mod_stat_t	crypt_stats[SKIP_MAXCRYPTORS];
} ioctl_crypt_stat_t;

/*
 * SKIP_ES_XXX_STATS ioctls
 */

typedef struct {
	char	if_name[SKIPSZ];
	union {
		ioctl_if_stat_t		if_stats;
		ioctl_key_stat_t	key_stats;
		ioctl_hdr_stat_t	hdr_stats;
	} stats;
			
} skip_ctrl_stats_t;

/*
 * Kij/Kp Modules List
 */
typedef struct {
	boolean_t	flag_alg[SKIP_MAXCRYPTORS];
	boolean_t	flag_alg_v1[SKIP_MAXCRYPTORS];
} ioctl_alg_list_t;

/*
 * Set/Get var ioctls
 */

#define MAXVARNAMELG	40

typedef struct {
	char	var_name[MAXVARNAMELG];
	int	var_lg;
	int	var_value;
} ioctl_skip_sym_t;

/*
 * XXX - size of a crypto variable
 */
#define	MAXVARSZ		24

/*
 * Encryption/Decryption keys status
 */
typedef struct {
	skip_param_t		params;
	int			ekp_len;
	char			ekp_buf[MAXVARSZ];
	unsigned int		obytes;
	int			max_obytes;
	int			count_out;
	int			count_in;
} ioctl_key_status_t;

enum { SkipUnknownSrc, SkipUnknownDst, SkipAuthFailed, SkipBadParams };

/*
 * SKIP notification - message sent to user space in interactive mode
 */
typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */
	int		what;
	struct ip	iphdr;
	skip_param_t	params;
} skip_es_notification_t;

/*
 * SKIP access control ioctls
 */
#ifdef SYSV

typedef struct strioctl	skip_io_t;

#else

#define	SKIPDEV		"/dev/skip"
typedef struct {
        int             ic_cmd;
        int             ic_timout;
        int             ic_len;
        char            *ic_dp;
} skip_io_t;

#define SKIPIOACL       _IOWR('S', 1, skip_io_t)

#endif

#ifdef  __cplusplus
}
#endif
