/* daemon.c 
   Encryption services daemon v0.9
   By Maude X
   July 1995 */

#include <stdio.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>

#include "random.h"

void main(int ac,char **av){
  char inputstr[2048],cmd[16],arg[2048];
  int port;
  char dh3desflag=0;
  unsigned char mod[1024],gen[1024],pub[1024],sec[1024],sk[1024];
  unsigned char *ptr;
  int x,y;
  int sp[2];
  
  randomize();
  if(ac<2) goto start;

  wait4connect(atoi(av[1]));
  
  start:
  randomize();
  puts("2000 cryptod v0.9 ready");fflush(stdout);
  mainloop:
  randomize();
  if(fgets(inputstr,2048,stdin)) {
    randomize();
    *arg=0;
    sscanf(inputstr,"%s %s",cmd,arg);
    lcc(cmd);
    if(!strcmp(cmd,"lport")) {
      if(sscanf(arg,"%4x",&port)>0&&port>0&&port<=0xFFFF) {
        puts("2500 Connecting...");fflush(stdout);
        lport(port);
        exit(0);
      } else {
        puts("4000 Syntax Error");fflush(stdout);
      }
    } else if(!strcmp(cmd,"rport")) {
      rport(arg);
    } else if(!strcmp(cmd,"dh3des")) {
      dh3desflag=1;
      puts("3001 Okay");fflush(stdout);
    } else if(!strcmp(cmd,"mod")&&dh3desflag) {
      if(*arg){
        h(arg,mod);
        puts("2210 Modulus Okay");
        fflush(stdout);
      } else {puts("4034");fflush(stdout);}
    } else if(!strcmp(cmd,"gen")&&dh3desflag) {
      if(*arg){
        h(arg,gen);
        puts("2210 Generator Okay");
        fflush(stdout);
      } else {puts("4034");fflush(stdout);}
    } else if(!strcmp(cmd,"exch")&&dh3desflag) {
      ptr=randomize();
      bzero(sec,1024);
      bcopy(ptr,sec+960,64);
      modexp(gen,sec,mod,pub);
      printf("2212 ");p(pub);fflush(stdout);
      h(arg,pub);
      modexp(pub,sec,mod,sk); /* Generate session key */
      randomize(); /* Destroy the evidence */
      bzero(sec,1024);
    } else if(!strcmp(cmd,"rand")) { /* For debugging */
      ptr=randomize();
      for(x=0;x<64;x++) {
        y=ptr[x];
        printf("%2x",y);
      }
      puts("");fflush(stdout); 
    } else if(!strcmp(cmd,"encr")&&dh3desflag) {
      socketpair(AF_UNIX,SOCK_STREAM,0,sp);
      if(fork()) {
        dup2(sp[1],0);
        dup2(sp[1],1);
        close(sp[0]);
        goto start;
      } else {
        close(sp[1]);
        puts("2300 Encrypted Session Begins Now");
        fflush (stdout);
        desloop(0,sp[0],sk);
        exit(0);
      }
    } else if(!strcmp(cmd,"quit")) {
      puts("2100 Goodbye");
      fflush(stdout);
      exit(0);
    } else {
      puts("5000 What?");
      fflush(stdout);
    }
    goto mainloop;
  }
}

/* Lower Case Conversion */
lcc(char *str){
  int x;
  for (x=0;str[x]!=0;x++) {
    if(str[x]>='A'&&str[x]<='Z') str[x]|=0x20;
  }
}

lport(int port)
{
  register char *ipaddr;
  int connection_ok;
  int fd,remotefd;
  struct sockaddr_in remoteserver;
  
  remoteserver.sin_family = AF_INET;
  remoteserver.sin_port = htons(port);
  
  ipaddr = (char *)&remoteserver.sin_addr;
  *ipaddr++=127;
  *ipaddr++=0;
  *ipaddr++=0;
  *ipaddr++=1;

  remotefd = socket(AF_INET, SOCK_STREAM, 0);

  connection_ok = connect (remotefd, (struct sockaddr *)&remoteserver, sizeof(remoteserver));
  if (connection_ok < 0)
    {
      puts("4010 Connection Error");
      fflush (stdout);
      return(1);
    }

  /* Okay, connection established. */

  puts("2400 Connection Established");
  fflush (stdout);

  fd=0; /* From stdin to remote */
  loop(fd,remotefd);
}

rport(char arg[])
{
  int connection_ok;
  int fd,remotefd;
  struct sockaddr_in remoteserver;
  int port;

  if(sscanf(arg,"%2x%2x%2x%2x%4x",(char *)&remoteserver.sin_addr,
      (char *)&remoteserver.sin_addr+1,(char *)&remoteserver.sin_addr+2,
      (char *)&remoteserver.sin_addr+3,&port)!=5) {
    puts("4000 Syntax Error");
    fflush(stdout);
    return;
  } else {
    puts("2500 Connecting...");
    fflush(stdout);
  }
  remoteserver.sin_family = AF_INET;
  remoteserver.sin_port = htons(port);
  
  remotefd = socket(AF_INET, SOCK_STREAM, 0);

  connection_ok = connect (remotefd, (struct sockaddr *)&remoteserver, sizeof(remoteserver));
  if (connection_ok < 0)
    {
      puts("4010 Connection Error");
      fflush (stdout);
      return(1);
    }

  /* Okay, connection established. */

  puts("2400 Connection Established");
  fflush (stdout);

  fd=0; /* From stdin to remote */
  loop(fd,remotefd);
  exit(0);
}
