/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/list_server.c,v $
 *
 *
 *  MODULE NAME:    list_server.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/param.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"
#include "random.h"
#include "spxapi_defs.h"

extern int optind, opterr;
extern char *optarg;

char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
    register char *cp;
    int     c, errflg = 0;
    char    servername[ANAME_SZ], ver_string_name[FULLNAME_SZ];
    VerifierCred  cred;
    char    str_notBefore[40], str_notAfter[40];
    int     vflag = 0;
    TrustedCred        ta_cred;

    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    opterr = 0;
    bzero(servername, sizeof(servername));
    while ((c=getopt(argc, argv, "v")) != EOF)
      switch(c) {
        case 'v' :
	  vflag++;
	  break;
	case '?' :
	  errflg++;
	}

    if (argv[optind] != NULL) strcpy(servername, argv[optind++]);
    if (optind != argc) errflg++;
    if (errflg) {
      printf("Usage: %s [-v] [servername]\n", progname);
      printf("\t-v      verbose mode\n");
      exit(1);
    }

    if (strlen(servername)) {
	printf("Sphinx list server credentials for '%s'\n", servername);
    } else {
	printf("Sphinx list server credentials\n");
	printf("server's name : ");
	gets(servername);
	if (!*servername)
	    exit(0);
    }

  /*  read claimant credentials from issuer's file  */
  strcpy(ver_string_name, ver_string(servername, NULL));
  if (vf_init(ver_string_name, R_TKT_FIL) != ASUCCESS) {
    printf("verifier credential file '%s' doesn't exist\n", ver_string_name);
      exit(-1);
    }

  vf_get_cred(servername, &cred, &ta_cred);

  printf("\nVerifier Credentials for %s  (%s)\n",cred.name, ver_string_name);
  printf("fullname is '%s'\n",cred.fullname);
  printf("uuid     is ");
  nospace_hexdump(cred.uuid, cred.uidlen);
  printf("\n");
  strcpy(str_notBefore, asctime(localtime(&cred.before)));
  printf("  not valid before %s",str_notBefore);
  strcpy(str_notAfter, asctime(localtime(&cred.after)));
  printf("  not valid after  %s",str_notAfter);
  if (vflag) {
    printf("  privRSAKey :\n");
    PrintPrivKey (cred.privRSAKey);
  }

  printf("\n%s\n\thas ", cred.fullname);
  display_ta_cred(&ta_cred,vflag);
  printf("\n");
}
