/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/validate_expired.c,v $
 *
 *
 *  MODULE NAME:    validate_expired.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *      J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include <sys/time.h>

/*
  takes:
	 v	pointer to type_SPHINX_Validity 
	 pp	if non-zero, printout times to stdout is desired
  returns:
	-1	if not yet valid (current time less than validity interval)
	 0	if valid
	 1	if expired
*/
int validate_expired (v,pp)
struct type_SPHINX_Validity *v ;
int pp;
{
   struct type_UNIV_UTCTime *time_ptr ;
   time_t now, begins, ends;
   int i;
   char *pstr;


   time_ptr = v->notBefore ;
   pstr = qb2str(time_ptr);
   begins = gtime(ut2tm(str2utct(pstr, strlen(pstr))));

   time_ptr = v->notAfter ;
   pstr = qb2str(time_ptr);
   ends = gtime(ut2tm(str2utct(pstr, strlen(pstr))));

   i = 0;
   time(&now);
   if (begins > now)  {
	i = -1 ;
#ifdef DEBUG
printf("\nNot yet valid.\n");
#endif
   }
   if (now > ends) {
	i = 1;
#ifdef DEBUG
printf("\nExpired.\n");
#endif
   }

   if (pp) {
	printf(" Valid   from:   %s", ctime(&begins));
	printf("         to:     %s", ctime(&ends));
/*
        printf(" Current time:   %s", ctime(&now));
*/
   }

   return(i);
}

struct type_SPHINX_Validity *exp2SPHINX_Validity ( expires )
time_t expires ;
{
    struct type_SPHINX_Validity *valid;
    time_t now;
    UTC utc_time ;
    char *string_time;
    utc_time = (UTC) malloc (sizeof *utc_time);

    time(&now);

    tm2ut(gmtime(&now),utc_time);
    string_time = utct2str(utc_time);
    valid = (struct type_SPHINX_Validity *) malloc(sizeof *valid);
    valid->notBefore = str2qb(string_time, strlen(string_time), 1);
    tm2ut(gmtime(&expires),utc_time);
    string_time = utct2str(utc_time);
    valid->notAfter = str2qb(string_time, strlen(string_time), 1);
    free(utc_time);

    return(valid);

}
