/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV3,
  makeTestPaymentV2,
  withdrawViaBankV3,
} from "../harness/environments.js";
import { TalerMerchantApi } from "@gnu-taler/taler-util";

/**
 * Run test for payment with a contract that has forgettable fields.
 */
export async function runPaymentForgettableTest(t: GlobalTestState) {
  // Set up test environment

  const { walletClient, bankClient, exchange, merchant, merchantAdminAccessToken } =
    await createSimpleTestkudosEnvironmentV3(t);

  // Withdraw digital cash into the wallet.

  const wres = await withdrawViaBankV3(t, {
    walletClient,
    bankClient,
    exchange,
    amount: "TESTKUDOS:20",
  });

  await wres.withdrawalFinishedCond;

  {
    const order: TalerMerchantApi.Order = {
      summary: "Buy me!",
      amount: "TESTKUDOS:5",
      fulfillment_url: "taler://fulfillment-success/thx",
      extra: {
        foo: { bar: "baz" },
        $forgettable: {
          foo: "gnu",
        },
      },
    };

    await makeTestPaymentV2(t, { walletClient, merchant, order, merchantAdminAccessToken });
  }

  console.log("testing with forgettable field without hash");

  {
    const order: TalerMerchantApi.Order = {
      summary: "Buy me!",
      amount: "TESTKUDOS:5",
      fulfillment_url: "taler://fulfillment-success/thx",
      extra: {
        foo: { bar: "baz" },
        $forgettable: {
          foo: true,
        },
      },
    };

    await makeTestPaymentV2(t, { walletClient, merchant, order, merchantAdminAccessToken });
  }

  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});
}

runPaymentForgettableTest.suites = ["wallet", "merchant"];
