/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import * as tests from "@gnu-taler/web-util/testing";
import { SwrMockEnvironment } from "@gnu-taler/web-util/testing";
import { expect } from "chai";
import { Props } from "./index.js";
import { useComponentState } from "./state.js";
import { buildNullRoutDefinition } from "@gnu-taler/web-util/browser";

describe("Cashout states", () => {
  it.skip("should query backend and render transactions", async () => {
    const env = new SwrMockEnvironment();

    const props: Props = {
      account: "123",
      routeCashoutDetails: buildNullRoutDefinition(),
    };

    // env.addRequestExpectation(CASHOUT_API_EXAMPLE.LIST_FIRST_PAGE, {
    //   response: {
    //     cashouts: [],
    //   },
    // });

    // env.addRequestExpectation(CASHOUT_API_EXAMPLE.MULTI_GET_EMPTY_FIRST_PAGE, {
    //   response: [],
    // });

    const hookBehavior = await tests.hookBehaveLikeThis(
      useComponentState,
      props,
      [
        ({ status, error }) => {
          expect(status).equals("loading");
          expect(error).undefined;
        },
        ({ status, error }) => {
          expect(status).equals("ready");
          expect(error).undefined;
        },
      ],
      env.buildTestingContext(),
    );

    expect(hookBehavior).deep.eq({ result: "ok" });

    expect(env.assertJustExpectedRequestWereMade()).deep.eq({ result: "ok" });
  });
});
