;;;; Definitions for all pages served by the UI.

(yreq "Affordances/identity")		; 'cause we use identity:known-YID? below.
(yreq "UI/scheme-to-html")		; For animations and note-pic.

;;; + These next three should probably be in UI: or something, but oh well...
(define *page-directory* (yreq:make-yreq-pathname "Pages/"))

(defvar *ui-pages* '())
(defvar *ui-file-list* '())
(defvar *ui-safe-urls* '())
(defvar *ui-safe-in-brand-new-urls* '())
;;; -

;;; These access names aren't so great, but the lack of good documentation
;;; elsewhere makes it difficult to know what the best names would be.
(define (ui:proto->always-safe? proto)       (nth 0 proto))
(define (ui:proto->safe-in-brand-new? proto) (nth 1 proto))
(define (ui:proto->name proto)               (nth 2 proto))
(define (ui:proto->method proto)             (nth 3 proto))
(define (ui:proto->args proto)               (nth 4 proto))
(define (ui:proto->translation proto)        (nth 5 proto))
(define (ui:proto->mime-type proto)          (nth 6 proto))
(define (ui:proto->rest proto)            (nthcdr 5 proto))

(define (ui:safe-url? url)
  (member url *ui-safe-urls*))

(define (ui:safe-in-brand-new-url? url)	; Note that "/" is -not- safe here!  Otherwise, the user might bypass the intro pitch.
  (member url *ui-safe-in-brand-new-urls*))

(define (ui:maybe-generate-page-tables)
  (cond ((null? *ui-pages*)
	 (format t "~&Generating page tables...~&")
	 (ui:generate-page-tables))
	(t
	 (format t "~&Page tables already generated.~&"))))

(define (ui:generate-page-tables)
  (set! *ui-pages*
	(map (lambda (entry)
	       (list (list (string-append "/" (ui:proto->name entry)))
		     (ui:proto->method entry)
		     (ui:proto->args entry)))
	     *ui:pages-prototype*))
  (set! *ui-file-list*
	(map (lambda (entry)
	       (append (list (ui:proto->name entry))
		       (ui:proto->rest entry)))
	     *ui:pages-prototype*))
  (for-each (lambda (entry)
	      (when (ui:proto->always-safe? entry)
		(push! (string-append "/" (ui:proto->name entry)) *ui-safe-urls*)))
	     *ui:pages-prototype*)
  (for-each (lambda (entry)
	      (when (ui:proto->safe-in-brand-new? entry)
		(push! (string-append "/" (ui:proto->name entry)) *ui-safe-in-brand-new-urls*)))
	     *ui:pages-prototype*)
  ;; Now add the special cases.
  ;;
  ;; form.html is connected to the file form.scm, which contains a
  ;; procedure that should be called to serve the page.  This is only
  ;; in there for testing---it displays the form data, so you can test
  ;; that forms you're working on actually send the right information
  ;; to the server.  This is in the directory only as form.scm, since
  ;; it doesn't have an HTML part.
  ;;
  ;; inv-form-resp.html is the page that the UI serves if the client
  ;; tries going to a page which has to be a form and the client
  ;; doesn't send form data.  (See the beginning of start-ui.scm.)
  ;; I.e., if you try going directly to /identity.html by typing in
  ;; the URL, this is the page you get.  There is no URL for this page,
  ;; however, so it's not in *ui-pages*.  ui:index will contain the URL
  ;; of the form the user should have filled out.
  (set! *ui-pages*
	(append *ui-pages*
		`((("/" "/index.html") filename "index.html")
		  (("/form.html") filename "form.scm")
		  (("/scanning-animation.gif") proc-name ,ui:animate-scan/cluster)
		  (("/news-note.gif") proc-name ,ui:note-pic) ; Probably obsoleted soon.
		  )))
  (push! "/scanning-animation.gif" *ui-safe-urls*) ; Must do this so the all-URL's-lead-to-/ hack during scanning can refetch the animation.
  (set! *ui-file-list*
	(append *ui-file-list*
		`(("index.html" (scheme-source) "text/html")
		  ("form.scm" (scheme) "text/html")
		  ("inv-form-resp.html" (scheme-source) "text/html") ; See start of ui.scm.
		  ("scanning-animation-0.gif-" (as-is) "image/gif")
		  ("scanning-animation-1.gif-" (as-is) "image/gif")
		  ("scanning-animation-2.gif-" (as-is) "image/gif")
		  ("scanning-animation-3.gif-" (as-is) "image/gif")
		  ("scanning-animation-done.gif-" (as-is) "image/gif")
		  ("news-off.gif-" (as-is) "image/gif")	; Probably obsoleted soon.
		  ("news-on.gif-" (as-is) "image/gif")  ; Probably obsoleted soon.
		  ))))

(define *ui:pages-prototype*
  `(;; Normal pages.
    (#t #f "authenticate.html" form-response ("authenticate.html" "index.html" ; %%% This page currently isn't fetched, 'cause we use ...
							       "original URL" ; %%% ... ui:welcome-back instead.  But -that- doesn't ...
							       "original method" ; %%% arrange all the stuff we have here.  What to do?
							       "original values")
	(scheme-source) "text/html")
    (#t #f "authenticate-response.html" filename "authenticate-response.html" (scheme-source) "text/html")
    (#f #f "att-delete.html" form-response ("att-delete.html" "attestations.html" "msg") (scheme-source) "text/html")
    (#f #f "att-details.html" form-response ("att-details.html" "attestations.html" "id" "msg") (scheme-source) "text/html")
    (#f #f "attestations.html" filename "attestations.html" (scheme-source) "text/html")
    (#f #f "bug-reports.html" filename "bug-reports.html" (scheme-source) "text/html")
    (#f #f "bug-reports-when.html" filename "bug-reports-when.html" (scheme-source) "text/html")
    (#f #f "bug-reports-useful.html" filename "bug-reports-useful.html" (scheme-source) "text/html")
    (#f #f "bug-reports-checklist.html" filename "bug-reports-checklist.html" (scheme-source) "text/html")
    (#f #f "bug-reports-sending-patches.html" filename "bug-reports-sending-patches.html" (scheme-source) "text/html")
    (#f #f "bug-reports-contributions.html" filename "bug-reports-contributions.html" (scheme-source) "text/html")
    (#f #f "block-user.html" filename "block-user.html" (scheme-source) "text/html")
    (#f #f "config-resp.html" form-response ("config-resp.html" "config.html" "phandle" "bug-report" "e-mail") (scheme-source) "text/html")
    (#f #f "config.html" filename "config.html" (scheme-source) "text/html")
    (#f #f "contact-resp.html" form-response ("contact-resp.html" "contact.html" "address" "nickname") (scheme-source) "text/html")
    (#f #f "contact.html" filename "contact.html" (scheme-source) "text/html")
    (#f #f "delete.html" form-response ("delete.html" "att-delete.html" "msg") (scheme-source) "text/html")
    (#f #f "document-changes.html" filename "document-changes.html" (scheme-source) "text/html")
    (#f #f "document-sources.html" filename "document-sources.html" (scheme-source) "text/html")
    (#f #f "fetch-attestations.html" index-req ("fetch-attestations.html" "messages.html" ,identity:known-YID?) (scheme-source) "text/html")
    (#f #f "filtered-messages.html" filename "filtered-messages.html" (scheme-source) "text/html")
    (#f #f "handle-list.html" form-response ("handle-list.html" "lookup-handle.html" "handle") (scheme-source) "text/html")
    (#f #f "help.html" filename "help.html" (scheme-source) "text/html")
    (#f #f "help-attestations.html" filename "help-attestations.html" (scheme-source) "text/html")
    (#f #f "help-license.html" filename "help-license.html" (scheme-source) "text/html")
    (#f #f "help-pitch-index.html" filename "help-pitch-index.html" (scheme-source) "text/html") ; Users can't see this when brand-new. ...
    (#f #t "help-pitch0.html" filename "help-pitch0.html" (scheme-source) "text/html") ; ... But they -can- see these 10.
    (#f #t "help-pitch1.html" filename "help-pitch1.html" (scheme-source) "text/html") ;
    (#f #t "help-pitch2.html" filename "help-pitch2.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch3.html" filename "help-pitch3.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch4.html" filename "help-pitch4.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch5.html" filename "help-pitch5.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch6.html" filename "help-pitch6.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch7.html" filename "help-pitch7.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch8.html" filename "help-pitch8.html" (scheme-source) "text/html") ; 
    (#f #t "help-pitch-caveats.html" filename "help-pitch-caveats.html" (scheme-source) "text/html") ; 
    (#f #f "help-specifying-interests.html" filename "help-specifying-interests.html" (scheme-source) "text/html")
    (#f #f "identity.html" index-req ("identity.html" "messages.html" ,identity:known-YID?) (scheme-source) "text/html")
    (#f #f "interest-okay.html" filename "interest-okay.html" (scheme-source) "text/html")
    (#f #f "interests-contact.html" index-req ("interests-contact.html" "interests.html" ,string->number) (scheme-source) "text/html")
    (#f #f "interests.html" filename "interests.html" (scheme-source) "text/html")
    (#f #f "interests-current.html" filename "interests-current.html" (scheme-source) "text/html")
    (#f #f "interests-directories.html" filename "interests-directories.html" (scheme-source) "text/html")
    (#f #f "interests-oneshot.html" filename "interests-oneshot.html" (scheme-source) "text/html")
    (#f #f "lookup-handle.html" filename "lookup-handle.html" (scheme-source) "text/html")
;;  (#f #f "menu.html" filename "menu.html")
    (#f #f "message-missing.html" form-response ("message-missing.html" "messages.html" "number" "sender") (scheme-source) "text/html")
    (#f #f "messages.html" filename "messages.html" (scheme-source) "text/html")
    (#f #f "passphrase.html" filename "passphrase.html" (scheme-source) "text/html")
    (#f #f "new-message.html" filename "new-message.html" (scheme-source) "text/html")
    (#f #f "news.html" filename "news.html" (scheme-source) "text/html")
    (#f #f "params.html" filename "params.html" (scheme-source) "text/html")
    (#f #f "quit.html" filename "quit.html" (scheme-source . final) "text/html")
    (#f #f "read-message.html" index-req ("read-message.html" "recent-messages.html" ,string->number) (scheme-source) "text/html")
    (#f #f "regfilter.html" filename "regfilter.html" (scheme-source) "text/html")
    (#f #f "reply.html" form-response ("reply.html" "messages.html" "resp-to") (scheme-source) "text/html")
    (#f #f "compose.html" index-req ("compose.html" "messages.html" ,identity:known-yid?) (scheme-source) "text/html")
    (#f #f "request.html" filename "request.html" (scheme-source) "text/html")
    (#f #f "send-message.html" filename "send-message.html" (scheme-source) "text/html")
    (#f #f "sign.html" form-response ("sign.html" "att-details.html" "id" "msg") (scheme-source) "text/html")
    ;; Placeholder pages, to be replaced by the real thing later.
    (#f #f "bookmarks-nyi.html" filename "bookmarks-nyi.html" (scheme-source) "text/html")
    ;; All images:  JPG's.
    (#t #f "logo.jpg" filename "logo.jpg" (as-is) "image/jpeg")
    ;; All images:  GIF's.
    (#t #f "bookmark-add-low.gif" filename "bookmark-add-low.gif" (as-is) "image/gif")
    (#t #f "bookmark-add.gif" filename "bookmark-add.gif" (as-is) "image/gif")
    (#t #f "bookmark-delete-low.gif" filename "bookmark-delete-low.gif" (as-is) "image/gif")
    (#t #f "bookmark-delete.gif" filename "bookmark-delete.gif" (as-is) "image/gif")
    (#t #f "bookmark-order-alphabetic-low.gif" filename "bookmark-order-alphabetic-low.gif" (as-is) "image/gif")
    (#t #f "bookmark-order-alphabetic.gif" filename "bookmark-order-alphabetic.gif" (as-is) "image/gif")
    (#t #f "bookmark-order-chronologic-low.gif" filename "bookmark-order-chronologic-low.gif" (as-is) "image/gif")
    (#t #f "bookmark-order-chronologic.gif" filename "bookmark-order-chronologic.gif" (as-is) "image/gif")
    (#t #f "1-by-1-pixel-transparent.gif" filename "1-by-1-pixel-transparent.gif" (as-is) "image/gif")
    (#t #f "icon-attestations-closed-low.gif" filename "icon-attestations-closed-low.gif" (as-is) "image/gif")
    (#t #f "icon-attestations-closed.gif" filename "icon-attestations-closed.gif" (as-is) "image/gif")
    (#t #f "icon-attestations-open-low.gif" filename "icon-attestations-open-low.gif" (as-is) "image/gif")
    (#t #f "icon-attestations-open.gif" filename "icon-attestations-open.gif" (as-is) "image/gif")
    (#t #f "icon-help-low.gif" filename "icon-help-low.gif" (as-is) "image/gif")
    (#t #f "icon-help.gif" filename "icon-help.gif" (as-is) "image/gif")
    (#t #f "icon-interests-closed-low.gif" filename "icon-interests-closed-low.gif" (as-is) "image/gif")
    (#t #f "icon-interests-closed.gif" filename "icon-interests-closed.gif" (as-is) "image/gif")
    (#t #f "icon-interests-open-low.gif" filename "icon-interests-open-low.gif" (as-is) "image/gif")
    (#t #f "icon-interests-open.gif" filename "icon-interests-open.gif" (as-is) "image/gif")
    (#t #f "icon-invalid-low.gif" filename "icon-invalid-low.gif" (as-is) "image/gif")
    (#t #f "icon-invalid.gif" filename "icon-invalid.gif" (as-is) "image/gif")
    (#t #f "icon-messages-closed-low.gif" filename "icon-messages-closed-low.gif" (as-is) "image/gif")
    (#t #f "icon-messages-closed.gif" filename "icon-messages-closed.gif" (as-is) "image/gif")
    (#t #f "icon-messages-open-low.gif" filename "icon-messages-open-low.gif" (as-is) "image/gif")
    (#t #f "icon-messages-open.gif" filename "icon-messages-open.gif" (as-is) "image/gif")
    (#t #f "icon-news-closed-low.gif" filename "icon-news-closed-low.gif" (as-is) "image/gif")
    (#t #f "icon-news-closed.gif" filename "icon-news-closed.gif" (as-is) "image/gif")
    (#t #f "icon-news-open-low.gif" filename "icon-news-open-low.gif" (as-is) "image/gif")
    (#t #f "icon-news-open.gif" filename "icon-news-open.gif" (as-is) "image/gif")
    (#t #f "icon-not-yet-implemented-low.gif" filename "icon-not-yet-implemented-low.gif" (as-is) "image/gif")
    (#t #f "icon-not-yet-implemented.gif" filename "icon-not-yet-implemented.gif" (as-is) "image/gif")
    (#t #f "icon-requests-low.gif" filename "icon-requests-low.gif" (as-is) "image/gif")
    (#t #f "icon-requests.gif" filename "icon-requests.gif" (as-is) "image/gif")
    (#t #f "icon-shutdown-low.gif" filename "icon-shutdown-low.gif" (as-is) "image/gif")
    (#t #f "icon-shutdown.gif" filename "icon-shutdown.gif" (as-is) "image/gif")
    (#t #f "icon-signup-low.gif" filename "icon-signup-low.gif" (as-is) "image/gif")
    (#t #f "icon-signup.gif" filename "icon-signup.gif" (as-is) "image/gif")
    (#t #f "icon-tune-low.gif" filename "icon-tune-low.gif" (as-is) "image/gif")
    (#t #f "icon-tune.gif" filename "icon-tune.gif" (as-is) "image/gif")
    (#t #f "navbar-attestations-closed-low.gif" filename "navbar-attestations-closed-low.gif" (as-is) "image/gif")
    (#t #f "navbar-attestations-closed.gif" filename "navbar-attestations-closed.gif" (as-is) "image/gif")
    (#t #f "navbar-attestations-open-low.gif" filename "navbar-attestations-open-low.gif" (as-is) "image/gif")
    (#t #f "navbar-attestations-open.gif" filename "navbar-attestations-open.gif" (as-is) "image/gif")
    (#t #f "navbar-help-low.gif" filename "navbar-help-low.gif" (as-is) "image/gif")
    (#t #f "navbar-help.gif" filename "navbar-help.gif" (as-is) "image/gif")
    (#t #f "navbar-interests-closed-low.gif" filename "navbar-interests-closed-low.gif" (as-is) "image/gif")
    (#t #f "navbar-interests-closed.gif" filename "navbar-interests-closed.gif" (as-is) "image/gif")
    (#t #f "navbar-interests-open-low.gif" filename "navbar-interests-open-low.gif" (as-is) "image/gif")
    (#t #f "navbar-interests-open.gif" filename "navbar-interests-open.gif" (as-is) "image/gif")
    (#t #f "navbar-messages-closed-low.gif" filename "navbar-messages-closed-low.gif" (as-is) "image/gif")
    (#t #f "navbar-messages-closed.gif" filename "navbar-messages-closed.gif" (as-is) "image/gif")
    (#t #f "navbar-messages-open-low.gif" filename "navbar-messages-open-low.gif" (as-is) "image/gif")
    (#t #f "navbar-messages-open.gif" filename "navbar-messages-open.gif" (as-is) "image/gif")
    (#t #f "navbar-news-closed-low.gif" filename "navbar-news-closed-low.gif" (as-is) "image/gif")
    (#t #f "navbar-news-closed.gif" filename "navbar-news-closed.gif" (as-is) "image/gif")
    (#t #f "navbar-news-open-low.gif" filename "navbar-news-open-low.gif" (as-is) "image/gif")
    (#t #f "navbar-news-open.gif" filename "navbar-news-open.gif" (as-is) "image/gif")
    (#t #f "navbar-requests-low.gif" filename "navbar-requests-low.gif" (as-is) "image/gif")
    (#t #f "navbar-requests.gif" filename "navbar-requests.gif" (as-is) "image/gif")
    (#t #f "navbar-tune-low.gif" filename "navbar-tune-low.gif" (as-is) "image/gif")
    (#t #f "navbar-tune.gif" filename "navbar-tune.gif" (as-is) "image/gif")
    ;; All images:  these will probably soon be obsolete.
;   (#t #f "dot.gif" filename "dot.gif")
;   (#t #f "star.gif" filename "star.gif")
    ))

;;; End of file.
