;;;; NOTE:  This file -is not used-.  It's kept around for (marginal)
;;;; historical value, but we long ago punted any use of cryptlib.

(yreq "Utilities/yenta-utils")

(def-yenta-var *our-random-state* #f)

(define (crypt:random modulus)
  (do ((result #f))
      (result result)
    (do ((m 1 (* m 256))
	 (n 0 (+ (* n 256)
		 (char->integer (string-ref (cryptlib:random-data 1) 0)))))
	((>= m modulus)
	 (if (< n (- m (modulo m modulus)))
	     (set! result (modulo n modulus)))))))

(define (pwd-encrypt data password)
  (let ((env (cryptlib:create-envelope)))
    (cryptlib:add-resource! env "PASSWORD" password)
    (cryptlib:push-data! env data)
    (let* ((esize (cryptlib:envelope-size env))
	   (data (cryptlib:pop-data! env esize)))
      (cryptlib:destroy-envelope! env)
      data)))

(define (pwd-decrypt data password)
  (let ((denv (cryptlib:create-decryption-envelope)))
    (cryptlib:push-data! denv data)
    (cryptlib:add-resource! denv "PASSWORD" password)
    (let* ((dsize (cryptlib:envelope-size denv))
	   (data (cryptlib:pop-data! env dsize)))
      (cryptlib:destroy-envelope! denv)
      data)))

(define (cryptlib:generate-random-state)
  (cryptlib:initialize!)
  (if *our-random-state*
      (cryptlib:add-random-data! *our-random-state*)
      (begin
	(cryptlib:add-random-data! #t)
	; 256 is RANDOMPOOL_SIZE.
	(set! *our-random-state* (cryptlib:random-data 256)))))

;;; End of file.
