; -*- Scheme -*-
;
; $Id: string15.scm,v 1.1 1998/03/16 07:59:39 foner Exp $

(require 'substring:capitalize!)
(require 'string:copy)

;+doc
; procedure: substring:capitalize
; arguments: string start end
; signature: string x int x int -> string
; pre:       (<= start end (string-length string))
;
; As for SUBSTRING:CAPITALIZE except that the string is not modified,
; instead a new string is returned.
;
; > (define foo "occlUDed cASEmenTs")
; > (substring:capitalize foo 2 11)
; "ocCluded CaSEmenTs"
; > foo
; "occlUDed cASEmenTs"
;-doc

(define substring:capitalize
  (lambda (s ss se)
    (substring:capitalize! (string:copy s) ss se)))

;------------

;+doc
; procedure: string:capitalize
; arguments: string 
; signature: string -> string
;
; Equivalent to (SUBSTRING:CAPITALIZE STRING 0 (STRING-LENGTH STRING))
;
; > (define foo "occlUDed cASEmenTs")
; > (string:capitalize foo)
; "Occluded Casements"
; > foo
; "occlUDed cASEmenTs"
;-doc

(define string:capitalize
  (lambda (s)
    (substring:capitalize s 0 (string-length s))))

; eof
