; -*- Scheme -*-
;
; $Id: string05.scm,v 1.1 1998/03/16 07:59:32 foner Exp $
;

(require 'string:center)

;+doc
; procedure: string:icon:center
; arguments: source size padding
; signature: string x integer . string -> string
; pre:       (and (< 0 size) (< 0 (string-length padding)))

; Center SOURCE in a string of SIZE padding on the left and right, if
; necessary with the PADDING (or spaces if PADDING is not defined).
; If SOURCE cannot be centered exactly, it is placed left of center.
; Truncation is then done at the left and right as necessary. 
;
; This is based on the Icon function `center(s1, i, s2)'
; Note this does not do the same thing as the Icon function for the
; case where (< SIZE (STRING-LENGTH SOURCE).  If anybody can explain
; why the Icon function produces "etroit" in the fourth case, I'll be
; happy to change it. 
;
; > (string:icon:center "Detroit" 10 "+")
; "+Detroit++"
;
; > (string:icon:center "Detroit" 20 "+*+")
; "+*++*+Detroit+*++*++"
;
; > (string:icon:center "Detroit" 20)
; "      Detroit       "
;
; > (string:icon:center "Detroit" 6 "+*+")
; "Detroi"
;-doc

(define string:icon:center
  (lambda (st sz . opt)
    (let ((sl (string-length st)))
      (cond
       ((> sz sl) (string:center st sz (if (null? opt) " " (car opt))))
       ((< sz sl) (string:icon:center::truncate st sz))
       (else st)))))

;-------------

; procedure: string:icon:center::truncate
; arguments: string size
; signature: string x integer -> string
; pre: (< 0 size (string-length string))

(define string:icon:center::truncate
  (lambda (st sz)
    (let ((left (quotient (- (string-length st) sz) 2)))
      (substring st left (+ left sz)))))

; eof
