; -*- Scheme -*-
;
; $Id: mawk04.scm,v 1.1 1998/03/16 07:58:42 foner Exp $

;+doc
; procedure: mawk:$
; arguments: pos list
; signature: int x [string] -> string
;
; Returns the element at POS in LIST or returns the empty string if
; there is no element at POS.
;-doc

(define mawk:$
  (lambda (n ss)
    (let loop ((n n) (s ss))
      (cond ((null? s) "")
	    ((zero? n) (car s))
	    (else (loop (- n 1) (cdr s)))))))

;+doc
; procedure: mawk:$0
; procedure: mawk:$1
; ...
; procedure: mawk:$9
; arguments: list
; signature: [string] -> string
;
; Returns the first, second, ... 10th element in LIST or the empty
; string if there is no element at the given position.
;-doc
(define mawk:$0 (lambda (s) (mawk:$ 0 s)))
(define mawk:$1 (lambda (s) (mawk:$ 1 s)))
(define mawk:$2 (lambda (s) (mawk:$ 2 s)))
(define mawk:$3 (lambda (s) (mawk:$ 3 s)))
(define mawk:$4 (lambda (s) (mawk:$ 4 s)))
(define mawk:$5 (lambda (s) (mawk:$ 5 s)))
(define mawk:$6 (lambda (s) (mawk:$ 6 s)))
(define mawk:$7 (lambda (s) (mawk:$ 7 s)))
(define mawk:$8 (lambda (s) (mawk:$ 8 s)))
(define mawk:$9 (lambda (s) (mawk:$ 9 s)))

; eof
