#ifndef _YENTA_SAVANT_H_
#define _YENTA_SAVANT_H_

#include "savantio.h"
#include "collect.h"

extern int Num_DocVecs;
/* This is the total number of documents we've ever seen. (At least, since 
 * the last time we threw out idf information. */

extern int Current_IDnum;

extern WV_Tree *Global_Tree; /* The actual database */
extern float *DVMags; /* The magnitudes of all of the DocVecs */
extern DDV_coll **DVColls; /* Documents added to a document cluster */
extern int *DVszs; /* Cluster sizes (in documents added) */
extern int DVM_max, DVM_rng;
extern DDV_coll *DocVecs;
extern char *Global_path;

extern int init_savant_yenta(char *);
extern int close_savant_yenta();
extern int save_dv(DenseDocVec *);

extern float *find_matches(DenseDocVec *);
extern void remove_doc(int);
extern void incr_dv(DenseDocVec *, int);
extern DenseDocVec *ddv_dup(DenseDocVec *);
extern void ddv_mult(DenseDocVec *, int);

extern int write_wvtree(FILE *, WV_Tree *);
extern WV_Tree *read_wvtree(FILE *);

#endif
