#ifndef _SAVANT_
#define _SAVANT_

#include <config.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#include <ctype.h>
#include <math.h>
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#include <time.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_VALUES_H
#include <values.h>
#endif

#ifdef HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

typedef struct dirent savant_direct;

/* The following is to try to maintain a standard size 
   of the data types used in the on-disk databases. */

#if (SIZEOF_INT == 4)
typedef int DB_INT;
typedef unsigned int DB_UINT;
#elif (SIZEOF_SHORT == 4)
typedef short DB_INT;
typedef unsigned short DB_UINT;
#elif (SIZEOF_LONG == 4)
typedef long DB_INT;
typedef unsigned long DB_UINT;
#else
typedef int DB_INT;
typedef unsigned int DB_UINT;
#endif

#if (SIZEOF_FLOAT == 4)
typedef float DB_FLOAT;
#elif (SIZEOF_DOUBLE == 4)
typedef double DB_FLOAT;
#else
typedef float DB_FLOAT;
#endif

#define VERSION "Savant relevance engine, ver. 1.38, 03/16/98"
/* Savant revision history
   1.0  - 07/29/96 - First "mostly stable" public release
   1.1  - 10/26/96 - Fixed two bugs: in common.c, fixed by_alpha() to actually
                     sort strings correctly, as opposed to randomly mixing 
		     them up, and in inter.c, fixed update_matches() to not
		     try to read index -1 of matches.
   1.2  - 03/16/97 - Separated savant into index and retrieve; widespread
                     modularization of internals; new eigentext work begun
   1.22 - 06/03/97 - Memory leak in writing database fixed, for a significant
                     speedup.  Brad added new "location" field to templates, as
		     well as modifying the indexing to make use of fields other
		     than "body" and "title" and modifying retrieval with options
		     for different normalization schemes
   1.23 - 06/04/97 - Not actually a descendent of 1.22 but a sibling; never released.
                     Several small bugfixes - memory leaks, array bounds violations,
                     etc.  Fixed a some serious bugs in splitting documents by 
		     template and in the use of window maps during retrieval.
		     Also added new "index_dotfiles" config variable and added new 
		     "Reject" keyword to templates.  Also contains many preparations
		     for the grafting-on of a latent-semantic indexing module to 
		     replace wordvec.
   1.25 - 06/06/97 - Intermediate version; a merge of 1.22 and 1.23.
          12/29/97 - Uses TFiDF instead of just term frequency.
   1.30 - 01/13/98 - Code base for anticipated 2.0 release
                     Includes new parsedate package, addition of "delimiter" field
		     to templates, all the new field-type tags added for ISWC/DL,
		     etc...
   1.31 - 01/15/98 - Made to work with GNU autoconf, courtesy of amu
   1.32 - 01/20/98 - Standardized types in database (DB_INT, etc.);
                     Replaced calls to fwrite/fread with fwrite_big/fread_big,
		     so that databases are in big-endian byte order;
		     Fixed many warnings, a few memory leaks.
		     Incorporated rhodes' div-by-0 bug fix in readwv.c
		     Added -d command line option
   1.33	- 01/21/98 - Separated merge.c into mmain.c and merge.c, patched merge.c 
                     routines into index.c to effect automatic split-and-merge
   1.34 - 01/??/98 - Fixed merge_dvmags() so that auto-split-and-merge actually 
                     works correctly;  also uncommented code to remove temp subdirs.
                     For the record, this is the version from which the RA-Yenta 
                     merge was propagated.
   1.35 - 02/19/98 - A semi-broken interim version; after the big merge stemming
                     from v. 1.34, we had to go through and fix all the 
		     brokenness and inconsistency.  The biggest problem was
		     in wordvec, which had to be custom-modified to satisfy 
		     some needs of Yenta.  Much of the directory structure was
		     also rearranged.  v. 1.35 features a mostly bug-free indexer
		     and a mostly broken retriever.  The code was frozen at this
		     point to allow people to play with the indexer.
   1.36 - 03/13/98 - Completely reconciled versions of index, retrieve and merge.
                     This actually fixes some weird memory corruption bugs carried 
		     over from 1.34 as well.
   1.37 - 03/13/98 - Cleaned up build system again.
   1.38 - 03/16/98 - Re-fixed a problem with retrieval, an array bounds overread
                     in wordvec/readwv_ra.c.  

*/

#endif


