#ifndef CLASS_DEFINE
struct client_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  UINT32 block_size;
  char * id_comment;
  struct randomness *random;
  struct make_kexinit *init;
  struct packet_handler *kexinit_handler;
};
extern struct lsh_class client_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_client_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_callback *i = (struct client_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->kexinit_handler);
}

struct lsh_class client_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "client_callback", sizeof(struct client_callback),
  do_client_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct client_line_handler
{
  struct line_handler super;
  struct ssh_connection *connection;
};
extern struct lsh_class client_line_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_client_line_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_line_handler *i = (struct client_line_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class client_line_handler_class =
{ STATIC_HEADER,
  &line_handler_class, "client_line_handler", sizeof(struct client_line_handler),
  do_client_line_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct accept_service_handler
{
  struct packet_handler super;
  int service_name;
  struct ssh_service *service;
};
extern struct lsh_class accept_service_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_accept_service_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct accept_service_handler *i = (struct accept_service_handler *) o;
  mark((struct lsh_object *) i->service);
}

struct lsh_class accept_service_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "accept_service_handler", sizeof(struct accept_service_handler),
  do_accept_service_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct service_request
{
  struct ssh_service super;
  int service_name;
  struct ssh_service *service;
};
extern struct lsh_class service_request_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_service_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct service_request *i = (struct service_request *) o;
  mark((struct lsh_object *) i->service);
}

struct lsh_class service_request_class =
{ STATIC_HEADER,
  &ssh_service_class, "service_request", sizeof(struct service_request),
  do_service_request_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct client_session
{
  struct ssh_channel super;
  int final_request;
  struct lsh_string *args;
  struct io_fd *in;
  struct io_fd *out;
  struct io_fd *err;
  int * exit_status;
};
extern struct lsh_class client_session_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_client_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_session *i = (struct client_session *) o;
  mark((struct lsh_object *) i->in);
  mark((struct lsh_object *) i->out);
  mark((struct lsh_object *) i->err);
}

static void do_client_session_free(struct lsh_object *o)
{
  struct client_session *i = (struct client_session *) o;
  lsh_string_free(i->args);
}

struct lsh_class client_session_class =
{ STATIC_HEADER,
  &ssh_channel_class, "client_session", sizeof(struct client_session),
  do_client_session_mark,
  do_client_session_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct exit_handler
{
  struct channel_request super;
  int * exit_status;
};
extern struct lsh_class exit_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class exit_handler_class =
{ STATIC_HEADER,
  &channel_request_class, "exit_handler", sizeof(struct exit_handler),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct client_startup
{
  struct connection_startup super;
  struct ssh_channel *session;
};
extern struct lsh_class client_startup_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_client_startup_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_startup *i = (struct client_startup *) o;
  mark((struct lsh_object *) i->session);
}

struct lsh_class client_startup_class =
{ STATIC_HEADER,
  &connection_startup_class, "client_startup", sizeof(struct client_startup),
  do_client_startup_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

