#ifndef CLASS_DEFINE
struct abstract_read
{
  struct lsh_object super;
  int (*(read))(struct abstract_read **self, UINT32 length, UINT8 *buffer);
};
extern struct lsh_class abstract_read_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class abstract_read_class =
{ STATIC_HEADER,
  0, "abstract_read", sizeof(struct abstract_read),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct read_handler
{
  struct lsh_object super;
  int (*(handler))(struct read_handler **self, struct abstract_read *read);
};
extern struct lsh_class read_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class read_handler_class =
{ STATIC_HEADER,
  0, "read_handler", sizeof(struct read_handler),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct abstract_write
{
  struct lsh_object super;
  int (*(write))(struct abstract_write *self, struct lsh_string *packet);
};
extern struct lsh_class abstract_write_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class abstract_write_class =
{ STATIC_HEADER,
  0, "abstract_write", sizeof(struct abstract_write),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct abstract_write_pipe
{
  struct abstract_write super;
  struct abstract_write *next;
};
extern struct lsh_class abstract_write_pipe_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_abstract_write_pipe_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct abstract_write_pipe *i = (struct abstract_write_pipe *) o;
  mark((struct lsh_object *) i->next);
}

struct lsh_class abstract_write_pipe_class =
{ STATIC_HEADER,
  &abstract_write_class, "abstract_write_pipe", sizeof(struct abstract_write_pipe),
  do_abstract_write_pipe_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

