/* Almost all programs use these routines (implicitly) so it's a good
 * place to put the version string. */

#include "version.h"

#include "krb_locl.h"

RCSID("$Id: rw.c,v 1.5 1996/08/17 14:31:21 assar Exp $");

int
krb_get_int(void *f, u_int32_t *to, int size, int lsb)
{
    int i;
    unsigned char *from = (unsigned char *)f;

    *to = 0;
    if(lsb){
	for(i = size-1; i >= 0; i--)
	    *to = (*to << 8) | from[i];
    }else{
	for(i = 0; i < size; i++)
	    *to = (*to << 8) | from[i];
    }
    return size;
}

int
krb_put_int(u_int32_t from, void *to, int size)
{
    int i;
    unsigned char *p = (unsigned char *)to;
    for(i = size - 1; i >= 0; i--){
	p[i] = from & 0xff;
	from >>= 8;
    }
    return size;
}


/* addresses are always sent in network byte order */

int
krb_get_address(void *from, u_int32_t *to)
{
    unsigned char *p = (unsigned char*)from;
    *to = htonl((p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3]);
    return 4;
}

int
krb_put_address(u_int32_t addr, void *to)
{
    return krb_put_int(ntohl(addr), to, 4);
}

int
krb_put_string(char *from, void *to)
{
    strcpy((char *)to, from);
    return strlen(from) + 1;
}

int
krb_get_string(void *from, char *to)
{
    return krb_put_string(from, to);
}

int
krb_get_nir(void *from, char *name, char *instance, char *realm)
{
    char *p = (char *)from;

    p += krb_get_string(p, name);
    p += krb_get_string(p, instance);
    if(realm)
	p += krb_get_string(p, realm);
    return p - (char *)from;
}

int
krb_put_nir(char *name, char *instance, char *realm, void *to)
{
    char *p = (char *)to;
    p += krb_put_string(name, p);
    p += krb_put_string(instance, p);
    if(realm)
	p += krb_put_string(realm, p);
    return p - (char *)to;
}
