/* Copyright 1996 assar */

struct md5 {
  unsigned offset;
  unsigned sz;
  u_int32_t counter[4];
  u_int32_t current[16];
};

void md5_init (struct md5 *m);
void md5_update (struct md5 *m, const void *p, size_t len);
void md5_finito (struct md5 *m, void *res); /* u_int32_t res[2] */

/*
 * Functions for compatibility that have never been tested.
 */
typedef struct {
  u_int32_t i[2];		/* number of _bits_ handled mod 2^64 */
  u_int32_t buf[4];		/* scratch buffer */
  unsigned char in[64];		/* input buffer */
} MD5_CTX_PREAMBLE;

typedef struct {
  union {
    MD5_CTX_PREAMBLE preamble_;
    struct md5 d5;
  } m;
  unsigned char digest[16];     /* actual digest after MD5Final call */
} MD5_CTX;

void MD5Init (MD5_CTX *mdContext);
void MD5Update (MD5_CTX *mdContext,
		const unsigned char *inBuf,
		unsigned int inLen);
void MD5Final (MD5_CTX *mdContext);

#ifndef NO_MD5_MACROS
#define MD5Init(mdContext) md5_init(&(mdContext)->m.d5)
#define MD5Update(mdCtx, inBuf, inLen) md5_update(&(mdCtx)->m.d5, inBuf, inLen)
#define MD5Final(mdCtx) md5_finito(&(mdCtx)->m.d5, (mdCtx)->digest)
#endif
