/*
 * Copyright 1987, 1988 by the Massachusetts Institute of Technology. 
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>. 
 *
 * This program causes Kerberos tickets to be destroyed.
 * Options are: 
 *
 *   -q[uiet]	- no bell even if tickets not destroyed
 *   -f[orce]	- no message printed at all 
 *   -t		- do not destroy tokens
 */

#include "kuser_locl.h"
#include <kafs.h>

RCSID("$Id: kdestroy.c,v 1.7 1996/05/31 20:59:50 assar Exp $");

static char *pname;

static void
usage(void)
{
    fprintf(stderr, "Usage: %s [-f] [-q] [-t]\n", pname);
    exit(1);
}

int
main(int argc, char **argv)
{
    int     fflag=0, qflag=0, tflag = 0, k_errno;
    char *cp;

    cp = strrchr (argv[0], '/');
    if (cp == NULL)
	pname = argv[0];
    else
	pname = cp+1;

    if (argc > 2)
	usage();
    else if (argc == 2) {
	if (!strcmp(argv[1], "-f"))
	    ++fflag;
	else if (!strcmp(argv[1], "-q"))
	    ++qflag;
	else if (!strcmp(argv[1], "-t"))
	    ++tflag;
	else
	    usage();
    }

    k_errno = dest_tkt();

    if(!tflag && k_hasafs())
      k_unlog();

    if (fflag) {
	if (k_errno != 0 && k_errno != RET_TKFIL)
	    exit(1);
	else
	    exit(0);
    } else {
	if (k_errno == 0)
	    printf("Tickets destroyed.\n");
	else if (k_errno == RET_TKFIL)
	    fprintf(stderr, "No tickets to destroy.\n");
	else {
	    fprintf(stderr, "Tickets NOT destroyed.\n");
	    if (!qflag)
		fprintf(stderr, "\007");
	    exit(1);
	}
    }
    exit(0);
}
