#include "kauth.h"

RCSID("$Id: encdata.c,v 1.5 1996/05/30 21:43:02 joda Exp $");

int
write_encrypted (int fd, void *buf, size_t len, des_key_schedule schedule,
		 des_cblock *session, struct sockaddr_in *me,
		 struct sockaddr_in *him)
{
     void *outbuf;
     int32_t outlen, l;
     int i;
     unsigned char tmp[4];

     outbuf = malloc(len + 30);
     if (outbuf == NULL)
	  return -1;
     outlen = krb_mk_priv (buf, outbuf, len, schedule, session, me, him);
     if (outlen < 0) {
	  free(outbuf);
	  return -1;
     }
     l = outlen;
     for(i = 3; i >= 0; i--, l = l >> 8)
	 tmp[i] = l & 0xff;
     if (krb_net_write (fd, tmp, 4) != 4 ||
	 krb_net_write (fd, outbuf, outlen) != outlen) {
	  free(outbuf);
	  return -1;
     }
     
     free(outbuf);
     return 0;
}


int
read_encrypted (int fd, void *buf, size_t len, void **ret,
		des_key_schedule schedule, des_cblock *session,
		struct sockaddr_in *him, struct sockaddr_in *me)
{
     int status;
     int32_t l;
     MSG_DAT msg;
     unsigned char tmp[4];

     if (krb_net_read(fd, tmp, 4) != 4)
	  return -1;
     l = (tmp[0] << 24) | (tmp[1] << 16) | (tmp[2] << 8) | tmp[3];
     if (l > len)
	  return -1;
     if (krb_net_read (fd, buf, l) != l)
	  return -1;
     status = krb_rd_priv (buf, l, schedule, session, him, me, &msg);
     if (status != RD_AP_OK) {
	  fprintf (stderr, "read_encrypted: %s\n",
		   krb_get_err_text(status));
	  return -1;
     }
     *ret  = msg.app_data;
     return  msg.app_length;
}
