#include <stdio.h>
#include "des.h"

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;

#define ITERATIONS 16
#define HALF_ITERATIONS 8

#if defined(sun) || defined(vax)
#define memmove(a,b,c) bcopy(b,a,c);
#endif

#if defined(MSDOS)
#define bcopy(b,a,c)	memmove(a,b,c)
#define bzero(a,c)	memset(a,0,c)
#define bcmp(a,b,c)	memcmp(a,b,c)
#define register

typedef union lb_un
	{
	ulong l;
	ushort s[2];
	uchar c[4];
	} LB;
#endif

/* used in des_read and des_write */
#define MAXWRITE	(1024*16)
#define BSIZE		(MAXWRITE+4)

#define c2l(c,l)	(l =((ulong)(*((c)++)))    , \
			 l|=((ulong)(*((c)++)))<< 8, \
			 l|=((ulong)(*((c)++)))<<16, \
			 l|=((ulong)(*((c)++)))<<24)

/* NOTE - c is not incremented as per c2l */
#define c2ln(c,l1,l2,n)	{ \
			c+=n; \
			l1=l2=0; \
			switch (n) { \
			case 7: l2|=((ulong)(*(--(c))))<<16; \
			case 6: l2|=((ulong)(*(--(c))))<< 8; \
			case 5: l2|=((ulong)(*(--(c))));     \
			case 4: l1|=((ulong)(*(--(c))))<<24; \
			case 3: l1|=((ulong)(*(--(c))))<<16; \
			case 2: l1|=((ulong)(*(--(c))))<< 8; \
			case 1: l1|=((ulong)(*(--(c))));     \
				} \
			}

#define l2c(l,c)	(*((c)++)=(uchar)(((l)    )&0xff), \
			 *((c)++)=(uchar)(((l)>> 8)&0xff), \
			 *((c)++)=(uchar)(((l)>>16)&0xff), \
			 *((c)++)=(uchar)(((l)>>24)&0xff))

/* NOTE - c is not incremented as per l2c */
#define l2cn(l1,l2,c,n)	{ \
			c+=n; \
			switch (n) { \
			case 7: *(--(c))=(uchar)(((l2)>>16)&0xff); \
			case 6: *(--(c))=(uchar)(((l2)>> 8)&0xff); \
			case 5: *(--(c))=(uchar)(((l2)    )&0xff); \
			case 4: *(--(c))=(uchar)(((l1)>>24)&0xff); \
			case 3: *(--(c))=(uchar)(((l1)>>16)&0xff); \
			case 2: *(--(c))=(uchar)(((l1)>> 8)&0xff); \
			case 1: *(--(c))=(uchar)(((l1)    )&0xff); \
				} \
			}

