package POE::XS::Loop::Poll;
use strict;
use vars qw(@ISA $VERSION);
BEGIN {
  unless (defined &POE::Kernel::TRACE_CALLS) {
    # we ignore TRACE_DEFAULT, since it's not really standard POE and it's
    # noisy
    *POE::Kernel::TRACE_CALLS = sub () { 0 };
  }
  $VERSION = '0.001';
  eval {
    # try XSLoader first, DynaLoader has annoying baggage
    require XSLoader;
    XSLoader::load('POE::XS::Loop::Poll' => $VERSION);
    1;
  } or do {
    require DynaLoader;
    push @ISA, 'DynaLoader';
    bootstrap POE::XS::Loop::Poll $VERSION;
  }
}

require POE::Loop::PerlSignals;

if ((POE::Kernel::TRACE_FILES() || POE::Kernel::TRACE_EVENTS()) 
    && !tracing_enabled()) {
  print POE::Kernel::TRACE_FILE "<xx> ", __PACKAGE__, " was built without tracing enabled, build with perl Makefile.PL --trace to enable tracing\n";
}

# everything else is XS
1;

__END__

=head1 NAME

POE::XS::Loop::Poll - an XS implementation of POE::Loop, using poll(2).

=head1 SYNOPSIS

  use POE::Kernel { loop => 'POE::XS::Loop::Poll' };

=head1 DESCRIPTION

This class is an implementation of the abstract POE::Loop interface
written in C using the poll(2) system call.

Signals are left to POE::Loop::PerlSignals.

=head1 SEE ALSO

POE, POE::Kernel, POE::Loop.

=head1 BUGS

Relies upon small fd numbers, but then a lot of code does.

Will fail badly if your code uses POE from more than one Perl thread.

=head1 LICENSE

POE::XS::Loop::Poll is licensed under the same terms as Perl itself.

=head1 AUTHOR

Tony Cook <tonyc@cpan.org>

=cut

=for poe_tests

sub skip_tests {
  $ENV{POE_EVENT_LOOP} = "POE::XS::Loop::Poll";
  return;
}

=cut
