package Data::Sah::Lang::zh_CN;

our $DATE = '2015-05-13'; # DATE
our $VERSION = '0.56'; # VERSION

use 5.010;
use strict;
use warnings;

use Tie::IxHash;

# currently incomplete

our %translations;
tie %translations, 'Tie::IxHash', (

    # punctuations

    q[ ], # inter-word boundary
    q[],

    q[, ],
    q[ï¼],

    q[: ],
    q[ï¼],

    q[. ],
    q[ã],

    q[(],
    q[ï¼],

    q[)],
    q[ï¼],

    # modal verbs

    q[must],
    q[å¿é¡»],

    q[must not],
    q[å¿é¡»ä¸],

    q[should],
    q[åº],

    q[should not],
    q[åºä¸],

    # field/fields/argument/arguments

    q[field],
    q[å­æ®µ],

    q[fields],
    q[å­æ®µ],

    q[argument],
    q[åæ°],

    q[arguments],
    q[åæ°],

    # multi

    q[%s and %s],
    q[%så%s],

    q[%s or %s],
    q[%sæ%s],

    q[one of %s],
    q[è¿äºå¼%sä¹ä¸],

    q[all of %s],
    q[ææè¿äºå¼%s],

    q[%(modal_verb)s satisfy all of the following],
    q[%(modal_verb)sæ»¡è¶³ææè¿äºæ¡ä»¶],

    q[%(modal_verb)s satisfy one of the following],
    q[%(modal_verb)sæ»¡è¶³è¿äºæ¡ä»¶ä¹ä¸],

    q[%(modal_verb)s satisfy none of the following],
    q[%(modal_verb_neg)sæ»¡è¶³ææè¿äºæ¡ä»¶],

    # type: BaseType

    # type: Sortable

    # type: Comparable

    # type: HasElems

    # type: num

    # type: int

    q[integer],
    q[æ´æ°],

    q[integers],
    q[æ´æ°],

    q[%(modal_verb)s be divisible by %s],
    q[%(modal_verb)sè¢«%sæ´é¤],

    q[%(modal_verb)s leave a remainder of %2$s when divided by %1$s],
    q[é¤ä»¥%1$sæ¶ä½æ°%(modal_verb)sä¸º%2$s],

);

1;
# ABSTRACT: zh_CN locale

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Sah::Lang::zh_CN - zh_CN locale

=head1 VERSION

This document describes version 0.56 of Data::Sah::Lang::zh_CN (from Perl distribution Perinci-CmdLine-Any-Bundled version 0.01), released on 2015-05-13.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Data-Sah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Data-Sah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Data-Sah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
