#!/bin/sh
#
#  RunBrokers - Runs the Harvest brokers without a starting an 
#  immediate collection.  Sleep between each run so to stagger
#  the cleaning times.
#
#  This can be executed from your system startup scritps.  Use something like:
#
#       su harvest -c '/usr/local/harvest/lib/broker/RunBrokers'
#
#  NOTE: this is simply a sample script.  It will likely require modification
#  for your local installation.
#

# Set this to your list of brokers
#
brokers='broker-A broker-B broker-C'


cd /
umask 002

HARVEST_HOME=/usr/local/harvest
PATH="$HARVEST_HOME/bin:$HARVEST_HOME/lib/broker:$HARVEST_HOME/lib:$PATH"
TMPDIR=/tmp

export PATH HARVEST_HOME TMPDIR

for  b in $brokers; do
	if [ -x $HARVEST_HOME/brokers/$b/RunBroker ]; then
        	$HARVEST_HOME/brokers/$b/RunBroker -nocol > /dev/null 2>&1
        	sleep 30
	fi
done

exit 0
