: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  

# -----------------------------------------------------------------
# cgi.pl
# 
# Author: Mic Bowman
#
# CGI library routines.
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# Globals
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# CGIParse -- from cgi-lib, parses the POST and GET arguments
# -----------------------------------------------------------------
sub CGIParse {
    if (@_) {
	local (*in) = @_;
    }

    local ($i, $loc, $key, $val);

    # Read in text
    if ($ENV{'REQUEST_METHOD'} eq "POST") {
	for ($i = 0; $i < $ENV{'CONTENT_LENGTH'}; $i++) {
	    $in .= getc;
	}
    } elsif ($ENV{'REQUEST_METHOD'} eq "GET") {
	$in = $ENV{'QUERY_STRING'};
    } else {
	&CGIError("This program processes POST and GET messages only.");
    }

    @in = split(/&/,$in);

    foreach $i (0 .. $#in) {
	# Convert plus's to spaces
	$in[$i] =~ s/\+/ /g;

	# Convert %XX from hex numbers to alphanumeric
	$in[$i] =~ s/%(..)/pack("c",hex($1))/ge;

	# Split into key and value.
	$loc = index($in[$i],"=");
	$key = substr($in[$i],0,$loc);
	$val = substr($in[$i],$loc+1);
	$in{$key} .= '&' if (defined($in{$key})); # \0 is the separator
	$in{$key} .= $val;
    }

    return 1; # just for fun
}

# -----------------------------------------------------------------
# CGIError -- prints a nicely formated error message
# -----------------------------------------------------------------
sub CGIError {
    local($msg) = @_;

    print STDOUT <<EOM;
<HTML>
<HEAD>
<TITLE>Script Processing Error</TITLE>
</HEAD>
<BODY>
<H1>Script Processing Error</H1>
An error occured while processing the request:
<PRE>
    <B>$msg</B>
</PRE>
</BODY>
</HTML>
EOM
    exit(1);
}

# -----------------------------------------------------------------
# CGIHeader -- Mime content header
# -----------------------------------------------------------------
sub CGIHeader {
    print "HTTP/1.0 200 OK\n";
    print "MIME-Version: 1.0\n";
    print "Content-Type: text/html\n";
    print "Content-Transfer-Encoding: binary\n";
    print "\n";
}

# -----------------------------------------------------------------
1
